/*
 * Decompiled with CFR 0.152.
 */
package pl.edu.icm.unicore.uvos.db;

import eu.unicore.util.Log;
import java.util.List;
import org.apache.ibatis.exceptions.PersistenceException;
import org.apache.ibatis.session.SqlSession;
import org.apache.log4j.Logger;
import pl.edu.icm.unicore.uvos.api.exceptions.InternalException;
import pl.edu.icm.unicore.uvos.model.NotifyBean;

public class DBNotification {
    private static final Logger log = Log.getLogger((String)"unicore.uvos.server", DBNotification.class);

    public List<?> getNotifications(String action, SqlSession sqlMap) throws InternalException {
        try {
            if (action == null) {
                return sqlMap.selectList("getAllNotifications");
            }
            return sqlMap.selectList("getNotifications", (Object)action);
        }
        catch (PersistenceException e) {
            log.error((Object)("DB error: Can't get notifications list: " + (Object)((Object)e)));
            throw new InternalException("DB error: Can't get notifications list: " + (Object)((Object)e));
        }
    }

    public void addNotification(String action, String groupFilter, String rcpts, SqlSession sqlMap) throws InternalException {
        NotifyBean nb = new NotifyBean();
        nb.setOperation(action);
        nb.setGroupFilter(groupFilter);
        nb.setRecipients(rcpts);
        try {
            sqlMap.insert("insertNotify", (Object)nb);
        }
        catch (PersistenceException e) {
            log.error((Object)("DB error: Can't add notification: " + (Object)((Object)e)));
            throw new InternalException("DB error: Can't add notification: " + (Object)((Object)e));
        }
    }

    public void removeNotification(int id, SqlSession sqlMap) throws InternalException {
        try {
            sqlMap.delete("deleteNotify", (Object)id);
        }
        catch (PersistenceException e) {
            log.error((Object)("DB error: Can't delete notification " + id + ": " + (Object)((Object)e)));
            throw new InternalException("DB error: Can't delete notification" + id + ": " + (Object)((Object)e));
        }
    }

    public String getNotificationGroup(int id, SqlSession sqlMap) throws InternalException {
        try {
            return (String)sqlMap.selectOne("getNotificationGroup", (Object)id);
        }
        catch (PersistenceException e) {
            log.error((Object)("DB error: Can't get notification group for id " + id + ": " + (Object)((Object)e)));
            throw new InternalException("DB error: Can't get notification group for id " + id + ": " + (Object)((Object)e));
        }
    }
}

