/*
 * Decompiled with CFR 0.152.
 */
package pl.edu.icm.unicore.uvos.db;

import eu.unicore.util.Log;
import java.util.Hashtable;
import java.util.List;
import java.util.Vector;
import org.apache.ibatis.exceptions.PersistenceException;
import org.apache.ibatis.session.SqlSession;
import org.apache.log4j.Logger;
import pl.edu.icm.unicore.uvos.api.IdentityType;
import pl.edu.icm.unicore.uvos.api.exceptions.InternalException;
import pl.edu.icm.unicore.uvos.api.exceptions.UnsupportedTypeException;
import pl.edu.icm.unicore.uvos.db.DB;
import pl.edu.icm.unicore.uvos.model.IdentityTypeBean;

public class DBIdentityTypes {
    private static final Logger log = Log.getLogger((String)"unicore.uvos.server", DBIdentityTypes.class);
    private Hashtable<String, IdentityTypeBean> identityTypes;
    private Hashtable<Integer, IdentityType> identityTypes2;
    private Vector<IdentityType> identityTypesL;

    public DBIdentityTypes(DB db) throws InternalException {
        SqlSession sqlMap = db.getSqlSession();
        this.identityTypes = new Hashtable();
        this.identityTypes2 = new Hashtable();
        this.identityTypesL = new Vector();
        try {
            List idTypes = sqlMap.selectList("getAllIdentityTypes");
            for (Object o : idTypes) {
                IdentityTypeBean ib = (IdentityTypeBean)o;
                IdentityType it = new IdentityType(ib.getType());
                this.identityTypes.put(ib.getType(), ib);
                this.identityTypesL.add(it);
                this.identityTypes2.put(ib.getId(), it);
            }
        }
        catch (PersistenceException e) {
            log.error((Object)("DB error: getting types. SQL error is: " + (Object)((Object)e)));
            throw new InternalException("Can't load identity types.");
        }
        finally {
            db.releaseSqlSession(sqlMap);
        }
    }

    public IdentityType getIdentityType4Id(int id) {
        return this.identityTypes2.get(id);
    }

    public List<IdentityType> getIdentityTypes() {
        return this.identityTypesL;
    }

    public int getIdentityTypeId(String name) throws UnsupportedTypeException {
        IdentityTypeBean b = this.identityTypes.get(name);
        if (b == null) {
            throw new UnsupportedTypeException();
        }
        return b.getId();
    }
}

