/*
 * Decompiled with CFR 0.152.
 */
package pl.edu.icm.unicore.uvos.db;

import eu.unicore.util.Log;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import org.apache.ibatis.exceptions.PersistenceException;
import org.apache.ibatis.session.SqlSession;
import org.apache.log4j.Logger;
import pl.edu.icm.unicore.uvos.api.Attribute;
import pl.edu.icm.unicore.uvos.api.AttributeType;
import pl.edu.icm.unicore.uvos.api.Element;
import pl.edu.icm.unicore.uvos.api.Group;
import pl.edu.icm.unicore.uvos.api.Identity;
import pl.edu.icm.unicore.uvos.api.ModificationEvent;
import pl.edu.icm.unicore.uvos.api.Permissions;
import pl.edu.icm.unicore.uvos.api.exceptions.AttributeNotFoundException;
import pl.edu.icm.unicore.uvos.api.exceptions.ElementAlreadyExistsException;
import pl.edu.icm.unicore.uvos.api.exceptions.ElementNotKnownException;
import pl.edu.icm.unicore.uvos.api.exceptions.GroupNotEmptyException;
import pl.edu.icm.unicore.uvos.api.exceptions.GroupNotKnownException;
import pl.edu.icm.unicore.uvos.api.exceptions.IdentityNotKnownException;
import pl.edu.icm.unicore.uvos.api.exceptions.InternalException;
import pl.edu.icm.unicore.uvos.api.exceptions.InvalidValueException;
import pl.edu.icm.unicore.uvos.api.exceptions.SecurityException;
import pl.edu.icm.unicore.uvos.api.exceptions.UnsupportedTypeException;
import pl.edu.icm.unicore.uvos.db.DB;
import pl.edu.icm.unicore.uvos.db.DBApps;
import pl.edu.icm.unicore.uvos.db.DBAttributeTypes;
import pl.edu.icm.unicore.uvos.db.DBAuthz;
import pl.edu.icm.unicore.uvos.db.DBEntitiesCache;
import pl.edu.icm.unicore.uvos.db.DBGroupResolver;
import pl.edu.icm.unicore.uvos.db.DBIdentityTypes;
import pl.edu.icm.unicore.uvos.db.DBLock;
import pl.edu.icm.unicore.uvos.engine.InternalAuthorization;
import pl.edu.icm.unicore.uvos.model.AttributeBean;
import pl.edu.icm.unicore.uvos.model.AttributeWithOwnerBean;
import pl.edu.icm.unicore.uvos.model.AuthzBean;
import pl.edu.icm.unicore.uvos.model.ElementBean;
import pl.edu.icm.unicore.uvos.model.EntityBean;
import pl.edu.icm.unicore.uvos.model.GenericBean;
import pl.edu.icm.unicore.uvos.model.GroupBean;
import pl.edu.icm.unicore.uvos.model.IdentityBean;

public class DBGroups {
    private static final Logger log = Log.getLogger((String)"unicore.uvos.server", DBGroups.class);
    private DBAttributeTypes attributeTypes;
    private DBIdentityTypes identityTypes;
    private DBAuthz authz;
    private DBEntitiesCache entitiesCache;
    private DBApps dbApps;
    private DBGroupResolver groupResolver;
    private DBLock lock;
    private DB db;

    public DBGroups(DBAttributeTypes attributeTypes, DBIdentityTypes identityTypes, DBApps dbApps, DBAuthz authz, DBGroupResolver groupResolver, DBEntitiesCache entitiesCache, DBLock lock, DB db) {
        this.db = db;
        this.attributeTypes = attributeTypes;
        this.identityTypes = identityTypes;
        this.authz = authz;
        this.dbApps = dbApps;
        this.groupResolver = groupResolver;
        this.entitiesCache = entitiesCache;
        this.lock = lock;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Group addGroup(Group parent, String name, SqlSession sqlMap) throws InternalException, GroupNotKnownException, ElementAlreadyExistsException {
        this.lock.writeLock();
        try {
            int parentId = -1;
            if (parent != null) {
                GroupBean pb = this.groupResolver.resolveGroup(parent, null, sqlMap);
                parentId = pb.getId();
            }
            Group result = new Group(parent == null ? new String[]{} : parent.getPath(), name, null, null);
            try {
                this.groupResolver.resolveGroup(result, null, sqlMap);
                throw new ElementAlreadyExistsException(new Element(result, null));
            }
            catch (GroupNotKnownException e) {
                this.createGroup(parentId, name, sqlMap);
                GroupBean res = this.groupResolver.resolveGroup(name, parentId, null, sqlMap);
                result.setCreationTS((Date)res.getCreationTS());
                Group group = result;
                return group;
            }
        }
        finally {
            this.lock.writeUnlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeGroup(Group toRemove, boolean recursive, SqlSession sqlMap) throws InternalException, GroupNotKnownException, GroupNotEmptyException {
        this.lock.writeLock();
        try {
            GroupBean gb = this.groupResolver.resolveGroup(toRemove, null, sqlMap);
            if (gb.getId() == -1) {
                throw new GroupNotKnownException(toRemove);
            }
            Timestamp ts = new Timestamp(new Date().getTime());
            this.removeGroupRecursive(gb.getId(), recursive, ts, sqlMap);
        }
        finally {
            this.lock.writeUnlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Group copyGroup(GroupBean srcGb, Group newParent, String newName, boolean removeOriginal, SqlSession sqlMap) throws GroupNotKnownException, InternalException, ElementAlreadyExistsException, InvalidValueException {
        this.lock.writeLock();
        try {
            Group res;
            if (srcGb.getId() == -1) {
                throw new InvalidValueException("Can't copy root");
            }
            GroupBean newPGB = this.groupResolver.resolveGroup(newParent, null, sqlMap);
            if (newPGB.getId() == srcGb.getId()) {
                throw new InvalidValueException("Can't copy group to itself");
            }
            if (srcGb.getParent() == newPGB.getId() && newName.equals(srcGb.getName())) {
                throw new InvalidValueException("Copy destination is equal to source");
            }
            try {
                res = this.copyGroupInt(srcGb, newParent, newName, removeOriginal, sqlMap);
            }
            catch (GroupNotEmptyException e) {
                log.fatal((Object)"BUG: GroupNotEmptyExc during recursive remove", (Throwable)e);
                throw new InternalException("BUG: GroupNotEmptyExc during recursive remove");
            }
            Group group = res;
            return group;
        }
        finally {
            this.lock.writeUnlock();
        }
    }

    private Group copyGroupInt(GroupBean srcGb, Group newParent, String newName, boolean removeOriginal, SqlSession sqlMap) throws GroupNotKnownException, InternalException, ElementAlreadyExistsException, GroupNotEmptyException {
        Group result = this.addGroup(newParent, newName, sqlMap);
        GroupBean dstGb = this.groupResolver.resolveGroup(result, null, sqlMap);
        this.copyMembers(srcGb.getId(), dstGb.getId(), sqlMap);
        this.copyGroupAttributes(srcGb.getId(), dstGb.getId(), sqlMap);
        this.copyAuthz(srcGb, dstGb.getId(), sqlMap);
        List subGroups = this.getGroupSubgroupsFullRaw(srcGb.getId(), null, sqlMap);
        for (Object o : subGroups) {
            GroupBean gb = (GroupBean)o;
            this.copyGroupInt(gb, result, gb.getName(), false, sqlMap);
        }
        if (removeOriginal) {
            Timestamp ts = new Timestamp(new Date().getTime());
            this.removeGroupRecursive(srcGb.getId(), true, ts, sqlMap);
        }
        return result;
    }

    private void copyAuthz(GroupBean srcGb, int dstG, SqlSession sqlMap) throws InternalException, GroupNotKnownException {
        List<AuthzBean> authzList = this.authz.getGroupAuthZRaw(srcGb, false, sqlMap);
        for (AuthzBean ab : authzList) {
            ab.setGroupId(dstG);
            try {
                if (ab.getSpecial() != null) {
                    sqlMap.insert("insertGroupAuthZ", (Object)ab);
                    continue;
                }
                sqlMap.insert("insertSpecialAuthZ", (Object)ab);
            }
            catch (PersistenceException e) {
                log.error((Object)("DB error: Can't add authZ data for group id " + dstG + ". SQL exception is: " + (Object)((Object)e)));
                throw new InternalException("DB error: adding authZ for group id " + dstG);
            }
        }
    }

    private void copyMembers(int srcG, int dstG, SqlSession sqlMap) throws InternalException {
        List ids = this.getGroupIdentitiesFullRaw(srcG, null, sqlMap);
        GroupBean idInsParam = new GroupBean();
        idInsParam.setId(dstG);
        for (Object id : ids) {
            IdentityBean ib = (IdentityBean)id;
            EntityBean eb = null;
            try {
                eb = this.entitiesCache.getEntity4Identity(ib.getEntityId(), sqlMap);
                idInsParam.setParent(eb.getId());
            }
            catch (IdentityNotKnownException e) {
                // empty catch block
            }
            idInsParam.setCreationTS(new Timestamp(new Date().getTime()));
            try {
                sqlMap.insert("addToGroup", (Object)idInsParam);
            }
            catch (PersistenceException e) {
                String msg = "DB error: Can't add to group id " + dstG + " entity with id " + eb.getId();
                log.error((Object)(msg + ". SQL exception is: " + (Object)((Object)e)));
                throw new InternalException(msg);
            }
        }
    }

    private void copyGroupAttributes(int srcG, int dstG, SqlSession sqlMap) throws InternalException {
        List rawAttrs = null;
        try {
            rawAttrs = sqlMap.selectList("getAllGroupAttributes", (Object)srcG);
        }
        catch (PersistenceException e1) {
            String msg = "DB error: Can't retrieve group attributes for group" + srcG;
            log.warn((Object)(msg + ". SQL exception is: " + (Object)((Object)e1)));
            throw new InternalException(msg);
        }
        for (Object rAttr : rawAttrs) {
            AttributeBean attr = (AttributeBean)rAttr;
            attr.setGroupId(dstG);
            attr.setCreationTS(new Timestamp(new Date().getTime()));
            try {
                sqlMap.insert("addGroupAttribute", (Object)attr);
            }
            catch (PersistenceException e) {
                String msg = "DB error: Can't insert group attribute for group no " + dstG;
                log.warn((Object)(msg + ". SQL exception is: " + (Object)((Object)e)));
                throw new InternalException(msg);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addToGroup(Identity toAdd, Group group, SqlSession sqlMap) throws InternalException, IdentityNotKnownException, GroupNotKnownException, InvalidValueException {
        this.lock.writeLock();
        try {
            GroupBean gb;
            block8: {
                gb = this.groupResolver.resolveGroup(group, null, sqlMap);
                if (gb.getId() == -1) {
                    throw new GroupNotKnownException(group);
                }
                EntityBean eb = this.entitiesCache.getEntity4Identity(toAdd, null, sqlMap);
                gb.setParent(eb.getId());
                gb.setCreationTS(new Timestamp(new Date().getTime()));
                try {
                    if (!this.isMember(eb.getId(), gb.getId(), null, sqlMap)) break block8;
                    return;
                }
                catch (PersistenceException e) {
                    String msg = "DB error: Can't add to group " + group + " identity " + toAdd;
                    log.error((Object)(msg + ". SQL exception is: " + (Object)((Object)e)));
                    throw new InternalException(msg);
                }
            }
            sqlMap.insert("addToGroup", (Object)gb);
        }
        finally {
            this.lock.writeUnlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeFromGroup(Identity toRemove, Group group, SqlSession sqlMap) throws InternalException, IdentityNotKnownException, GroupNotKnownException, InvalidValueException {
        this.lock.writeLock();
        try {
            GroupBean gb = this.groupResolver.resolveGroup(group, null, sqlMap);
            EntityBean eb = this.entitiesCache.getEntity4Identity(toRemove, null, sqlMap);
            if (!this.isMember(eb.getId(), gb.getId(), null, sqlMap)) {
                return;
            }
            this.removeGroupMemberEntity(eb.getId(), gb.getId(), null, sqlMap);
        }
        finally {
            this.lock.writeUnlock();
        }
    }

    void removeFromAllGroups(int entityId, SqlSession sqlMap) throws InternalException {
        GroupBean gb = new GroupBean();
        gb.setRemovalTS(new Timestamp(new Date().getTime()));
        gb.setId(entityId);
        try {
            sqlMap.update("removeFromAllGroups", (Object)gb);
        }
        catch (PersistenceException e) {
            String msg = "DB error: Can't remove from all groups  entity " + entityId;
            log.error((Object)(msg + ". SQL exception is: " + (Object)((Object)e)));
            throw new InternalException(msg);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void setAttribute(Group whom, Attribute toAdd, boolean update, SqlSession sqlMap) throws InternalException, ElementAlreadyExistsException, GroupNotKnownException {
        this.lock.writeLock();
        try {
            int typeId;
            AttributeBean ab = new AttributeBean();
            AttributeType type = toAdd.getType();
            try {
                typeId = this.attributeTypes.getAttrTypeId(type, true, sqlMap);
            }
            catch (UnsupportedTypeException e1) {
                log.fatal((Object)"BUG: Unsupported type thrown when type should be created.");
                throw new InternalException("BUG in set attribute");
            }
            GroupBean gb = this.groupResolver.resolveGroup(whom, null, sqlMap);
            if (gb.getId() == -1) {
                throw new GroupNotKnownException(whom);
            }
            ab.setGroupId(gb.getId());
            ab.setCreationTS(new Timestamp(new Date().getTime()));
            ab.setTypeId(typeId);
            ab.setInactive(0);
            List<AttributeBean> rawAttrs = this.getAttributes(gb.getId(), null, sqlMap);
            for (AttributeBean ab2 : rawAttrs) {
                if (ab2.getTypeId() != typeId || ab2.getGroupId() != ab.getGroupId()) continue;
                if (!update) {
                    throw new ElementAlreadyExistsException(new Element(null, null));
                }
                ab2.setRemovalTS(new Timestamp(new Date().getTime()));
                try {
                    sqlMap.update("removeGroupAttribute", (Object)ab2);
                }
                catch (PersistenceException e) {
                    String msg = "DB error: Can't remove (to update) group attributes of group" + whom;
                    log.warn((Object)(msg + ". SQL exception is: " + (Object)((Object)e)));
                    throw new InternalException(msg);
                }
            }
            ArrayList vals = toAdd.getValues();
            if (vals == null) {
                vals = new ArrayList();
            }
            ab.setVal(null);
            if (vals.size() == 0) {
                try {
                    sqlMap.insert("addGroupAttribute", (Object)ab);
                }
                catch (PersistenceException e) {
                    String msg = "DB error: Can't insert group attribute for group " + whom;
                    log.warn((Object)(msg + ". SQL exception is: " + (Object)((Object)e)));
                    throw new InternalException(msg);
                }
            }
            for (String val : vals) {
                ab.setVal(val);
                try {
                    sqlMap.insert("addGroupAttribute", (Object)ab);
                }
                catch (PersistenceException e) {
                    String msg = "DB error: Can't insert group attribute for group " + whom;
                    log.warn((Object)(msg + ". SQL exception is: " + (Object)((Object)e)));
                    throw new InternalException(msg);
                    return;
                }
            }
        }
        finally {
            this.lock.writeUnlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void removeAttribute(Group whom, String toRemove, SqlSession sqlMap) throws InternalException, ElementNotKnownException, UnsupportedTypeException {
        this.lock.writeLock();
        try {
            int typeId = this.attributeTypes.getAttrTypeId(toRemove);
            GroupBean gb = this.groupResolver.resolveGroup(whom, null, sqlMap);
            if (gb.getId() == -1) {
                throw new GroupNotKnownException(whom);
            }
            List<AttributeBean> rawAttrs = this.getAttributes(gb.getId(), null, sqlMap);
            for (AttributeBean ab2 : rawAttrs) {
                if (ab2.getTypeId() != typeId) continue;
                ab2.setRemovalTS(new Timestamp(new Date().getTime()));
                try {
                    sqlMap.update("removeGroupAttribute", (Object)ab2);
                }
                catch (PersistenceException e) {
                    String msg = "DB error: Can't remove group attributes of group" + whom;
                    log.warn((Object)(msg + ". SQL exception is: " + (Object)((Object)e)));
                    throw new InternalException(msg);
                    return;
                }
            }
        }
        finally {
            this.lock.writeUnlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void disableEnableAttribute(Group whom, String toDisable, String value, int how, SqlSession sqlMap) throws InternalException, ElementNotKnownException, AttributeNotFoundException {
        this.lock.writeLock();
        try {
            int typeId;
            try {
                typeId = this.attributeTypes.getAttrTypeId(toDisable);
            }
            catch (UnsupportedTypeException e1) {
                throw new AttributeNotFoundException(null);
            }
            GroupBean gb = this.groupResolver.resolveGroup(whom, null, sqlMap);
            if (gb.getId() == -1) {
                throw new GroupNotKnownException(whom);
            }
            AttributeBean ab = new AttributeBean();
            ab.setGroupId(gb.getId());
            ab.setTypeId(typeId);
            ab.setVal(value);
            ab.setInactive(how);
            try {
                int ret = value == null ? sqlMap.update("disableEnableGroupAttributes1", (Object)ab) : sqlMap.update("disableEnableGroupAttributes2", (Object)ab);
                if (ret == 0) {
                    throw new AttributeNotFoundException(toDisable);
                }
            }
            catch (PersistenceException e) {
                String msg = "DB error: Can't disable/enable group  attributes of group " + whom;
                log.warn((Object)(msg + ". SQL exception is: " + (Object)((Object)e)));
                throw new InternalException(msg);
            }
        }
        finally {
            this.lock.writeUnlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Attribute> getDisabledAttributes(Group whose, SqlSession sqlMap) throws InternalException, ElementNotKnownException {
        this.lock.writeLock();
        try {
            GroupBean gb = this.groupResolver.resolveGroup(whose, null, sqlMap);
            List rawL = null;
            try {
                rawL = sqlMap.selectList("listDisabledGroupAttributes", (Object)gb.getId());
            }
            catch (PersistenceException e) {
                String msg = "DB error: Can't list disabled group attributes of a group" + whose;
                log.warn((Object)(msg + ". SQL exception is: " + (Object)((Object)e)));
                throw new InternalException(msg);
            }
            List<Attribute> list = this.attributeTypes.prepareAttributeList(rawL, whose.toString());
            return list;
        }
        finally {
            this.lock.writeUnlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isMember(Identity who, boolean effective, Group group, Date when, SqlSession sqlMap) throws InternalException, IdentityNotKnownException, GroupNotKnownException, InvalidValueException {
        this.lock.writeLock();
        try {
            GroupBean gb = this.groupResolver.resolveGroup(group, when, sqlMap);
            EntityBean eb = this.entitiesCache.getEntity4Identity(who, when, sqlMap);
            if (effective) {
                boolean bl = this.isEffectiveMember(eb.getId(), gb, when, sqlMap);
                return bl;
            }
            boolean bl = this.isMember(eb.getId(), gb.getId(), when, sqlMap);
            return bl;
        }
        finally {
            this.lock.writeUnlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Element> getGroupContent(Group group, Date when, SqlSession sqlMap) throws InternalException, GroupNotKnownException {
        this.lock.writeLock();
        try {
            GroupBean gb = this.groupResolver.resolveGroup(group, when, sqlMap);
            List<Element> ret = this.getGroupIdentitiesFull(group, gb.getId(), when, sqlMap);
            ret.addAll(this.getGroupSubgroupsFull(group, gb.getId(), when, sqlMap));
            List<Element> list = ret;
            return list;
        }
        finally {
            this.lock.writeUnlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Attribute> getAllAttributes(Group owner, Date when, SqlSession sqlMap) throws InternalException, ElementNotKnownException {
        this.lock.writeLock();
        try {
            GroupBean gb = this.groupResolver.resolveGroup(owner, when, sqlMap);
            List<AttributeBean> attrBs = this.getAttributes(gb.getId(), when, sqlMap);
            List<Attribute> list = this.attributeTypes.prepareAttributeList(attrBs, owner.toString());
            return list;
        }
        finally {
            this.lock.writeUnlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    List<GroupBean> getGroupPath(GroupBean topGroup, GroupBean bottomGroup, SqlSession sqlMap) throws GroupNotKnownException, InternalException {
        this.lock.writeLock();
        try {
            Vector<GroupBean> ret = new Vector<GroupBean>();
            GroupBean tmp = new GroupBean();
            tmp.setId(bottomGroup.getId());
            tmp.setParent(bottomGroup.getParent());
            tmp.setCreationTS(bottomGroup.getCreationTS());
            tmp.setName(bottomGroup.getName());
            while (tmp.getId() != topGroup.getId() && tmp.getParent() != -1) {
                ret.add(tmp);
                tmp = this.groupResolver.resolveGroup4Id(tmp.getParent(), sqlMap);
            }
            if (tmp.getId() != topGroup.getId()) {
                ret.clear();
            } else {
                ret.add(tmp);
            }
            Vector<GroupBean> vector = ret;
            return vector;
        }
        finally {
            this.lock.writeUnlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<GroupBean> getAllGroupsRaw(int who, Date when, SqlSession sqlMap) throws InternalException, IdentityNotKnownException {
        this.lock.writeLock();
        try {
            List res;
            try {
                res = when == null ? sqlMap.selectList("getEntityGroups", (Object)who) : sqlMap.selectList("getEntityGroupsH", (Object)new GenericBean(who, when));
            }
            catch (PersistenceException e) {
                String msg = "DB error: Can't get groups the entity " + who + " is member of.";
                log.error((Object)(msg + ". SQL exception is: " + (Object)((Object)e)));
                throw new InternalException(msg);
            }
            Vector<GroupBean> ret = new Vector<GroupBean>();
            for (Object o : res) {
                ret.add((GroupBean)o);
            }
            Vector<GroupBean> vector = ret;
            return vector;
        }
        finally {
            this.lock.writeUnlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Group> getAllGroups(Identity who, boolean implied, Date when, SqlSession sqlMap) throws InternalException, IdentityNotKnownException, InvalidValueException {
        this.lock.writeLock();
        try {
            List<Group> list;
            EntityBean eb = this.entitiesCache.getEntity4Identity(who, when, sqlMap);
            List<GroupBean> rawGroups = this.getAllGroupsRaw(eb.getId(), when, sqlMap);
            Vector<Group> ret = new Vector<Group>();
            for (GroupBean gb : rawGroups) {
                try {
                    Group g = this.groupResolver.resolveGroupBean(gb, sqlMap);
                    ret.add(g);
                }
                catch (GroupNotKnownException e) {}
            }
            if (implied) {
                list = this.getImpliedGroups(ret);
                return list;
            }
            list = ret;
            return list;
        }
        finally {
            this.lock.writeUnlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Group> getAllReadableGroups(boolean hasGlobalReadPerm, Identity who, boolean implied, InternalAuthorization authzInternal, SqlSession sqlMap) throws IdentityNotKnownException, InternalException, InvalidValueException, SecurityException {
        this.lock.writeLock();
        try {
            EntityBean eb = this.entitiesCache.getEntity4Identity(who, null, sqlMap);
            List<GroupBean> rawGroups = this.getAllGroupsRaw(eb.getId(), null, sqlMap);
            HashSet<GroupBean> fullRawGroups = new HashSet<GroupBean>(rawGroups);
            if (implied) {
                for (GroupBean gb : rawGroups) {
                    try {
                        List<GroupBean> impliedGroups = this.groupResolver.getParentGroupBeans(gb, sqlMap);
                        fullRawGroups.addAll(impliedGroups);
                    }
                    catch (GroupNotKnownException cantHappen) {
                        log.fatal((Object)"Group not known in getAllReadableGroups - BUG", (Throwable)cantHappen);
                    }
                }
            }
            boolean self = authzInternal.isSelf(who, sqlMap);
            ArrayList<Group> ret = new ArrayList<Group>();
            for (GroupBean gb : fullRawGroups) {
                boolean groupReadable = hasGlobalReadPerm;
                try {
                    if (!groupReadable) {
                        Permissions localP = authzInternal.assemblePermissions(gb, self, sqlMap);
                        groupReadable = localP.isRead();
                    }
                    if (!groupReadable) continue;
                    Group g = this.groupResolver.resolveGroupBean(gb, sqlMap);
                    ret.add(g);
                }
                catch (GroupNotKnownException cantHappen) {
                    log.fatal((Object)"Group not known in getAllReadableGroups - BUG", (Throwable)cantHappen);
                }
            }
            ArrayList<Group> arrayList = ret;
            return arrayList;
        }
        finally {
            this.lock.writeUnlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Attribute getGroupAttribute(Group owner, String attribute, Date when, SqlSession sqlMap) throws InternalException, ElementNotKnownException, AttributeNotFoundException {
        this.lock.writeLock();
        try {
            int attrType;
            GroupBean gb = this.groupResolver.resolveGroup(owner, when, sqlMap);
            try {
                attrType = this.attributeTypes.getAttrTypeId(attribute);
            }
            catch (UnsupportedTypeException e) {
                throw new AttributeNotFoundException(attribute);
            }
            List<AttributeBean> attrBs = this.getAttribute(gb.getId(), attrType, when, sqlMap);
            if (attrBs.size() == 0) {
                throw new AttributeNotFoundException(attribute);
            }
            Attribute attribute2 = this.attributeTypes.prepareAttributeList(attrBs, owner.toString()).get(0);
            return attribute2;
        }
        finally {
            this.lock.writeUnlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    List<AttributeBean> getAttributes(int groupId, Date when, SqlSession sqlMap) throws InternalException {
        this.lock.writeLock();
        try {
            List rawAttrs = null;
            try {
                rawAttrs = when == null ? sqlMap.selectList("getGroupAttributes", (Object)groupId) : sqlMap.selectList("getGroupAttributesH", (Object)new GenericBean(groupId, when));
            }
            catch (PersistenceException e1) {
                String msg = "DB error: Can't retrieve group attributes for group" + groupId;
                log.warn((Object)(msg + ". SQL exception is: " + (Object)((Object)e1)));
                throw new InternalException(msg);
            }
            Vector<AttributeBean> ret = new Vector<AttributeBean>();
            for (Object o : rawAttrs) {
                ret.add((AttributeBean)o);
            }
            Vector<AttributeBean> vector = ret;
            return vector;
        }
        finally {
            this.lock.writeUnlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void getGroupEvents(List<ModificationEvent> list, Date from, Date to, int typeFilter, boolean fillDetails, SqlSession sqlMap) throws InternalException {
        this.lock.writeLock();
        try {
            ArrayList<Object> res1 = new ArrayList<Object>();
            ArrayList<Object> res2 = new ArrayList<Object>();
            this.getEventsGeneric(res1, res2, from, to, typeFilter, "getEventsGrp", sqlMap);
            this.convertEventsGrp(list, res1, fillDetails, ModificationEvent.TYPE.ADD, sqlMap);
            this.convertEventsGrp(list, res2, fillDetails, ModificationEvent.TYPE.REMOVE, sqlMap);
        }
        finally {
            this.lock.writeUnlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void getMembershipEvents(List<ModificationEvent> list, Date from, Date to, int typeFilter, boolean fillDetails, SqlSession sqlMap) throws InternalException {
        this.lock.writeLock();
        try {
            ArrayList<Object> res1 = new ArrayList<Object>();
            ArrayList<Object> res2 = new ArrayList<Object>();
            this.getEventsGeneric(res1, res2, from, to, typeFilter, "getEventsMem", sqlMap);
            this.convertEventsMem(list, res1, fillDetails, ModificationEvent.TYPE.ADD, sqlMap);
            this.convertEventsMem(list, res2, fillDetails, ModificationEvent.TYPE.REMOVE, sqlMap);
        }
        finally {
            this.lock.writeUnlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void getAttributeEvents(List<ModificationEvent> list, Date from, Date to, int typeFilter, boolean fillDetails, SqlSession sqlMap) throws InternalException {
        this.lock.writeLock();
        try {
            ArrayList<Object> res1 = new ArrayList<Object>();
            ArrayList<Object> res2 = new ArrayList<Object>();
            this.getEventsGeneric(res1, res2, from, to, typeFilter, "getEventsAttrGrp", sqlMap);
            this.convertEventsAttr(list, res1, fillDetails, ModificationEvent.TYPE.ADD, sqlMap);
            this.convertEventsAttr(list, res2, fillDetails, ModificationEvent.TYPE.REMOVE, sqlMap);
        }
        finally {
            this.lock.writeUnlock();
        }
    }

    private void convertEventsGrp(List<ModificationEvent> list, List<Object> res, boolean fillDetails, ModificationEvent.TYPE type, SqlSession sqlMap) throws InternalException {
        boolean add = type.equals((Object)ModificationEvent.TYPE.ADD);
        for (Object o : res) {
            GroupBean g = (GroupBean)o;
            ModificationEvent e = new ModificationEvent((Date)(add ? g.getCreationTS() : g.getRemovalTS()), ModificationEvent.CATEGORY.GROUP, type);
            if (fillDetails) {
                try {
                    e.setDescription(this.groupResolver.resolveGroupBean(g, sqlMap).toString());
                }
                catch (GroupNotKnownException e1) {
                    throw new InternalException("Problem resolving group bean", (Throwable)e1);
                }
            }
            list.add(e);
        }
    }

    private void convertEventsMem(List<ModificationEvent> list, List<Object> res, boolean fillDetails, ModificationEvent.TYPE type, SqlSession sqlMap) throws InternalException {
        boolean add = type.equals((Object)ModificationEvent.TYPE.ADD);
        for (Object o : res) {
            ElementBean g = (ElementBean)o;
            ModificationEvent e = new ModificationEvent((Date)(add ? g.getCreationTS() : g.getRemovalTS()), ModificationEvent.CATEGORY.MEMBERSHIP, type);
            if (fillDetails) {
                String grp;
                try {
                    GroupBean gb = new GroupBean();
                    gb.setId(g.getGroupId());
                    gb.setName(g.getGroupName());
                    gb.setParent(g.getParent());
                    grp = this.groupResolver.resolveGroupBean(gb, sqlMap).toString();
                }
                catch (GroupNotKnownException e1) {
                    throw new InternalException("Problem resolving group bean", (Throwable)e1);
                }
                e.setDescription("Entity: " + g.getEntityName() + " group: " + grp);
            }
            list.add(e);
        }
    }

    private void createGroup(int parent, String name, SqlSession sqlMap) throws InternalException {
        GroupBean param = new GroupBean();
        param.setName(name);
        param.setParent(parent);
        try {
            sqlMap.insert("insertGroup", (Object)param);
            try {
                param = this.groupResolver.resolveGroup(name, parent, null, sqlMap);
            }
            catch (GroupNotKnownException e) {
                // empty catch block
            }
            if (parent != -1) {
                sqlMap.insert("insertGroupChild", (Object)param);
            }
            sqlMap.clearCache();
        }
        catch (PersistenceException e) {
            String msg = "DB error: Can't add a new group " + name + " parent " + parent;
            log.error((Object)(msg + ". SQL exception is: " + (Object)((Object)e)));
            throw new InternalException(msg);
        }
    }

    private void removeGroup(int id, Timestamp ts, SqlSession sqlMap) throws InternalException {
        GroupBean param = new GroupBean();
        param.setId(id);
        if (ts == null) {
            ts = new Timestamp(new Date().getTime());
        }
        param.setRemovalTS(ts);
        try {
            sqlMap.update("deleteGroup", (Object)param);
            sqlMap.update("deleteFromSubgroups", (Object)param);
            sqlMap.clearCache();
        }
        catch (PersistenceException e) {
            String msg = "DB error: Can't delete group " + id;
            log.error((Object)(msg + ". SQL exception is: " + (Object)((Object)e)));
            throw new InternalException(msg);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isEffectiveMember(int entityId, GroupBean groupB, Date when, SqlSession sqlMap) throws InternalException, IdentityNotKnownException, GroupNotKnownException {
        this.lock.writeLock();
        try {
            List<GroupBean> entityGroups = this.getAllGroupsRaw(entityId, when, sqlMap);
            for (GroupBean gb : entityGroups) {
                List<GroupBean> ret = this.getGroupPath(groupB, gb, sqlMap);
                if (ret.size() <= 0) continue;
                boolean bl = true;
                return bl;
            }
            boolean bl = false;
            return bl;
        }
        finally {
            this.lock.writeUnlock();
        }
    }

    private boolean isMember(int entityId, int groupId, Date when, SqlSession sqlMap) throws InternalException {
        Object ret;
        GroupBean gb = new GroupBean();
        gb.setId(groupId);
        gb.setParent(entityId);
        try {
            if (when == null) {
                ret = sqlMap.selectOne("isMember", (Object)gb);
            } else {
                gb.setRemovalTS(new Timestamp(when.getTime()));
                ret = sqlMap.selectOne("isMemberH", (Object)gb);
            }
        }
        catch (PersistenceException e) {
            String msg = "DB error: Can't check memebership of " + entityId + " in group " + groupId;
            log.error((Object)(msg + ". SQL exception is: " + (Object)((Object)e)));
            throw new InternalException(msg);
        }
        return ret != null;
    }

    private void removeGroupRecursive(int groupId, boolean recursive, Timestamp ts, SqlSession sqlMap) throws InternalException, GroupNotEmptyException {
        List<Integer> subgroups = this.getGroupSubgroups(groupId, sqlMap);
        List<Integer> entities = this.getGroupEntities(groupId, sqlMap);
        boolean isEmpty = true;
        if (subgroups.size() > 0 || entities.size() > 0) {
            isEmpty = false;
        }
        if (!isEmpty) {
            if (!recursive) {
                throw new GroupNotEmptyException();
            }
            for (Integer subId : subgroups) {
                this.removeGroupRecursive(subId, recursive, ts, sqlMap);
            }
            for (Integer entityId : entities) {
                this.removeGroupMemberEntity(entityId, groupId, ts, sqlMap);
            }
        }
        AttributeBean ab = new AttributeBean();
        ab.setRemovalTS(ts);
        ab.setId(groupId);
        try {
            sqlMap.update("removeAllGroupAttributes", (Object)ab);
        }
        catch (PersistenceException e) {
            String msg = "DB error: Can't remove all group attributes for group" + groupId;
            log.warn((Object)(msg + ". SQL exception is: " + (Object)((Object)e)));
            throw new InternalException(msg);
        }
        GroupBean gb = new GroupBean();
        gb.setId(groupId);
        gb.setRemovalTS(ts);
        try {
            sqlMap.update("removeGroupBoundEntityAttributes", (Object)gb);
        }
        catch (PersistenceException e) {
            String msg = "DB error: Can't remove group bound entity attributes for group " + groupId;
            log.error((Object)(msg + ". SQL exception is: " + (Object)((Object)e)));
            throw new InternalException(msg);
        }
        this.removeGroupAuthZ(groupId, sqlMap);
        this.dbApps.removeAppFormsByGroup(groupId, sqlMap);
        this.removeGroup(groupId, ts, sqlMap);
    }

    private void removeGroupAuthZ(int groupId, SqlSession sqlMap) throws InternalException {
        try {
            sqlMap.delete("removeGroupAuthZAttr", (Object)groupId);
        }
        catch (PersistenceException e) {
            String msg = "DB error: Can't remove group authZ data for group " + groupId;
            log.error((Object)(msg + ". SQL exception is: " + (Object)((Object)e)));
            throw new InternalException(msg);
        }
        try {
            sqlMap.delete("removeGroupAuthZSpecial", (Object)groupId);
        }
        catch (PersistenceException e) {
            String msg = "DB error: Can't remove group authZ Owner data for group " + groupId;
            log.error((Object)(msg + ". SQL exception is: " + (Object)((Object)e)));
            throw new InternalException(msg);
        }
    }

    private void removeGroupMemberEntity(int entityId, int groupId, Timestamp ts, SqlSession sqlMap) throws InternalException {
        GroupBean gb = new GroupBean();
        gb.setId(groupId);
        if (ts == null) {
            ts = new Timestamp(new Date().getTime());
        }
        gb.setRemovalTS(ts);
        gb.setParent(entityId);
        try {
            sqlMap.update("removeFromGroup", (Object)gb);
        }
        catch (PersistenceException e) {
            String msg = "DB error: Can't remove from group " + groupId + " identity " + entityId;
            log.error((Object)(msg + ". SQL exception is: " + (Object)((Object)e)));
            throw new InternalException(msg);
        }
    }

    private List<AttributeBean> getAttribute(int groupId, int typeId, Date when, SqlSession sqlMap) throws InternalException {
        List rawAttrs = null;
        AttributeBean param = new AttributeBean();
        param.setGroupId(groupId);
        param.setTypeId(typeId);
        try {
            if (when == null) {
                rawAttrs = sqlMap.selectList("getGroupAttribute", (Object)param);
            } else {
                param.setRemovalTS(new Timestamp(when.getTime()));
                rawAttrs = sqlMap.selectList("getGroupAttributeH", (Object)param);
            }
        }
        catch (PersistenceException e1) {
            String msg = "DB error: Can't retrieve group attributes for group" + groupId;
            log.warn((Object)(msg + ". SQL exception is: " + (Object)((Object)e1)));
            throw new InternalException(msg);
        }
        Vector<AttributeBean> ret = new Vector<AttributeBean>();
        for (Object o : rawAttrs) {
            ret.add((AttributeBean)o);
        }
        return ret;
    }

    private List<Integer> getGroupEntities(int groupId, SqlSession sqlMap) throws InternalException {
        List rawAttrs = null;
        try {
            rawAttrs = sqlMap.selectList("getGroupEntities", (Object)groupId);
        }
        catch (PersistenceException e1) {
            String msg = "DB error: Can't retrieve group entities for group" + groupId;
            log.warn((Object)(msg + ". SQL exception is: " + (Object)((Object)e1)));
            throw new InternalException(msg);
        }
        Vector<Integer> ret = new Vector<Integer>();
        for (Object o : rawAttrs) {
            ret.add((Integer)o);
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Integer> getGroupSubgroups(int groupId, SqlSession sqlMap) throws InternalException {
        this.lock.writeLock();
        try {
            List rawAttrs = null;
            try {
                rawAttrs = sqlMap.selectList("getGroupSubgroups", (Object)groupId);
            }
            catch (PersistenceException e1) {
                String msg = "DB error: Can't retrieve group subgroups for group" + groupId;
                log.warn((Object)(msg + ". SQL exception is: " + (Object)((Object)e1)));
                throw new InternalException(msg);
            }
            Vector<Integer> ret = new Vector<Integer>();
            for (Object o : rawAttrs) {
                ret.add((Integer)o);
            }
            Vector<Integer> vector = ret;
            return vector;
        }
        finally {
            this.lock.writeUnlock();
        }
    }

    private List<Element> getGroupIdentitiesFull(Group g, int groupId, Date when, SqlSession sqlMap) throws InternalException {
        List raw = this.getGroupIdentitiesFullRaw(groupId, when, sqlMap);
        Vector<Element> ret = new Vector<Element>();
        for (Object o : raw) {
            IdentityBean ib = (IdentityBean)o;
            EntityBean eb = null;
            try {
                eb = this.entitiesCache.getEntity4Identity(ib.getId(), sqlMap);
            }
            catch (IdentityNotKnownException e) {
                throw new InternalException("BUG: Identity not known", (Throwable)e);
            }
            Identity i = new Identity(this.identityTypes.getIdentityType4Id(ib.getTypeId()), ib.getValue(), eb.getName(), (Date)ib.getCreationTS(), null);
            ret.add(new Element(null, i));
        }
        return ret;
    }

    private List getGroupIdentitiesFullRaw(int groupId, Date when, SqlSession sqlMap) throws InternalException {
        List raw = null;
        try {
            raw = when == null ? sqlMap.selectList("getGroupIdentities", (Object)groupId) : sqlMap.selectList("getGroupIdentitiesH", (Object)new GenericBean(groupId, when));
            return raw;
        }
        catch (PersistenceException e1) {
            String msg = "DB error: Can't retrieve group identities for group id " + groupId;
            log.warn((Object)(msg + ". SQL exception is: " + (Object)((Object)e1)));
            throw new InternalException(msg);
        }
    }

    private List<Element> getGroupSubgroupsFull(Group parent, int groupId, Date when, SqlSession sqlMap) throws InternalException {
        List raw = this.getGroupSubgroupsFullRaw(groupId, when, sqlMap);
        Vector<Element> ret = new Vector<Element>();
        if (parent == null) {
            parent = new Group(new String[0]);
        }
        for (Object o : raw) {
            GroupBean gb = (GroupBean)o;
            Group g = new Group((parent.isTopLevel() ? "" : parent.toString()) + "/" + gb.getName());
            ret.add(new Element(g, null));
        }
        return ret;
    }

    private List getGroupSubgroupsFullRaw(int groupId, Date when, SqlSession sqlMap) throws InternalException {
        List raw = null;
        try {
            raw = when == null ? (groupId != -1 ? sqlMap.selectList("getGroupSubgroupsFull", (Object)groupId) : sqlMap.selectList("getTopGroupsFull")) : (groupId != -1 ? sqlMap.selectList("getGroupSubgroupsFullH", (Object)new GenericBean(groupId, when)) : sqlMap.selectList("getTopGroupsFullH", (Object)new GenericBean(when)));
            return raw;
        }
        catch (PersistenceException e1) {
            String msg = "DB error: Can't retrieve group subgroups for group" + groupId;
            log.warn((Object)(msg + ". SQL exception is: " + (Object)((Object)e1)));
            throw new InternalException(msg);
        }
    }

    private List<Group> getImpliedGroups(List<Group> base) {
        HashSet<String> allG = new HashSet<String>();
        for (Group g : base) {
            String name = g.toString();
            allG.add(name);
            int n = name.lastIndexOf(47);
            while (n > 0) {
                if (!allG.contains(name = name.substring(0, n))) {
                    allG.add(name);
                }
                n = name.lastIndexOf(47);
            }
        }
        Iterator it = allG.iterator();
        base.clear();
        while (it.hasNext()) {
            base.add(new Group((String)it.next()));
        }
        return base;
    }

    void getEventsGeneric(List<Object> res1, List<Object> res2, Date from, Date to, int typeFilter, String cmd, SqlSession sqlMap) throws InternalException {
        GenericBean param = new GenericBean(from, to);
        try {
            if ((typeFilter & 1 << ModificationEvent.TYPE.ADD.ordinal()) != 0) {
                res1.addAll(sqlMap.selectList(cmd + "Add", (Object)param));
            }
            if ((typeFilter & 1 << ModificationEvent.TYPE.REMOVE.ordinal()) != 0) {
                res2.addAll(sqlMap.selectList(cmd + "Del", (Object)param));
            }
        }
        catch (PersistenceException e) {
            String msg = "DB error: Can't get list of history events.";
            log.warn((Object)(msg + " Operation: " + cmd + ". SQL exception is: " + (Object)((Object)e)));
            throw new InternalException(msg);
        }
    }

    void convertEventsAttr(List<ModificationEvent> list, List<Object> res, boolean fillDetails, ModificationEvent.TYPE type, SqlSession sqlMap) throws InternalException {
        boolean add = type.equals((Object)ModificationEvent.TYPE.ADD);
        for (Object o : res) {
            AttributeWithOwnerBean g = (AttributeWithOwnerBean)o;
            ModificationEvent e = new ModificationEvent((Date)(add ? g.getCreationTS() : g.getRemovalTS()), ModificationEvent.CATEGORY.ATTRIBUTE, type);
            if (fillDetails) {
                String grp = null;
                String entity = null;
                if (g.getGroupId() != -1) {
                    try {
                        GroupBean gb = new GroupBean();
                        gb.setId(g.getGroupId());
                        gb.setName(g.getGroupName());
                        gb.setParent(g.getParent());
                        grp = this.groupResolver.resolveGroupBean(gb, sqlMap).toString();
                    }
                    catch (GroupNotKnownException e1) {
                        throw new InternalException("Problem resolving group bean", (Throwable)e1);
                    }
                }
                if (g.getEntityId() != -1) {
                    entity = g.getEntityName();
                }
                String a = this.attributeTypes.getAttrType4Id(g.getAttrTypeId());
                String owner = "";
                owner = grp != null && entity == null ? "group: " + grp : (grp != null && entity != null ? "entity: " + entity + " in scope of group: " + grp : "entity: " + entity);
                e.setDescription("Attribute: " + a + " value: " + g.getAttrVal() + " owned by: " + owner);
            }
            list.add(e);
        }
    }
}

