/*
 * Decompiled with CFR 0.152.
 */
package pl.edu.icm.unicore.uvos.db;

import eu.unicore.util.Log;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.apache.ibatis.exceptions.PersistenceException;
import org.apache.ibatis.session.SqlSession;
import org.apache.log4j.Logger;
import pl.edu.icm.unicore.uvos.api.Group;
import pl.edu.icm.unicore.uvos.api.exceptions.GroupNotKnownException;
import pl.edu.icm.unicore.uvos.api.exceptions.InternalException;
import pl.edu.icm.unicore.uvos.db.DBLock;
import pl.edu.icm.unicore.uvos.model.GenericBean;
import pl.edu.icm.unicore.uvos.model.GroupBean;

public class DBGroupResolver {
    private DBLock lock;
    private static final Logger log = Log.getLogger((String)"unicore.uvos.server", DBGroupResolver.class);

    public DBGroupResolver(DBLock lock) {
        this.lock = lock;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    GroupBean resolveGroup4Id(int id, SqlSession sqlMap) throws InternalException, GroupNotKnownException {
        this.lock.writeLock();
        try {
            GroupBean res = null;
            try {
                res = (GroupBean)sqlMap.selectOne("resolveGroup4Id", (Object)id);
            }
            catch (PersistenceException e) {
                String msg = "DB error: Can't resolve group name for id " + id;
                log.error((Object)(msg + ". SQL exception is: " + (Object)((Object)e)));
                throw new InternalException(msg);
            }
            if (res == null) {
                log.info((Object)("Can't find group with id " + id));
                throw new GroupNotKnownException(null);
            }
            GroupBean groupBean = res;
            return groupBean;
        }
        finally {
            this.lock.writeUnlock();
        }
    }

    public GroupBean resolveGroup(String name, int parentId, Date when, SqlSession sqlMap) throws InternalException, GroupNotKnownException {
        GroupBean res = null;
        GroupBean param = new GroupBean();
        param.setName(name);
        param.setParent(parentId);
        if (when != null) {
            param.setRemovalTS(new Timestamp(when.getTime()));
        }
        try {
            res = when == null ? (parentId == -1 ? (GroupBean)sqlMap.selectOne("resolveTopGroup", (Object)name) : (GroupBean)sqlMap.selectOne("resolveGroup", (Object)param)) : (parentId == -1 ? (GroupBean)sqlMap.selectOne("resolveTopGroupH", (Object)new GenericBean(name, when)) : (GroupBean)sqlMap.selectOne("resolveGroupH", (Object)param));
        }
        catch (PersistenceException e) {
            String msg = "DB error: Can't resolve group " + name + " parent " + parentId;
            log.error((Object)(msg + ". SQL exception is: " + (Object)((Object)e)));
            throw new InternalException(msg);
        }
        if (res == null) {
            throw new GroupNotKnownException(null);
        }
        return res;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public GroupBean resolveGroup(Group g, Date when, SqlSession sqlMap) throws InternalException, GroupNotKnownException {
        this.lock.writeLock();
        try {
            String[] path = g != null ? g.getPath() : new String[]{};
            int p = -1;
            GroupBean b = new GroupBean();
            b.setId(-1);
            b.setParent(-1);
            for (int i = 0; i < path.length; ++i) {
                b = this.resolveGroup(path[i], p, when, sqlMap);
                p = b.getId();
            }
            GroupBean groupBean = b;
            return groupBean;
        }
        finally {
            this.lock.writeUnlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Group resolveGroupBean(GroupBean g, SqlSession sqlMap) throws InternalException, GroupNotKnownException {
        this.lock.writeLock();
        try {
            String path = g.getName();
            while (g.getParent() != -1) {
                g = this.resolveGroup4Id(g.getParent(), sqlMap);
                path = g.getName() + "/" + path;
            }
            path = "/" + path;
            Group group = new Group(path);
            return group;
        }
        finally {
            this.lock.writeUnlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<GroupBean> getParentGroupBeans(GroupBean g, SqlSession sqlMap) throws InternalException, GroupNotKnownException {
        ArrayList<GroupBean> ret = new ArrayList<GroupBean>();
        this.lock.writeLock();
        try {
            while (g.getParent() != -1) {
                g = this.resolveGroup4Id(g.getParent(), sqlMap);
                ret.add(g);
            }
            ArrayList<GroupBean> arrayList = ret;
            return arrayList;
        }
        finally {
            this.lock.writeUnlock();
        }
    }
}

