/*
 * Decompiled with CFR 0.152.
 */
package pl.edu.icm.unicore.uvos.db;

import eu.unicore.util.Log;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.util.Date;
import java.util.List;
import net.sf.ehcache.Cache;
import net.sf.ehcache.CacheException;
import net.sf.ehcache.CacheManager;
import net.sf.ehcache.Element;
import net.sf.ehcache.store.MemoryStoreEvictionPolicy;
import org.apache.ibatis.exceptions.PersistenceException;
import org.apache.ibatis.session.SqlSession;
import org.apache.log4j.Logger;
import pl.edu.icm.unicore.uvos.api.Identity;
import pl.edu.icm.unicore.uvos.api.exceptions.IdentityNotKnownException;
import pl.edu.icm.unicore.uvos.api.exceptions.InternalException;
import pl.edu.icm.unicore.uvos.api.exceptions.InvalidValueException;
import pl.edu.icm.unicore.uvos.db.DBLock;
import pl.edu.icm.unicore.uvos.idhelpers.IdentityHelperFactory;
import pl.edu.icm.unicore.uvos.idhelpers.IdentityTypeHelper;
import pl.edu.icm.unicore.uvos.model.EntityBean;
import pl.edu.icm.unicore.uvos.model.GenericBean;
import pl.edu.icm.unicore.uvos.model.IdentityBean;

public class DBEntitiesCache {
    private static final String cacheName = "EntitiesCache";
    private static final int CACHE_MAX_ENTITIES = 1000;
    private static final String cacheConfig = "<ehcache updateCheck=\"false\"><defaultCache maxElementsInMemory=\"1000\" eternal=\"true\" timeToIdleSeconds=\"10\" timeToLiveSeconds=\"10\" overflowToDisk=\"false\" diskPersistent=\"false\" diskExpiryThreadIntervalSeconds=\"1200\"/></ehcache>";
    private DBLock lock;
    private static final Logger log = Log.getLogger((String)"unicore.uvos.server", DBEntitiesCache.class);
    private Cache entitiesCache;

    public DBEntitiesCache(DBLock lock) {
        this.lock = lock;
        this.prepareCache();
    }

    private void prepareCache() {
        ByteArrayInputStream bis = new ByteArrayInputStream(cacheConfig.getBytes());
        CacheManager man = CacheManager.create((InputStream)bis);
        if (man.cacheExists(cacheName)) {
            this.entitiesCache = man.getCache(cacheName);
        } else {
            this.entitiesCache = new Cache(cacheName, 1000, MemoryStoreEvictionPolicy.LFU, false, null, true, 3600L, 3600L, false, 240L, null);
            man.addCache(this.entitiesCache);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public EntityBean getEntity4Identity(int id, SqlSession sqlMap) throws InternalException, IdentityNotKnownException {
        this.lock.writeLock();
        try {
            EntityBean res;
            Element cached = this.entitiesCache.get((Serializable)Integer.valueOf(id));
            if (cached != null) {
                EntityBean entityBean = (EntityBean)cached.getObjectValue();
                return entityBean;
            }
            try {
                res = (EntityBean)sqlMap.selectOne("getEntity4Identity", (Object)id);
                if (res != null) {
                    this.entitiesCache.put(new Element((Serializable)Integer.valueOf(id), (Serializable)res));
                }
            }
            catch (PersistenceException e) {
                log.error((Object)("DB error: Can't get entity for identity id " + id + ". SQL exception is: " + (Object)((Object)e)));
                throw new InternalException("DB error: No entity for identity: " + id);
            }
            if (res == null) {
                throw new IdentityNotKnownException(null);
            }
            EntityBean entityBean = res;
            return entityBean;
        }
        finally {
            this.lock.writeUnlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public EntityBean getEntity4Identity(Identity identity, Date when, SqlSession sqlMap) throws IdentityNotKnownException, InternalException, InvalidValueException {
        this.lock.writeLock();
        try {
            IdentityBean ib = this.resolveIdentity(identity, when, sqlMap);
            EntityBean entityBean = this.getEntity4Identity(ib.getId(), sqlMap);
            return entityBean;
        }
        finally {
            this.lock.writeUnlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IdentityBean resolveIdentity(Identity identity, Date when, SqlSession sqlMap) throws IdentityNotKnownException, InternalException, InvalidValueException {
        this.lock.writeLock();
        try {
            IdentityBean res;
            try {
                IdentityTypeHelper helper = IdentityHelperFactory.getHelper((Identity)identity);
                GenericBean param = new GenericBean(helper.getComparableValue(), identity.getType().toString());
                if (when == null) {
                    res = (IdentityBean)sqlMap.selectOne("resolveIdentity", (Object)param);
                } else {
                    param.setP3(when);
                    res = (IdentityBean)sqlMap.selectOne("resolveIdentityH", (Object)param);
                }
            }
            catch (PersistenceException e) {
                String msg = "DB error: Can't resolve identity " + identity;
                log.warn((Object)(msg + ". SQL exception is: " + (Object)((Object)e)));
                throw new InternalException(msg);
            }
            if (res == null) {
                throw new IdentityNotKnownException(identity);
            }
            IdentityBean identityBean = res;
            return identityBean;
        }
        finally {
            this.lock.writeUnlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateEntityPersistentId(int toChange, String newId, SqlSession sqlMap) throws InternalException {
        this.lock.writeLock();
        try {
            EntityBean eb = new EntityBean();
            eb.setName(newId);
            eb.setId(toChange);
            try {
                sqlMap.update("changeEntityPersistentId", (Object)eb);
            }
            catch (PersistenceException e) {
                String msg = "DB error: Can't change entity's " + toChange + " persistentId to " + newId;
                log.warn((Object)(msg + ". SQL exception is: " + (Object)((Object)e)));
                throw new InternalException(msg);
            }
            this.entitiesCache.removeAll();
        }
        finally {
            this.lock.writeUnlock();
        }
    }

    public void purgeCache() throws IllegalStateException, CacheException, IOException {
        this.entitiesCache.removeAll();
    }

    public void remove(Integer id) {
        this.entitiesCache.remove((Serializable)id);
    }

    public int getCacheMaxEntities() {
        return 1000;
    }

    public String getCacheConfig() {
        return cacheConfig;
    }

    public List<EntityBean> getAllEntities(SqlSession sqlMap) throws InternalException {
        this.lock.writeLock();
        try {
            List list = sqlMap.selectList("getAllEntities");
            return list;
        }
        catch (PersistenceException e1) {
            String msg = "DB error: Can't retrieve entities";
            log.warn((Object)(msg + ". SQL exception is: " + (Object)((Object)e1)));
            throw new InternalException(msg);
        }
        finally {
            this.lock.writeUnlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    IdentityBean getIdentity4Id(int id, SqlSession sqlMap) throws InternalException, InvalidValueException {
        this.lock.writeLock();
        try {
            IdentityBean res;
            try {
                res = (IdentityBean)sqlMap.selectOne("getIdentity4Id", (Object)id);
            }
            catch (PersistenceException e) {
                String msg = "DB error: Can't get identity for id" + id;
                log.warn((Object)(msg + ". SQL exception is: " + (Object)((Object)e)));
                throw new InternalException(msg);
            }
            if (res == null) {
                throw new InvalidValueException("No such identity.");
            }
            IdentityBean identityBean = res;
            return identityBean;
        }
        finally {
            this.lock.writeUnlock();
        }
    }
}

