/*
 * Decompiled with CFR 0.152.
 */
package pl.edu.icm.unicore.uvos.db;

import eu.unicore.util.Log;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.Vector;
import net.sf.ehcache.Cache;
import net.sf.ehcache.CacheManager;
import net.sf.ehcache.store.MemoryStoreEvictionPolicy;
import org.apache.ibatis.exceptions.PersistenceException;
import org.apache.ibatis.session.SqlSession;
import org.apache.log4j.Logger;
import pl.edu.icm.unicore.uvos.api.Attribute;
import pl.edu.icm.unicore.uvos.api.AttributeType;
import pl.edu.icm.unicore.uvos.api.Element;
import pl.edu.icm.unicore.uvos.api.Group;
import pl.edu.icm.unicore.uvos.api.Identity;
import pl.edu.icm.unicore.uvos.api.IdentityType;
import pl.edu.icm.unicore.uvos.api.ModificationEvent;
import pl.edu.icm.unicore.uvos.api.exceptions.AttributeNotFoundException;
import pl.edu.icm.unicore.uvos.api.exceptions.AuthenticationException;
import pl.edu.icm.unicore.uvos.api.exceptions.ElementAlreadyExistsException;
import pl.edu.icm.unicore.uvos.api.exceptions.ElementNotKnownException;
import pl.edu.icm.unicore.uvos.api.exceptions.GroupNotKnownException;
import pl.edu.icm.unicore.uvos.api.exceptions.IdentityNotKnownException;
import pl.edu.icm.unicore.uvos.api.exceptions.InternalException;
import pl.edu.icm.unicore.uvos.api.exceptions.InvalidValueException;
import pl.edu.icm.unicore.uvos.api.exceptions.LabelAlreadyUsedException;
import pl.edu.icm.unicore.uvos.api.exceptions.SecurityException;
import pl.edu.icm.unicore.uvos.api.exceptions.UnsupportedTypeException;
import pl.edu.icm.unicore.uvos.db.DBAttributeTypes;
import pl.edu.icm.unicore.uvos.db.DBEntitiesCache;
import pl.edu.icm.unicore.uvos.db.DBGroupResolver;
import pl.edu.icm.unicore.uvos.db.DBGroups;
import pl.edu.icm.unicore.uvos.db.DBIdentityTypes;
import pl.edu.icm.unicore.uvos.db.DBLock;
import pl.edu.icm.unicore.uvos.engine.InternalAuthorization;
import pl.edu.icm.unicore.uvos.engine.PersistentIdManager;
import pl.edu.icm.unicore.uvos.idhelpers.IdentityHelperFactory;
import pl.edu.icm.unicore.uvos.idhelpers.IdentityTypeHelper;
import pl.edu.icm.unicore.uvos.model.AttributeBean;
import pl.edu.icm.unicore.uvos.model.AuthnBean;
import pl.edu.icm.unicore.uvos.model.EntityBean;
import pl.edu.icm.unicore.uvos.model.GenericBean;
import pl.edu.icm.unicore.uvos.model.GroupBean;
import pl.edu.icm.unicore.uvos.model.IdentityBean;

public class DBEntities {
    private static final Logger log = Log.getLogger((String)"unicore.uvos.server", DBEntities.class);
    private Cache certSubjectsCache;
    private static final String cacheName = "CertSubjectsCache";
    private DBAttributeTypes attributeTypes;
    private DBIdentityTypes identityTypes;
    private DBGroupResolver groupResolver;
    private DBGroups groups;
    private DBEntitiesCache entitiesCache;
    private PersistentIdManager idManager;
    private DBLock lock;

    public DBEntities(DBAttributeTypes attributeTypes, DBIdentityTypes identityTypes, DBGroupResolver groupResolver, PersistentIdManager idManager, DBGroups groups, DBEntitiesCache entitiesCache, DBLock lock) {
        this.attributeTypes = attributeTypes;
        this.identityTypes = identityTypes;
        this.groupResolver = groupResolver;
        this.idManager = idManager;
        this.groups = groups;
        this.entitiesCache = entitiesCache;
        this.lock = lock;
        this.prepareCache();
    }

    private void prepareCache() {
        ByteArrayInputStream bis = new ByteArrayInputStream(this.entitiesCache.getCacheConfig().getBytes());
        CacheManager man = CacheManager.create((InputStream)bis);
        if (man.cacheExists(cacheName)) {
            this.certSubjectsCache = man.getCache(cacheName);
        } else {
            this.certSubjectsCache = new Cache(cacheName, this.entitiesCache.getCacheMaxEntities(), MemoryStoreEvictionPolicy.LFU, false, null, true, 3600L, 3600L, false, 240L, null);
            man.addCache(this.certSubjectsCache);
        }
    }

    /*
     * Exception decompiling
     */
    public Identity getX509BySubject(String canonSubject, SqlSession sqlMap) throws InternalException, InvalidValueException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [0[TRYBLOCK], 5[CATCHBLOCK]], but top level block is 8[WHILELOOP]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addIdentity(Identity toAdd, boolean authTokenEncoded, SqlSession sqlMap) throws InternalException, ElementAlreadyExistsException, UnsupportedTypeException, LabelAlreadyUsedException, InvalidValueException, AuthenticationException {
        this.lock.writeLock();
        try {
            if (toAdd.getValue() == null || toAdd.getType() == null) {
                throw new InternalException("Wrong (null) attributes of identity to create");
            }
            IdentityTypeHelper helper = IdentityHelperFactory.getHelper((Identity)toAdd);
            helper.setAuthNTokenEncode(!authTokenEncoded);
            if (toAdd.getLabel() == null) {
                toAdd.setLabel(helper.generateUniqueLabel());
            }
            try {
                this.resolveEntity(toAdd.getLabel(), sqlMap);
                throw new LabelAlreadyUsedException();
            }
            catch (IdentityNotKnownException e) {
                try {
                    this.entitiesCache.resolveIdentity(toAdd, null, sqlMap);
                    throw new ElementAlreadyExistsException(new Element(null, toAdd));
                }
                catch (IdentityNotKnownException e2) {
                    EntityBean eb = this.createEntity(toAdd.getLabel(), sqlMap);
                    this.createIdentity(toAdd, eb, helper, sqlMap);
                    this.lock.writeUnlock();
                }
            }
        }
        catch (Throwable throwable) {
            this.lock.writeUnlock();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addIdentity(Identity toAdd, Identity equivalentIdentity, boolean authTokenEncoded, SqlSession sqlMap) throws InternalException, ElementAlreadyExistsException, IdentityNotKnownException, UnsupportedTypeException, InvalidValueException, AuthenticationException {
        this.lock.writeLock();
        try {
            if (toAdd.getValue() == null || toAdd.getType() == null) {
                throw new InternalException("Wrong (null) attributes of identity to create");
            }
            if (equivalentIdentity.getValue() == null || equivalentIdentity.getType() == null) {
                throw new InternalException("Wrong (null) attributes of eqivalent identity");
            }
            IdentityTypeHelper helper = IdentityHelperFactory.getHelper((Identity)toAdd);
            helper.setAuthNTokenEncode(!authTokenEncoded);
            EntityBean eb = this.entitiesCache.getEntity4Identity(equivalentIdentity, null, sqlMap);
            toAdd.setLabel(eb.getName());
            equivalentIdentity.setLabel(eb.getName());
            try {
                this.entitiesCache.resolveIdentity(toAdd, null, sqlMap);
                throw new ElementAlreadyExistsException(new Element(null, toAdd));
            }
            catch (IdentityNotKnownException e) {
                this.createIdentity(toAdd, eb, helper, sqlMap);
                this.lock.writeUnlock();
            }
        }
        catch (Throwable throwable) {
            this.lock.writeUnlock();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeIdentity(Identity toRemove, SqlSession sqlMap) throws InternalException, IdentityNotKnownException, InvalidValueException {
        this.lock.writeLock();
        try {
            IdentityBean ib = this.entitiesCache.resolveIdentity(toRemove, null, sqlMap);
            List<IdentityBean> eqiv = this.getEqivalents(ib.getEntityId(), sqlMap);
            GenericBean param = new GenericBean();
            param.setP1(new Date());
            if (eqiv.size() == 1) {
                param.setP2(ib.getEntityId());
                try {
                    sqlMap.update("removeAllEntityAttributes", (Object)param);
                }
                catch (PersistenceException e) {
                    String msg = "DB error: Can't remove entity attributes of entity with id " + ib.getEntityId();
                    log.warn((Object)(msg + ". SQL exception is: " + (Object)((Object)e)));
                    throw new InternalException(msg);
                }
                this.groups.removeFromAllGroups(ib.getEntityId(), sqlMap);
                try {
                    sqlMap.update("removeEntity", (Object)param);
                }
                catch (PersistenceException e) {
                    String msg = "DB error: Can't remove entity with id " + ib.getEntityId();
                    log.warn((Object)(msg + ". SQL exception is: " + (Object)((Object)e)));
                    throw new InternalException(msg);
                }
            }
            this.entitiesCache.remove(ib.getId());
            param.setP2(ib.getId());
            try {
                sqlMap.update("removeIdentity", (Object)param);
            }
            catch (PersistenceException e) {
                String msg = "DB error: Can't remove identity " + toRemove;
                log.warn((Object)(msg + ". SQL exception is: " + (Object)((Object)e)));
                throw new InternalException(msg);
            }
            this.entitiesCache.remove(ib.getId());
        }
        finally {
            this.lock.writeUnlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setIdentityLabel(Identity toChange, String label, SqlSession sqlMap) throws InternalException, IdentityNotKnownException, LabelAlreadyUsedException, InvalidValueException {
        this.lock.writeLock();
        try {
            IdentityBean ib = this.entitiesCache.resolveIdentity(toChange, null, sqlMap);
            EntityBean eb = this.entitiesCache.getEntity4Identity(ib.getId(), sqlMap);
            try {
                this.resolveEntity(label, sqlMap);
                throw new LabelAlreadyUsedException();
            }
            catch (IdentityNotKnownException e) {
                eb.setName(label);
                try {
                    sqlMap.update("changeEntityName", (Object)eb);
                }
                catch (PersistenceException e2) {
                    String msg = "DB error: Can't change identity " + toChange + " name to " + label;
                    log.warn((Object)(msg + ". SQL exception is: " + (Object)((Object)e2)));
                    throw new InternalException(msg);
                }
                try {
                    this.entitiesCache.purgeCache();
                }
                catch (IOException e3) {
                    // empty catch block
                }
                this.lock.writeUnlock();
            }
        }
        catch (Throwable throwable) {
            this.lock.writeUnlock();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setIdentityStatus(Identity toChange, boolean how, SqlSession sqlMap) throws InternalException, IdentityNotKnownException, InvalidValueException {
        this.lock.writeLock();
        try {
            IdentityBean ib = this.entitiesCache.resolveIdentity(toChange, null, sqlMap);
            ib.setInactive(how ? 0 : 1);
            try {
                sqlMap.update("setIdentityStatus", (Object)ib);
            }
            catch (PersistenceException e) {
                String msg = "DB error: Can't set identity " + toChange + " active status to " + how;
                log.warn((Object)(msg + ". SQL exception is: " + (Object)((Object)e)));
                throw new InternalException(msg);
            }
        }
        finally {
            this.lock.writeUnlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateEntityPersistentId(int toChange, String newId, SqlSession sqlMap) throws InternalException {
        this.lock.writeLock();
        try {
            EntityBean eb = new EntityBean();
            eb.setName(newId);
            eb.setId(toChange);
            try {
                sqlMap.update("changeEntityPersistentId", (Object)eb);
            }
            catch (PersistenceException e) {
                String msg = "DB error: Can't change entity's " + toChange + " persistentId to " + newId;
                log.warn((Object)(msg + ". SQL exception is: " + (Object)((Object)e)));
                throw new InternalException(msg);
            }
            try {
                this.entitiesCache.purgeCache();
            }
            catch (IOException e) {
                // empty catch block
            }
        }
        finally {
            this.lock.writeUnlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void changeAuthnToken(Identity toChange, String newToken, SqlSession sqlMap) throws IdentityNotKnownException, InternalException, InvalidValueException {
        block8: {
            this.lock.writeLock();
            try {
                IdentityBean ib = this.entitiesCache.resolveIdentity(toChange, null, sqlMap);
                if (newToken == null) {
                    try {
                        sqlMap.delete("removeIdentityAuthn", (Object)ib.getId());
                        break block8;
                    }
                    catch (PersistenceException e) {
                        String msg = "DB error: Can't change identity's " + toChange + " password.";
                        log.warn((Object)(msg + ". SQL exception is: " + (Object)((Object)e)));
                        throw new InternalException(msg);
                    }
                }
                AuthnBean param = new AuthnBean();
                param.setIdentityId(ib.getId());
                param.setVal(newToken);
                try {
                    sqlMap.update("changeIdentityAuthn", (Object)param);
                }
                catch (PersistenceException e) {
                    String msg = "DB error: Can't clear identity's " + toChange + " password.";
                    log.warn((Object)(msg + ". SQL exception is: " + (Object)((Object)e)));
                    throw new InternalException(msg);
                }
            }
            finally {
                this.lock.writeUnlock();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void setAttribute(Element whom, Attribute toAdd, boolean update, SqlSession sqlMap) throws InternalException, ElementNotKnownException, ElementAlreadyExistsException, GroupNotKnownException, IdentityNotKnownException, InvalidValueException {
        this.lock.writeLock();
        try {
            int typeId;
            AttributeBean ab = new AttributeBean();
            AttributeType type = toAdd.getType();
            try {
                typeId = this.attributeTypes.getAttrTypeId(type, true, sqlMap);
            }
            catch (UnsupportedTypeException e1) {
                log.fatal((Object)"BUG: Unsupported type thrown when type should be created.");
                throw new InternalException("BUG in set attribute");
            }
            EntityBean eb = this.entitiesCache.getEntity4Identity(whom.getIdentity(), null, sqlMap);
            if (whom.getGroup() != null) {
                Group g = whom.getGroup();
                GroupBean gb = this.groupResolver.resolveGroup(g, null, sqlMap);
                ab.setGroupId(gb.getId());
            } else {
                ab.setGroupId(-1);
            }
            ab.setCreationTS(new Timestamp(new Date().getTime()));
            ab.setTypeId(typeId);
            ab.setEntityId(eb.getId());
            List<AttributeBean> rawAttrs = this.getAttributes(eb.getId(), sqlMap);
            for (AttributeBean ab2 : rawAttrs) {
                if (ab2.getTypeId() != typeId || ab2.getGroupId() != ab.getGroupId()) continue;
                if (!update) {
                    throw new ElementAlreadyExistsException(new Element(null, null));
                }
                ab2.setRemovalTS(new Timestamp(new Date().getTime()));
                try {
                    sqlMap.update("removeEntityAttribute", (Object)ab2);
                }
                catch (PersistenceException e) {
                    String msg = "DB error: Can't remove (to update) entity attributes of entity" + eb.getName();
                    log.warn((Object)(msg + ". SQL exception is: " + (Object)((Object)e)));
                    throw new InternalException(msg);
                }
            }
            List vals = toAdd.getValues();
            ab.setVal(null);
            if (vals == null || vals.size() == 0) {
                try {
                    sqlMap.insert("addEntityAttribute", (Object)ab);
                    return;
                }
                catch (PersistenceException e) {
                    String msg = "DB error: Can't insert entity attributes for entity " + eb.getName();
                    log.warn((Object)(msg + ". SQL exception is: " + (Object)((Object)e)));
                    throw new InternalException(msg);
                }
            }
            for (String val : vals) {
                ab.setVal(val);
                try {
                    sqlMap.insert("addEntityAttribute", (Object)ab);
                }
                catch (PersistenceException e) {
                    String msg = "DB error: Can't insert entity attributes for entity " + eb.getName();
                    log.warn((Object)(msg + ". SQL exception is: " + (Object)((Object)e)));
                    throw new InternalException(msg);
                    return;
                }
            }
        }
        finally {
            this.lock.writeUnlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void removeAttribute(Element whom, String toRemove, SqlSession sqlMap) throws InternalException, ElementNotKnownException, UnsupportedTypeException, InvalidValueException {
        this.lock.writeLock();
        try {
            AttributeType aType = new AttributeType(toRemove);
            int typeId = this.attributeTypes.getAttrTypeId(aType.getName());
            EntityBean eb = this.entitiesCache.getEntity4Identity(whom.getIdentity(), null, sqlMap);
            int gid = -1;
            if (whom.getGroup() != null) {
                Group g = whom.getGroup();
                GroupBean gb = this.groupResolver.resolveGroup(g, null, sqlMap);
                gid = gb.getId();
            }
            List<AttributeBean> rawAttrs = this.getAttributes(eb.getId(), sqlMap);
            for (AttributeBean ab2 : rawAttrs) {
                if (ab2.getTypeId() != typeId || ab2.getGroupId() != gid) continue;
                ab2.setRemovalTS(new Timestamp(new Date().getTime()));
                try {
                    sqlMap.update("removeEntityAttribute", (Object)ab2);
                }
                catch (PersistenceException e) {
                    String msg = "DB error: Can't remove entity attributes of entity " + eb.getName();
                    log.warn((Object)(msg + ". SQL exception is: " + (Object)((Object)e)));
                    throw new InternalException(msg);
                    return;
                }
            }
        }
        finally {
            this.lock.writeUnlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void disableEnableAttribute(Element whom, String toDisable, String value, int how, SqlSession sqlMap) throws InternalException, ElementNotKnownException, AttributeNotFoundException, InvalidValueException {
        this.lock.writeLock();
        try {
            int typeId;
            AttributeType aType = new AttributeType(toDisable);
            try {
                typeId = this.attributeTypes.getAttrTypeId(aType.getName());
            }
            catch (UnsupportedTypeException e1) {
                throw new AttributeNotFoundException(null);
            }
            EntityBean eb = this.entitiesCache.getEntity4Identity(whom.getIdentity(), null, sqlMap);
            int gid = -1;
            if (whom.getGroup() != null) {
                Group g = whom.getGroup();
                GroupBean gb = this.groupResolver.resolveGroup(g, null, sqlMap);
                gid = gb.getId();
            }
            AttributeBean ab = new AttributeBean();
            ab.setEntityId(eb.getId());
            ab.setGroupId(gid);
            ab.setTypeId(typeId);
            ab.setVal(value);
            ab.setInactive(how);
            String sql = value == null && gid == -1 ? "disableEnableEntityAttributes1" : (value == null && gid != -1 ? "disableEnableGEntityAttributes1" : (value != null && gid == -1 ? "disableEnableEntityAttributes2" : "disableEnableGEntityAttributes2"));
            try {
                if (sqlMap.update(sql, (Object)ab) == 0) {
                    throw new AttributeNotFoundException(toDisable);
                }
            }
            catch (PersistenceException e) {
                String msg = "DB error: Can't (en|dis)able entity attributes of entity " + eb.getName();
                log.warn((Object)(msg + ". SQL exception is: " + (Object)((Object)e)));
                throw new InternalException(msg);
            }
        }
        finally {
            this.lock.writeUnlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Attribute> getDisabledAttributes(Element whose, SqlSession sqlMap) throws InternalException, ElementNotKnownException, InvalidValueException {
        this.lock.writeLock();
        try {
            int gid = -1;
            String scope = null;
            if (whose.getGroup() != null) {
                gid = this.groupResolver.resolveGroup(whose.getGroup(), null, sqlMap).getId();
                scope = whose.getGroup().toString();
            }
            EntityBean eb = this.entitiesCache.getEntity4Identity(whose.getIdentity(), null, sqlMap);
            GenericBean param = new GenericBean();
            param.setP1(eb.getId());
            param.setP2(gid);
            List rawL = null;
            try {
                rawL = gid == -1 ? sqlMap.selectList("listDisabledEntityAttributes", (Object)eb.getId()) : sqlMap.selectList("listDisabledGEntityAttributes", (Object)param);
            }
            catch (PersistenceException e) {
                String msg = "DB error: Can't list disabled entity attributes of the entity " + eb.getId();
                log.warn((Object)(msg + ". SQL exception is: " + (Object)((Object)e)));
                throw new InternalException(msg);
            }
            List<Attribute> list = this.attributeTypes.prepareAttributeList(rawL, scope);
            return list;
        }
        finally {
            this.lock.writeUnlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Attribute> getAllAttributes(Element owner, boolean effective, Date when, SqlSession sqlMap) throws InternalException, ElementNotKnownException, InvalidValueException {
        this.lock.writeLock();
        try {
            GroupBean groupBean = null;
            String scope = null;
            if (owner.getGroup() != null) {
                groupBean = this.groupResolver.resolveGroup(owner.getGroup(), when, sqlMap);
                scope = owner.getGroup().toString();
            }
            EntityBean eb = this.entitiesCache.getEntity4Identity(owner.getIdentity(), when, sqlMap);
            List<AttributeBean> attrBs = !effective || groupBean == null ? this.getAttributes(eb.getId(), groupBean == null ? -1 : groupBean.getId(), when, sqlMap) : this.getEffectiveAttributes(eb.getId(), groupBean, when, sqlMap);
            List<Attribute> list = this.attributeTypes.prepareAttributeList(attrBs, scope);
            return list;
        }
        finally {
            this.lock.writeUnlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean areEquivalent(Identity i1, Identity i2, Date when, SqlSession sqlMap) throws InternalException, IdentityNotKnownException, InvalidValueException {
        this.lock.writeLock();
        try {
            EntityBean eb1 = this.entitiesCache.getEntity4Identity(i1, when, sqlMap);
            EntityBean eb2 = this.entitiesCache.getEntity4Identity(i2, when, sqlMap);
            boolean bl = eb1.getId() == eb2.getId();
            return bl;
        }
        finally {
            this.lock.writeUnlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Identity> getAllEquivalents(Identity who, Date when, SqlSession sqlMap) throws InternalException, IdentityNotKnownException, InvalidValueException {
        this.lock.writeLock();
        try {
            IdentityBean ibBase = this.entitiesCache.resolveIdentity(who, when, sqlMap);
            List<Identity> list = this.getAllEquivalents(ibBase.getEntityId(), when, sqlMap);
            return list;
        }
        finally {
            this.lock.writeUnlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Identity> getAllEquivalents(int entityId, Date when, SqlSession sqlMap) throws InternalException, IdentityNotKnownException {
        this.lock.writeLock();
        try {
            List raw;
            try {
                raw = when == null ? sqlMap.selectList("getEquivalentIdentities", (Object)entityId) : sqlMap.selectList("getEquivalentIdentitiesH", (Object)new GenericBean(entityId, when));
            }
            catch (PersistenceException e1) {
                String msg = "DB error: Can't retrieve equivalent identities of " + entityId;
                log.warn((Object)(msg + ". SQL exception is: " + (Object)((Object)e1)));
                throw new InternalException(msg);
            }
            List<Identity> list = this.convertIdentitiesList(raw, sqlMap);
            return list;
        }
        finally {
            this.lock.writeUnlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Attribute getAttribute(Element owner, String attribute, boolean effective, Date when, SqlSession sqlMap) throws InternalException, ElementNotKnownException, AttributeNotFoundException, InvalidValueException {
        this.lock.writeLock();
        try {
            List<AttributeBean> attrB;
            int typeId;
            GroupBean groupB = null;
            String scope = null;
            if (owner.getGroup() != null) {
                groupB = this.groupResolver.resolveGroup(owner.getGroup(), when, sqlMap);
                scope = owner.getGroup().toString();
            }
            EntityBean eb = this.entitiesCache.getEntity4Identity(owner.getIdentity(), when, sqlMap);
            try {
                typeId = this.attributeTypes.getAttrTypeId(attribute);
            }
            catch (UnsupportedTypeException e) {
                throw new AttributeNotFoundException(null);
            }
            if (effective && groupB != null) {
                List<AttributeBean> allAttrs = this.getEffectiveAttributes(eb.getId(), groupB, when, sqlMap);
                attrB = new Vector<AttributeBean>();
                for (AttributeBean tmp : allAttrs) {
                    if (tmp.getTypeId() != typeId) continue;
                    attrB.add(tmp);
                }
            } else {
                attrB = this.getAttribute(eb.getId(), groupB == null ? -1 : groupB.getId(), typeId, when, sqlMap);
            }
            if (attrB.size() == 0) {
                throw new AttributeNotFoundException(null);
            }
            Attribute attribute2 = this.attributeTypes.prepareAttributeList(attrB, scope).get(0);
            return attribute2;
        }
        finally {
            this.lock.writeUnlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Identity> getAllIdentities(Date when, SqlSession sqlMap) throws InternalException {
        this.lock.writeLock();
        try {
            List raw;
            try {
                raw = when == null ? sqlMap.selectList("getAllIdentities") : sqlMap.selectList("getAllIdentitiesH", (Object)new GenericBean(when));
            }
            catch (PersistenceException e1) {
                String msg = "DB error: Can't retrieve identities";
                log.warn((Object)(msg + ". SQL exception is: " + (Object)((Object)e1)));
                throw new InternalException(msg);
            }
            List<Identity> list = this.convertIdentitiesList(raw, sqlMap);
            return list;
        }
        finally {
            this.lock.writeUnlock();
        }
    }

    public String getAuthnData(int id, SqlSession sqlMap) throws InternalException {
        this.lock.writeLock();
        try {
            AuthnBean res = (AuthnBean)sqlMap.selectOne("getIdentityAuth", (Object)id);
            if (res != null) {
                String string = res.getVal();
                return string;
            }
        }
        catch (PersistenceException e) {
            String msg = "DB error: Can't check identity authn data for: " + id;
            log.warn((Object)(msg + ". SQL exception is: " + (Object)((Object)e)));
            throw new InternalException(msg);
        }
        finally {
            this.lock.writeUnlock();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void getIdentityEvents(List<ModificationEvent> list, Date from, Date to, int typeFilter, boolean fillDetails, SqlSession sqlMap) throws InternalException {
        this.lock.writeLock();
        try {
            ArrayList<Object> res1 = new ArrayList<Object>();
            ArrayList<Object> res2 = new ArrayList<Object>();
            this.groups.getEventsGeneric(res1, res2, from, to, typeFilter, "getEventsId", sqlMap);
            this.convertEventsId(list, res1, fillDetails, ModificationEvent.TYPE.ADD, sqlMap);
            this.convertEventsId(list, res2, fillDetails, ModificationEvent.TYPE.REMOVE, sqlMap);
        }
        finally {
            this.lock.writeUnlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void getEntityEvents(List<ModificationEvent> list, Date from, Date to, int typeFilter, boolean fillDetails, SqlSession sqlMap) throws InternalException {
        this.lock.writeLock();
        try {
            ArrayList<Object> res1 = new ArrayList<Object>();
            ArrayList<Object> res2 = new ArrayList<Object>();
            this.groups.getEventsGeneric(res1, res2, from, to, typeFilter, "getEventsEnt", sqlMap);
            this.convertEventsEnt(list, res1, fillDetails, ModificationEvent.TYPE.ADD);
            this.convertEventsEnt(list, res2, fillDetails, ModificationEvent.TYPE.REMOVE);
        }
        finally {
            this.lock.writeUnlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void getAttributeEvents(List<ModificationEvent> list, Date from, Date to, int typeFilter, boolean fillDetails, SqlSession sqlMap) throws InternalException {
        this.lock.writeLock();
        try {
            ArrayList<Object> res1 = new ArrayList<Object>();
            ArrayList<Object> res2 = new ArrayList<Object>();
            this.groups.getEventsGeneric(res1, res2, from, to, typeFilter, "getEventsAttrGlobal", sqlMap);
            this.groups.convertEventsAttr(list, res1, fillDetails, ModificationEvent.TYPE.ADD, sqlMap);
            this.groups.convertEventsAttr(list, res2, fillDetails, ModificationEvent.TYPE.REMOVE, sqlMap);
            res1 = new ArrayList();
            res2 = new ArrayList();
            this.groups.getEventsGeneric(res1, res2, from, to, typeFilter, "getEventsAttrScoped", sqlMap);
            this.groups.convertEventsAttr(list, res1, fillDetails, ModificationEvent.TYPE.ADD, sqlMap);
            this.groups.convertEventsAttr(list, res2, fillDetails, ModificationEvent.TYPE.REMOVE, sqlMap);
        }
        finally {
            this.lock.writeUnlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Attribute> getIdentityAttributes(Element owner, String attribute, boolean includeScoped, boolean globalReadPerm, boolean effective, boolean includeImplied, boolean self, Date when, InternalAuthorization authz, SqlSession sqlMap) throws InternalException, ElementNotKnownException, InvalidValueException, SecurityException {
        this.lock.writeLock();
        try {
            if (!includeScoped) {
                List<Attribute> list = this.getGlobalAttrs(owner, attribute, effective, when, sqlMap);
                return list;
            }
            List<Object> ret = !globalReadPerm ? new ArrayList() : this.getGlobalAttrs(owner, attribute, effective, when, sqlMap);
            List<Group> groupsAll = this.groups.getAllReadableGroups(globalReadPerm, owner.getIdentity(), includeImplied, authz, sqlMap);
            Element grUser = new Element(null, owner.getIdentity());
            for (Group group : groupsAll) {
                grUser.setGroup(group);
                if (attribute == null) {
                    ret.addAll(this.getAllAttributes(grUser, effective, when, sqlMap));
                    continue;
                }
                try {
                    ret.add(this.getAttribute(grUser, attribute, effective, when, sqlMap));
                }
                catch (AttributeNotFoundException e) {}
            }
            ArrayList<Attribute> arrayList = ret;
            return arrayList;
        }
        finally {
            this.lock.writeUnlock();
        }
    }

    private List<Attribute> getGlobalAttrs(Element owner, String attribute, boolean effective, Date when, SqlSession sqlMap) throws InternalException, ElementNotKnownException, InvalidValueException {
        if (attribute == null) {
            return this.getAllAttributes(owner, effective, when, sqlMap);
        }
        ArrayList<Attribute> ret = new ArrayList<Attribute>();
        try {
            ret.add(this.getAttribute(owner, attribute, effective, when, sqlMap));
        }
        catch (AttributeNotFoundException e) {
            // empty catch block
        }
        return ret;
    }

    private void convertEventsId(List<ModificationEvent> list, List<Object> res, boolean fillDetails, ModificationEvent.TYPE type, SqlSession sqlMap) throws InternalException {
        boolean add = type.equals((Object)ModificationEvent.TYPE.ADD);
        for (Object o : res) {
            IdentityBean id = (IdentityBean)o;
            ModificationEvent e = new ModificationEvent((Date)(add ? id.getCreationTS() : id.getRemovalTS()), ModificationEvent.CATEGORY.IDENTITY, type);
            if (fillDetails) {
                e.setDescription(this.resolveIdentityBean(id, sqlMap).toString());
            }
            list.add(e);
        }
    }

    private void convertEventsEnt(List<ModificationEvent> list, List<Object> res, boolean fillDetails, ModificationEvent.TYPE type) throws InternalException {
        boolean add = type.equals((Object)ModificationEvent.TYPE.ADD);
        for (Object o : res) {
            EntityBean id = (EntityBean)o;
            ModificationEvent e = new ModificationEvent((Date)(add ? id.getCreationTS() : id.getRemovalTS()), ModificationEvent.CATEGORY.ENTITY, type);
            if (fillDetails) {
                e.setDescription(id.getName() + " (persistent id: " + id.getPersistentId() + ")");
            }
            list.add(e);
        }
    }

    private Identity resolveIdentityBean(IdentityBean ib, SqlSession sqlMap) throws InternalException {
        return this.resolveIdentityBeanCore(ib, sqlMap);
    }

    private Identity resolveIdentityBeanCore(IdentityBean ib, SqlSession sqlMap) throws InternalException {
        EntityBean e;
        IdentityType it = this.identityTypes.getIdentityType4Id(ib.getTypeId());
        try {
            e = this.entitiesCache.getEntity4Identity(ib.getId(), sqlMap);
        }
        catch (IdentityNotKnownException e1) {
            throw new InternalException("Can't resolve identity bean", (Throwable)e1);
        }
        Identity ret = new Identity(it, ib.getValue(), e.getName(), e.getPersistentId(), (Date)ib.getCreationTS(), (Date)ib.getRemovalTS());
        ret.setInactive(ib.getInactive() != 0);
        return ret;
    }

    private List<Identity> convertIdentitiesList(List<?> raw, SqlSession sqlMap) throws InternalException {
        Vector<Identity> ret = new Vector<Identity>();
        for (Object o : raw) {
            Identity i = this.resolveIdentityBeanCore((IdentityBean)o, sqlMap);
            ret.add(i);
        }
        return ret;
    }

    private EntityBean resolveEntity(String name, SqlSession sqlMap) throws IdentityNotKnownException, InternalException {
        EntityBean res;
        try {
            res = (EntityBean)sqlMap.selectOne("resolveEntity", (Object)name);
        }
        catch (PersistenceException e) {
            String msg = "DB error: Can't resolve entity " + name;
            log.warn((Object)(msg + ". SQL exception is: " + (Object)((Object)e)));
            throw new InternalException(msg);
        }
        if (res == null) {
            throw new IdentityNotKnownException(null);
        }
        return res;
    }

    private EntityBean createEntity(String label, SqlSession sqlMap) throws InternalException {
        EntityBean entityB;
        GenericBean gb = new GenericBean();
        gb.setP1(label);
        gb.setP2(new Date());
        String id = this.idManager.getNewId();
        gb.setP3(id);
        try {
            sqlMap.insert("addEntity", (Object)gb);
            sqlMap.clearCache();
            entityB = (EntityBean)sqlMap.selectOne("resolveEntity", (Object)label);
        }
        catch (PersistenceException e) {
            String msg = "DB error: Can't add a new entity " + label;
            log.error((Object)(msg + ". SQL exception is: " + (Object)((Object)e)));
            throw new InternalException(msg);
        }
        return entityB;
    }

    private void createIdentity(Identity identity, EntityBean entityB, IdentityTypeHelper helper, SqlSession sqlMap) throws InternalException, UnsupportedTypeException, AuthenticationException, InvalidValueException {
        String type = identity.getType().getName().toString();
        int typeId = this.identityTypes.getIdentityTypeId(type);
        IdentityBean param = new IdentityBean();
        param.setCreationTS(new Timestamp(Calendar.getInstance().getTimeInMillis()));
        param.setEntityId(entityB.getId());
        param.setTypeId(typeId);
        param.setValue(identity.getValue());
        param.setCmp(helper.getComparableValue());
        try {
            sqlMap.insert("addIdentity", (Object)param);
            if (identity.getAuthnData() != null) {
                AuthnBean param2 = new AuthnBean();
                param2.setVal(helper.generateAuthNToken());
                IdentityBean idB = null;
                try {
                    idB = this.entitiesCache.resolveIdentity(identity, null, sqlMap);
                    param2.setIdentityId(idB.getId());
                }
                catch (IdentityNotKnownException e) {
                    // empty catch block
                }
                sqlMap.update("changeIdentityAuthn", (Object)param2);
            }
            sqlMap.clearCache();
        }
        catch (PersistenceException e) {
            String msg = "DB error: Can't add a new entity " + identity.getLabel();
            log.error((Object)(msg + ". SQL exception is: " + (Object)((Object)e)));
            throw new InternalException(msg);
        }
    }

    private List<IdentityBean> getEqivalents(int entityId, SqlSession sqlMap) throws InternalException {
        List eqiv;
        try {
            eqiv = sqlMap.selectList("getEquivalentIdentities", (Object)entityId);
        }
        catch (PersistenceException e) {
            String msg = "DB error: Can't retirieve equivalent identities with entity id " + entityId;
            log.warn((Object)(msg + ". SQL exception is: " + (Object)((Object)e)));
            throw new InternalException(msg);
        }
        Vector<IdentityBean> ret = new Vector<IdentityBean>();
        for (Object o : eqiv) {
            ret.add((IdentityBean)o);
        }
        return ret;
    }

    private List<AttributeBean> getAttributes(int entityId, SqlSession sqlMap) throws InternalException {
        List rawAttrs = null;
        try {
            rawAttrs = sqlMap.selectList("getEntityAttributes", (Object)entityId);
        }
        catch (PersistenceException e1) {
            String msg = "DB error: Can't retrieve entity attributes for entity " + entityId;
            log.warn((Object)(msg + ". SQL exception is: " + (Object)((Object)e1)));
            throw new InternalException(msg);
        }
        Vector<AttributeBean> ret = new Vector<AttributeBean>();
        for (Object o : rawAttrs) {
            ret.add((AttributeBean)o);
        }
        return ret;
    }

    private List<AttributeBean> getAttributes(int entityId, int gid, Date when, SqlSession sqlMap) throws InternalException {
        List rawAttrs = null;
        GenericBean gb = new GenericBean();
        gb.setP1(entityId);
        gb.setP2(gid);
        try {
            if (when == null) {
                rawAttrs = gid == -1 ? sqlMap.selectList("getEntityGlobalAttributes", (Object)entityId) : sqlMap.selectList("getEntityGroupAttributes", (Object)gb);
            } else {
                gb.setP3(when);
                rawAttrs = gid == -1 ? sqlMap.selectList("getEntityGlobalAttributesH", (Object)new GenericBean(entityId, when)) : sqlMap.selectList("getEntityGroupAttributesH", (Object)gb);
            }
        }
        catch (PersistenceException e1) {
            String msg = "DB error: Can't retrieve entity attributes for entity " + entityId;
            log.warn((Object)(msg + ". SQL exception is: " + (Object)((Object)e1)));
            throw new InternalException(msg);
        }
        Vector<AttributeBean> ret = new Vector<AttributeBean>();
        for (Object o : rawAttrs) {
            ret.add((AttributeBean)o);
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<AttributeBean> getEffectiveAttributes(int entityId, GroupBean groupB, Date when, SqlSession sqlMap) throws InternalException, IdentityNotKnownException, GroupNotKnownException {
        this.lock.writeLock();
        try {
            List<AttributeBean> ret = this.getAttributes(entityId, -1, when, sqlMap);
            if (groupB.getId() == -1) {
                List<AttributeBean> list = ret;
                return list;
            }
            List<GroupBean> allGroups = this.groups.getAllGroupsRaw(entityId, when, sqlMap);
            for (GroupBean gb : allGroups) {
                List<GroupBean> path = this.groups.getGroupPath(groupB, gb, sqlMap);
                for (GroupBean subGroup : path) {
                    List<AttributeBean> scopedAttrs = this.getAttributes(entityId, subGroup.getId(), when, sqlMap);
                    List<AttributeBean> groupAttrs = this.groups.getAttributes(subGroup.getId(), when, sqlMap);
                    for (AttributeBean ab : groupAttrs) {
                        int i;
                        for (i = 0; i < scopedAttrs.size() && scopedAttrs.get(i).getTypeId() != ab.getTypeId(); ++i) {
                        }
                        if (i != scopedAttrs.size()) continue;
                        ret.add(ab);
                    }
                    ret.addAll(scopedAttrs);
                }
            }
            List<AttributeBean> list = ret;
            return list;
        }
        finally {
            this.lock.writeUnlock();
        }
    }

    private List<AttributeBean> getAttribute(int entityId, int gid, int typeId, Date when, SqlSession sqlMap) throws InternalException {
        List rawAttrs = null;
        AttributeBean param = new AttributeBean();
        param.setEntityId(entityId);
        param.setGroupId(gid);
        param.setTypeId(typeId);
        try {
            if (when == null) {
                rawAttrs = gid == -1 ? sqlMap.selectList("getEntityGlobalAttribute", (Object)param) : sqlMap.selectList("getEntityGroupAttribute", (Object)param);
            } else {
                param.setRemovalTS(new Timestamp(when.getTime()));
                rawAttrs = gid == -1 ? sqlMap.selectList("getEntityGlobalAttributeH", (Object)param) : sqlMap.selectList("getEntityGroupAttributeH", (Object)param);
            }
        }
        catch (PersistenceException e1) {
            String msg = "DB error: Can't retrieve entity attributes for entity " + entityId;
            log.warn((Object)(msg + ". SQL exception is: " + (Object)((Object)e1)));
            throw new InternalException(msg);
        }
        Vector<AttributeBean> ret = new Vector<AttributeBean>();
        for (Object o : rawAttrs) {
            ret.add((AttributeBean)o);
        }
        return ret;
    }
}

