/*
 * Decompiled with CFR 0.152.
 */
package pl.edu.icm.unicore.uvos.db;

import eu.unicore.util.Log;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import org.apache.ibatis.exceptions.PersistenceException;
import org.apache.ibatis.session.SqlSession;
import org.apache.log4j.Logger;
import pl.edu.icm.unicore.uvos.api.Attribute;
import pl.edu.icm.unicore.uvos.api.AttributePermission;
import pl.edu.icm.unicore.uvos.api.AttributeType;
import pl.edu.icm.unicore.uvos.api.PermissionDesignator;
import pl.edu.icm.unicore.uvos.api.Permissions;
import pl.edu.icm.unicore.uvos.api.exceptions.GroupNotKnownException;
import pl.edu.icm.unicore.uvos.api.exceptions.InternalException;
import pl.edu.icm.unicore.uvos.api.exceptions.UnsupportedTypeException;
import pl.edu.icm.unicore.uvos.db.DBAttributeTypes;
import pl.edu.icm.unicore.uvos.db.DBGroupResolver;
import pl.edu.icm.unicore.uvos.db.DBLock;
import pl.edu.icm.unicore.uvos.model.AuthzBean;
import pl.edu.icm.unicore.uvos.model.GroupBean;

public class DBAuthz {
    private static final String OWNER_CODE = "O";
    private static final String MEMBER_CODE = "M";
    private static final Logger log = Log.getLogger((String)"unicore.uvos.server", DBAuthz.class);
    private DBAttributeTypes attributeTypes;
    private DBGroupResolver groupResolver;
    private DBLock lock;

    public DBAuthz(DBAttributeTypes attributeTypes, DBGroupResolver groupResolver, DBLock lock) {
        this.attributeTypes = attributeTypes;
        this.groupResolver = groupResolver;
        this.lock = lock;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void addAuthZAttr(Attribute attr, int group, Permissions perms, SqlSession sqlMap) throws InternalException, UnsupportedTypeException {
        this.lock.writeLock();
        try {
            AuthzBean param = new AuthzBean();
            int attrType = this.attributeTypes.getAttrTypeId(attr.getType(), true, sqlMap);
            param.setAttrType(attrType);
            param.setGroupId(group);
            param.setPermission(perms.getValue());
            List vals = attr.getValues();
            if (vals.size() == 0) {
                param.setAttrValue(null);
                try {
                    sqlMap.insert("insertGroupAuthZ", (Object)param);
                    return;
                }
                catch (PersistenceException e) {
                    log.error((Object)("DB error: Can't add attr authZ for group " + group + ". SQL exception is: " + (Object)((Object)e)));
                    throw new InternalException("DB error: authZ for group: " + group);
                }
            }
            HashSet uniqueVals = new HashSet();
            uniqueVals.addAll(vals);
            for (String val : uniqueVals) {
                param.setAttrValue(val);
                try {
                    sqlMap.insert("insertGroupAuthZ", (Object)param);
                }
                catch (PersistenceException e) {
                    log.error((Object)("DB error: Can't add attr authZ for group " + group + ". SQL exception is: " + (Object)((Object)e)));
                    throw new InternalException("DB error: change attr authZ for group: " + group);
                    return;
                }
            }
        }
        finally {
            this.lock.writeUnlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addAuthZSpecial(PermissionDesignator.SpecialDesignator spec, int group, Permissions perms, SqlSession sqlMap) throws InternalException {
        this.lock.writeLock();
        try {
            AuthzBean param = new AuthzBean();
            param.setGroupId(group);
            param.setPermission(perms.getValue());
            param.setSpecial(OWNER_CODE);
            if (spec.equals((Object)PermissionDesignator.SpecialDesignator.MEMBER)) {
                param.setSpecial(MEMBER_CODE);
            }
            try {
                sqlMap.insert("insertSpecialAuthZ", (Object)param);
            }
            catch (PersistenceException e) {
                log.error((Object)("DB error: Can't add special authZ for group " + group + ". SQL exception is: " + (Object)((Object)e)));
                throw new InternalException("DB error: change special authZ for group: " + group);
            }
        }
        finally {
            this.lock.writeUnlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeAuthZSpecial(PermissionDesignator.SpecialDesignator spec, int group, SqlSession sqlMap) throws InternalException {
        this.lock.writeLock();
        try {
            AuthzBean param = new AuthzBean();
            param.setGroupId(group);
            param.setSpecial(OWNER_CODE);
            if (spec.equals((Object)PermissionDesignator.SpecialDesignator.MEMBER)) {
                param.setSpecial(MEMBER_CODE);
            }
            try {
                if (group == -1) {
                    sqlMap.delete("deleteGlobalAuthZSpecial", (Object)param.getSpecial());
                } else {
                    sqlMap.delete("deleteGroupAuthZSpecial", (Object)param);
                }
            }
            catch (PersistenceException e) {
                log.error((Object)("DB error: Can't delete special authZ for group " + group + ". SQL exception is: " + (Object)((Object)e)));
                throw new InternalException("DB error: change special authZ for group: " + group);
            }
        }
        finally {
            this.lock.writeUnlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeAuthZAttr(Attribute attr, int group, SqlSession sqlMap) throws InternalException, UnsupportedTypeException {
        this.lock.writeLock();
        try {
            AuthzBean param = new AuthzBean();
            param.setGroupId(group);
            int attrType = this.attributeTypes.getAttrTypeId(attr.getName());
            param.setAttrType(attrType);
            try {
                if (attr.getValues().size() == 0) {
                    if (group == -1) {
                        sqlMap.delete("deleteGlobalAuthZAttr", (Object)param);
                    } else {
                        sqlMap.delete("deleteGroupAuthZAttr", (Object)param);
                    }
                } else {
                    for (String val : attr.getValues()) {
                        param.setAttrValue(val);
                        if (group == -1) {
                            sqlMap.delete("deleteGlobalAuthZAttrVal", (Object)param);
                            continue;
                        }
                        sqlMap.delete("deleteGroupAuthZAttrVal", (Object)param);
                    }
                }
            }
            catch (PersistenceException e) {
                log.error((Object)("DB error: Can't delete attr authZ for group " + group + ". SQL exception is: " + (Object)((Object)e)));
                throw new InternalException("DB error: change attr authZ for group: " + group);
            }
        }
        finally {
            this.lock.writeUnlock();
        }
    }

    private List<AuthzBean> getGroupAuthZRaw(int id, SqlSession sqlMap) throws InternalException {
        List res2;
        List res1;
        try {
            if (id != -1) {
                res1 = sqlMap.selectList("getAllGroupAuthZAttr", (Object)id);
                res2 = sqlMap.selectList("getAllGroupAuthZSpecial", (Object)id);
            } else {
                res1 = sqlMap.selectList("getAllGlobalAuthZAttr");
                res2 = sqlMap.selectList("getAllGlobalAuthZSpecial");
            }
        }
        catch (PersistenceException e) {
            log.error((Object)("DB error: Can't get authZ for group " + id + ". SQL exception is: " + (Object)((Object)e)));
            throw new InternalException("DB error: authZ for group: " + id);
        }
        Vector<AuthzBean> ret = new Vector<AuthzBean>();
        for (Object o : res1) {
            ret.add((AuthzBean)o);
        }
        for (Object o : res2) {
            ret.add((AuthzBean)o);
        }
        return ret;
    }

    private List<AttributePermission> convertResult(List<AuthzBean> raw) {
        Vector<AttributePermission> permissions = new Vector<AttributePermission>();
        Hashtable<String, AttributePermission> attrs = new Hashtable<String, AttributePermission>();
        for (AuthzBean ab : raw) {
            if (ab.getSpecial() != null) {
                PermissionDesignator designator = ab.getSpecial().equals(OWNER_CODE) ? new PermissionDesignator(PermissionDesignator.SpecialDesignator.OWNER) : new PermissionDesignator(PermissionDesignator.SpecialDesignator.MEMBER);
                permissions.add(new AttributePermission(designator, new Permissions(ab.getPermission())));
                continue;
            }
            String typeName = this.attributeTypes.getAttrType4Id(ab.getAttrType());
            String key = ab.getPermission() + typeName;
            key = (ab.getAttrValue() != null ? "V" : "N") + key;
            AttributePermission at = (AttributePermission)attrs.get(key);
            if (at == null) {
                Attribute a = new Attribute(new AttributeType(typeName), new Vector(), null, null, null);
                at = new AttributePermission(new PermissionDesignator(a), new Permissions(ab.getPermission()));
                attrs.put(key, at);
            }
            if (ab.getAttrValue() == null) continue;
            at.getDesignator().getAttribute().addValue(ab.getAttrValue());
        }
        Iterator hashVals = attrs.values().iterator();
        while (hashVals.hasNext()) {
            permissions.add((AttributePermission)hashVals.next());
        }
        return permissions;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<AuthzBean> getGroupAuthZRaw(GroupBean groupB, boolean effective, SqlSession sqlMap) throws InternalException, GroupNotKnownException {
        this.lock.writeLock();
        try {
            List<AuthzBean> raw = this.getGroupAuthZRaw(groupB.getId(), sqlMap);
            if (effective && groupB.getId() != -1) {
                while (raw.size() == 0 && groupB.getParent() != -1) {
                    groupB = this.groupResolver.resolveGroup4Id(groupB.getParent(), sqlMap);
                    raw = this.getGroupAuthZRaw(groupB.getId(), sqlMap);
                }
                if (raw.size() == 0) {
                    raw = this.getGroupAuthZRaw(-1, sqlMap);
                }
            }
            List<AuthzBean> list = raw;
            return list;
        }
        finally {
            this.lock.writeUnlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<AttributePermission> getGroupAuthZ(GroupBean groupB, boolean effective, SqlSession sqlMap) throws InternalException, GroupNotKnownException {
        this.lock.writeLock();
        try {
            List<AttributePermission> list = this.convertResult(this.getGroupAuthZRaw(groupB, effective, sqlMap));
            return list;
        }
        finally {
            this.lock.writeUnlock();
        }
    }
}

