/*
 * Decompiled with CFR 0.152.
 */
package pl.edu.icm.unicore.uvos.db;

import eu.unicore.util.Log;
import java.util.Date;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import org.apache.ibatis.exceptions.PersistenceException;
import org.apache.ibatis.session.SqlSession;
import org.apache.log4j.Logger;
import pl.edu.icm.unicore.uvos.api.Attribute;
import pl.edu.icm.unicore.uvos.api.AttributeType;
import pl.edu.icm.unicore.uvos.api.exceptions.InternalException;
import pl.edu.icm.unicore.uvos.api.exceptions.UnsupportedTypeException;
import pl.edu.icm.unicore.uvos.db.DB;
import pl.edu.icm.unicore.uvos.db.DBLock;
import pl.edu.icm.unicore.uvos.model.AttributeBean;
import pl.edu.icm.unicore.uvos.model.AttributeTypeBean;

public class DBAttributeTypes {
    private static final Logger log = Log.getLogger((String)"unicore.uvos.server", DBAttributeTypes.class);
    private Hashtable<String, AttributeTypeBean> attributeTypes;
    private Hashtable<Integer, String> attributeTypes2;
    private Vector<AttributeType> attributeTypesL;
    private DBLock lock;

    public DBAttributeTypes(DB db, DBLock lock) throws InternalException {
        this.lock = lock;
        this.attributeTypes = new Hashtable();
        this.attributeTypes2 = new Hashtable();
        this.attributeTypesL = new Vector();
        SqlSession sqlMap = db.getSqlSession();
        try {
            List attrTypes = sqlMap.selectList("getAllAttributeTypes");
            for (Object o : attrTypes) {
                AttributeTypeBean ab = (AttributeTypeBean)o;
                this.attributeTypes.put(ab.getType(), ab);
                this.attributeTypesL.add(new AttributeType(ab.getType(), ab.getShortDesc(), ab.getDescription()));
                this.attributeTypes2.put(ab.getId(), ab.getType());
            }
        }
        catch (PersistenceException e) {
            log.error((Object)("DB error: getting types. SQL error is: " + (Object)((Object)e)));
            throw new InternalException("Can't load attribute types.");
        }
        finally {
            db.releaseSqlSession(sqlMap);
        }
    }

    public int getAttrTypeId(AttributeType at, boolean create, SqlSession sqlMap) throws UnsupportedTypeException, InternalException {
        AttributeTypeBean b = this.attributeTypes.get(at.getName());
        if (b == null && !create) {
            throw new UnsupportedTypeException();
        }
        if (b != null) {
            return b.getId();
        }
        this.lock.writeLock();
        try {
            AttributeTypeBean atb = new AttributeTypeBean();
            atb.setType(at.getName());
            atb.setShortDesc(at.getShortDescription());
            atb.setDescription(at.getShortDescription());
            sqlMap.insert("addAttributeType", (Object)atb);
            sqlMap.clearCache();
            Integer newId = (Integer)sqlMap.selectOne("getAttributeTypeId", (Object)atb.getType());
            atb.setId(newId);
            this.attributeTypes.put(atb.getType(), atb);
            this.attributeTypes2.put(newId, atb.getType());
            this.attributeTypesL.add(at);
            int n = newId;
            return n;
        }
        catch (PersistenceException e) {
            log.error((Object)"Can't create a new attribute type", (Throwable)e);
            throw new InternalException("Can't create a new attribute type");
        }
        finally {
            this.lock.writeUnlock();
        }
    }

    public int getAttrTypeId(String name) throws UnsupportedTypeException, InternalException {
        AttributeTypeBean b = this.attributeTypes.get(name);
        if (b == null) {
            throw new UnsupportedTypeException();
        }
        return b.getId();
    }

    public void addAttrType(AttributeType at, SqlSession sqlMap) throws InternalException {
        AttributeTypeBean b = new AttributeTypeBean();
        b.setDescription(at.getDescription());
        b.setShortDesc(at.getShortDescription());
        b.setType(at.getName());
        this.lock.writeLock();
        try {
            sqlMap.insert("addAttributeType", (Object)b);
            Integer newId = (Integer)sqlMap.selectOne("getAttributeTypeId", (Object)at.getName());
            b.setId(newId);
            this.attributeTypes.put(at.getName(), b);
            this.attributeTypes2.put(newId, at.getName());
            this.attributeTypesL.add(at);
        }
        catch (PersistenceException e) {
            log.error((Object)"Can't create a new attribute type", (Throwable)e);
            throw new InternalException("Can't create a new attribute type");
        }
        finally {
            this.lock.writeUnlock();
        }
    }

    public void updateAttrType(AttributeType at, SqlSession sqlMap) throws InternalException {
        AttributeTypeBean b = this.attributeTypes.get(at.getName());
        b.setDescription(at.getDescription());
        b.setShortDesc(at.getShortDescription());
        b.setType(at.getName());
        this.lock.writeLock();
        try {
            sqlMap.update("updateAttributeType", (Object)b);
            for (int i = 0; i < this.attributeTypesL.size(); ++i) {
                if (!this.attributeTypesL.get(i).getName().equals(at.getName())) continue;
                this.attributeTypesL.set(i, at);
                break;
            }
        }
        catch (PersistenceException e) {
            log.error((Object)"Can't create a new attribute type", (Throwable)e);
            throw new InternalException("Can't create a new attribute type");
        }
        finally {
            this.lock.writeUnlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteAttrType(AttributeType at, SqlSession sqlMap) throws InternalException {
        this.lock.writeLock();
        try {
            Integer newId = (Integer)sqlMap.selectOne("getAttributeTypeId", (Object)at.getName());
            sqlMap.delete("deleteAttributeType", (Object)at.getName());
            this.attributeTypes.remove(at.getName());
            this.attributeTypes2.remove(newId);
            for (int i = 0; i < this.attributeTypesL.size(); ++i) {
                if (!this.attributeTypesL.get(i).getName().equals(at.getName())) continue;
                this.attributeTypesL.remove(i);
                break;
            }
        }
        catch (PersistenceException e) {
            log.info((Object)("Can't remove attribute type (can be OK, if it has a corresponding attribute): " + e.getMessage()));
        }
        finally {
            this.lock.writeUnlock();
        }
    }

    public List<AttributeType> getAttributeTypes() {
        return this.attributeTypesL;
    }

    public String getAttrType4Id(int id) {
        return this.attributeTypes2.get(id);
    }

    List<Attribute> prepareAttributeList(List<?> rawL, String scope) throws InternalException {
        HashMap<String, Attribute> hash = new HashMap<String, Attribute>();
        for (Object obj : rawL) {
            Attribute at;
            AttributeBean ab = (AttributeBean)obj;
            AttributeTypeBean atb = this.attributeTypes.get(this.getAttrType4Id(ab.getTypeId()));
            String typeName = atb.getType();
            if (ab.getGroupId() != -1 && scope == null) {
                log.error((Object)("BUG!!! att without requested scope has scope set: " + ab.getId()));
            }
            if ((at = (Attribute)hash.get(typeName = (scope == null ? "" : scope) + "//" + typeName)) == null) {
                at = new Attribute(new AttributeType(atb.getType(), atb.getShortDesc(), atb.getShortDesc()), new Vector(), scope, (Date)ab.getCreationTS(), null);
                hash.put(typeName, at);
            }
            List curVals = at.getValues();
            if (ab.getVal() == null || curVals.contains(ab.getVal())) continue;
            at.addValue(ab.getVal());
        }
        Vector<Attribute> ret = new Vector<Attribute>();
        Iterator hashVals = hash.values().iterator();
        while (hashVals.hasNext()) {
            ret.add((Attribute)hashVals.next());
        }
        return ret;
    }
}

