/*
 * Decompiled with CFR 0.152.
 */
package pl.edu.icm.unicore.uvos.db;

import eu.unicore.util.Log;
import java.util.ArrayList;
import java.util.List;
import org.apache.ibatis.exceptions.PersistenceException;
import org.apache.ibatis.session.SqlSession;
import org.apache.log4j.Logger;
import pl.edu.icm.unicore.uvos.api.ApplicationStatus;
import pl.edu.icm.unicore.uvos.api.Group;
import pl.edu.icm.unicore.uvos.api.Identity;
import pl.edu.icm.unicore.uvos.api.VOApplication;
import pl.edu.icm.unicore.uvos.api.VOApplicationForm;
import pl.edu.icm.unicore.uvos.api.exceptions.AuthenticationException;
import pl.edu.icm.unicore.uvos.api.exceptions.GroupNotKnownException;
import pl.edu.icm.unicore.uvos.api.exceptions.InternalException;
import pl.edu.icm.unicore.uvos.api.exceptions.UnsupportedTypeException;
import pl.edu.icm.unicore.uvos.api.exceptions.VOApplicationException;
import pl.edu.icm.unicore.uvos.db.DBEntitiesCache;
import pl.edu.icm.unicore.uvos.db.DBGroupResolver;
import pl.edu.icm.unicore.uvos.db.DBIdentityTypes;
import pl.edu.icm.unicore.uvos.idhelpers.IdentityTypeHelper;
import pl.edu.icm.unicore.uvos.model.GroupBean;
import pl.edu.icm.unicore.uvos.model.IdentityBean;
import pl.edu.icm.unicore.uvos.model.VOApplicationBean;
import pl.edu.icm.unicore.uvos.model.VOApplicationFormBean;

public class DBApps {
    private DBIdentityTypes identityTypes;
    private DBEntitiesCache entitiesCache;
    private DBGroupResolver groupResolver;
    private static final Logger log = Log.getLogger((String)"unicore.uvos.server", DBApps.class);

    public DBApps(DBIdentityTypes identities, DBEntitiesCache entitiesCache, DBGroupResolver groupResolver) {
        this.identityTypes = identities;
        this.entitiesCache = entitiesCache;
        this.groupResolver = groupResolver;
    }

    public synchronized void addAppForm(VOApplicationForm toAdd, SqlSession sqlMap) throws InternalException, VOApplicationException {
        VOApplicationFormBean b = new VOApplicationFormBean();
        b.setAgreement(toAdd.getAgreement());
        b.setConstraints(toAdd.getConstraints());
        b.setDescription(toAdd.getDescription());
        b.setFriendlyName(toAdd.getFriendlyName());
        try {
            int baseGroupId = this.groupResolver.resolveGroup(toAdd.getBaseGroup(), null, sqlMap).getId();
            b.setBaseGroup(baseGroupId);
            sqlMap.insert("insertAppForm", (Object)b);
        }
        catch (PersistenceException e) {
            log.error((Object)("DB error: Can't add a new application form " + toAdd + ". SQL exception is: " + (Object)((Object)e)));
            throw new InternalException("DB error: Can't add a new application form: " + (Object)((Object)e));
        }
        catch (GroupNotKnownException e) {
            throw new VOApplicationException("Group referenced in application form to be added doesn't exists.");
        }
    }

    public synchronized void updateAppForm(VOApplicationForm toUpdate, int baseGroup, SqlSession sqlMap) throws InternalException {
        VOApplicationFormBean b = new VOApplicationFormBean();
        b.setAgreement(toUpdate.getAgreement());
        b.setConstraints(toUpdate.getConstraints());
        b.setDescription(toUpdate.getDescription());
        b.setFriendlyName(toUpdate.getFriendlyName());
        b.setBaseGroup(baseGroup);
        b.setId(toUpdate.getId());
        try {
            sqlMap.update("updateAppForm", (Object)b);
        }
        catch (PersistenceException e) {
            log.error((Object)("DB error: Can't update an application form with id " + toUpdate.getId() + ". SQL exception is: " + (Object)((Object)e)));
            throw new InternalException("DB error: Can't update an  application form with id " + toUpdate.getId() + ": " + (Object)((Object)e));
        }
    }

    public synchronized VOApplicationForm resolveAppForm(int id, SqlSession sqlMap) throws InternalException, VOApplicationException {
        try {
            VOApplicationFormBean b = (VOApplicationFormBean)sqlMap.selectOne("resolveAppForm", (Object)id);
            if (b == null) {
                throw new VOApplicationException("Application form with id " + id + " isn't known.");
            }
            Group g = this.groupResolver.resolveGroupBean(this.groupResolver.resolveGroup4Id(b.getBaseGroup(), sqlMap), sqlMap);
            VOApplicationForm af = new VOApplicationForm(b.getFriendlyName(), b.getDescription(), b.getId(), b.getAgreement(), g, b.getConstraints());
            return af;
        }
        catch (PersistenceException e) {
            log.error((Object)("DB error: Can't get application form with id " + id + ". SQL exception is: " + (Object)((Object)e)));
            throw new InternalException("DB error: Can't get application form with id " + id + ": " + (Object)((Object)e));
        }
        catch (GroupNotKnownException e) {
            log.error((Object)("DB error: can't resolve base group of application. SQL exception is: " + (Object)((Object)e)));
            throw new InternalException("DB error: can't resolve base group of application" + (Object)((Object)e));
        }
    }

    public synchronized GroupBean getAppFormGroup(int id, SqlSession sqlMap) throws InternalException, VOApplicationException {
        int gid;
        try {
            VOApplicationFormBean b = (VOApplicationFormBean)sqlMap.selectOne("resolveAppForm", (Object)id);
            if (b == null) {
                throw new VOApplicationException("Application form with id " + id + " isn't known.");
            }
            gid = b.getBaseGroup();
        }
        catch (PersistenceException e) {
            log.error((Object)("DB error: Can't get application form with id " + id + ". SQL exception is: " + (Object)((Object)e)));
            throw new InternalException("DB error: Can't get application form with id " + id + ": " + (Object)((Object)e));
        }
        try {
            return this.groupResolver.resolveGroup4Id(gid, sqlMap);
        }
        catch (GroupNotKnownException e) {
            throw new InternalException("BUG: Can't resolve group with id " + gid + " which is referenced in app form.");
        }
    }

    public synchronized void removeAppForm(int toRemove, SqlSession sqlMap) throws InternalException {
        try {
            sqlMap.delete("deleteAppForm", (Object)toRemove);
        }
        catch (PersistenceException e) {
            log.error((Object)("DB error: Can't remove an application form with id " + toRemove + ". SQL exception is: " + (Object)((Object)e)));
            throw new InternalException("DB error: Can't remove an  application form with id " + toRemove + ": " + (Object)((Object)e));
        }
    }

    public synchronized void removeAppFormsByGroup(int group, SqlSession sqlMap) throws InternalException {
        try {
            sqlMap.delete("deleteAppFormsByGroup", (Object)group);
        }
        catch (PersistenceException e) {
            log.error((Object)("DB error: Can't remove application forms with group id " + group + ". SQL exception is: " + (Object)((Object)e)));
            throw new InternalException("DB error: Can't remove application forms with group id " + group + ": " + (Object)((Object)e));
        }
    }

    public synchronized List<VOApplicationForm> listAppForms(SqlSession sqlMap) throws InternalException {
        try {
            List raw = sqlMap.selectList("getAppForms");
            ArrayList<VOApplicationForm> ret = new ArrayList<VOApplicationForm>();
            for (int i = 0; i < raw.size(); ++i) {
                VOApplicationFormBean b = (VOApplicationFormBean)raw.get(i);
                Group g = this.groupResolver.resolveGroupBean(this.groupResolver.resolveGroup4Id(b.getBaseGroup(), sqlMap), sqlMap);
                VOApplicationForm af = new VOApplicationForm(b.getFriendlyName(), b.getDescription(), b.getId(), b.getAgreement(), g, b.getConstraints());
                ret.add(af);
            }
            return ret;
        }
        catch (PersistenceException e) {
            log.error((Object)("DB error: Can't list application forms. SQL exception is: " + (Object)((Object)e)));
            throw new InternalException("DB error: Can't list  application forms: " + (Object)((Object)e));
        }
        catch (GroupNotKnownException e) {
            log.error((Object)("DB error: can't resolve base group of application. SQL exception is: " + (Object)((Object)e)));
            throw new InternalException("DB error: can't resolve base group of application" + (Object)((Object)e));
        }
    }

    public synchronized void addApplication(VOApplication toAdd, IdentityTypeHelper helper, SqlSession sqlMap) throws InternalException, UnsupportedTypeException, VOApplicationException {
        VOApplicationBean b = new VOApplicationBean();
        Identity idToAdd = toAdd.getIdentity();
        if (helper != null) {
            try {
                b.setAuthnData(helper.generateAuthNToken());
            }
            catch (AuthenticationException e1) {
                throw new InternalException("Can't encode authentication token of application");
            }
        }
        b.setFormId(toAdd.getFormId());
        b.setIdentityType(this.identityTypes.getIdentityTypeId(idToAdd.getType().getName()));
        b.setIdentityValue(idToAdd.getValue());
        b.setIsCSR(toAdd.isCSR() ? 1 : 0);
        b.setEmailAddress(toAdd.getEmailAddress());
        b.setRequests(toAdd.getRequests());
        b.setStatus(ApplicationStatus.PENDING.toString());
        b.setAdminNotes(null);
        if (toAdd.getEquivalentIdentity() != null) {
            try {
                int id = this.entitiesCache.resolveIdentity(toAdd.getEquivalentIdentity(), null, sqlMap).getId();
                b.setEquivalentIdentityId(id);
            }
            catch (Exception e) {
                throw new VOApplicationException("Requested equivalent identity is not known.");
            }
        } else {
            b.setEquivalentIdentityId(-1);
        }
        try {
            sqlMap.insert("insertApp", (Object)b);
        }
        catch (PersistenceException e) {
            log.error((Object)("DB error: Can't add a new application " + toAdd + ". SQL exception is: " + (Object)((Object)e)));
            throw new InternalException("DB error: Can't add a new application: " + (Object)((Object)e));
        }
    }

    public synchronized void updateApplication(int id, String adminNotes, ApplicationStatus status, SqlSession sqlMap) throws InternalException {
        VOApplicationBean b = new VOApplicationBean();
        b.setId(id);
        b.setStatus(status.toString());
        b.setAdminNotes(adminNotes);
        try {
            sqlMap.update("updateApp", (Object)b);
        }
        catch (PersistenceException e) {
            log.error((Object)("DB error: Can't update an application " + id + ". SQL exception is: " + (Object)((Object)e)));
            throw new InternalException("DB error: Can't update an application: " + (Object)((Object)e));
        }
    }

    public synchronized void removeApplication(int id, SqlSession sqlMap) throws InternalException, VOApplicationException {
        try {
            sqlMap.delete("deleteApp", (Object)id);
        }
        catch (PersistenceException e) {
            log.error((Object)("DB error: Can't remove application with id " + id + ". SQL exception is: " + (Object)((Object)e)));
            throw new InternalException("DB error: Can't remove application: " + (Object)((Object)e));
        }
    }

    public synchronized VOApplication resolveApplication(int id, SqlSession sqlMap) throws InternalException, VOApplicationException {
        try {
            VOApplicationBean bean = (VOApplicationBean)sqlMap.selectOne("getAppById", (Object)id);
            if (bean == null) {
                throw new VOApplicationException("Application with id " + id + " doesn't exist");
            }
            return this.mapApplicationBean(bean, sqlMap);
        }
        catch (PersistenceException e) {
            log.error((Object)("DB error: Can't get application with id " + id + ". SQL exception is: " + (Object)((Object)e)));
            throw new InternalException("DB error: Can't get application: " + (Object)((Object)e));
        }
    }

    public synchronized List<VOApplication> getApplications(Integer formId, String status, SqlSession sqlMap) throws InternalException {
        List rawRet;
        try {
            if (formId == null && status == null) {
                rawRet = sqlMap.selectList("getAllApps");
            } else if (formId == null) {
                rawRet = sqlMap.selectList("getAppByStatus", (Object)status);
            } else if (status == null) {
                rawRet = sqlMap.selectList("getAppByFormId", (Object)formId);
            } else {
                VOApplicationBean b = new VOApplicationBean();
                b.setFormId(formId);
                b.setStatus(status);
                rawRet = sqlMap.selectList("getApps", (Object)b);
            }
        }
        catch (PersistenceException e) {
            log.error((Object)("DB error: Can't get applications list. SQL exception is: " + (Object)((Object)e)));
            throw new InternalException("DB error: Can't get applications list: " + (Object)((Object)e));
        }
        ArrayList<VOApplication> voApps = new ArrayList<VOApplication>();
        for (int i = 0; i < rawRet.size(); ++i) {
            VOApplicationBean b = (VOApplicationBean)rawRet.get(i);
            voApps.add(this.mapApplicationBean(b, sqlMap));
        }
        return voApps;
    }

    private VOApplication mapApplicationBean(VOApplicationBean b, SqlSession sqlMap) {
        Identity id = new Identity(this.identityTypes.getIdentityType4Id(b.getIdentityType()), b.getIdentityValue());
        id.setAuthnData((Object)b.getAuthnData());
        Identity equivalent = null;
        if (b.getEquivalentIdentityId() != -1) {
            try {
                IdentityBean ib = this.entitiesCache.getIdentity4Id(b.getEquivalentIdentityId(), sqlMap);
                equivalent = new Identity(this.identityTypes.getIdentityType4Id(ib.getTypeId()), ib.getValue());
            }
            catch (Exception e) {
                log.warn((Object)("Got VO application with request for equivalentidentity but the equivalent seems to be deleted. Will treat it as normal application. Requested identity is: " + id));
            }
        }
        VOApplication ap = new VOApplication(b.getId(), b.getFormId(), id, b.getIsCSR() != 0, b.getEmailAddress(), b.getRequests(), equivalent, ApplicationStatus.valueOf((String)b.getStatus()), b.getAdminNotes());
        return ap;
    }

    public synchronized List getCSRApplications(SqlSession sqlMap) throws InternalException {
        try {
            return sqlMap.selectList("getCSRApps");
        }
        catch (PersistenceException e) {
            log.error((Object)("DB error: Can't get applications list. SQL exception is: " + (Object)((Object)e)));
            throw new InternalException("DB error: Can't get applications list: " + (Object)((Object)e));
        }
    }

    public synchronized void updateCSRApplication(int id, ApplicationStatus status, boolean isCSR, String identityValue, SqlSession sqlMap) throws InternalException {
        VOApplicationBean b = new VOApplicationBean();
        b.setId(id);
        b.setStatus(status.toString());
        b.setIdentityValue(identityValue);
        b.setIsCSR(isCSR ? 1 : 0);
        try {
            sqlMap.update("updateCSRApp", (Object)b);
        }
        catch (PersistenceException e) {
            log.error((Object)("DB error: Can't update a CSR application " + id + ". SQL exception is: " + (Object)((Object)e)));
            throw new InternalException("DB error: Can't update a CSR application: " + (Object)((Object)e));
        }
    }
}

