/*
 * Decompiled with CFR 0.152.
 */
package pl.edu.icm.unicore.uvos.db;

import eu.unicore.util.Log;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.Reader;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Vector;
import org.apache.ibatis.exceptions.PersistenceException;
import org.apache.ibatis.executor.ExecutorException;
import org.apache.ibatis.session.SqlSession;
import org.apache.ibatis.session.SqlSessionFactory;
import org.apache.ibatis.session.SqlSessionFactoryBuilder;
import org.apache.log4j.Logger;
import pl.edu.icm.unicore.uvos.api.Attribute;
import pl.edu.icm.unicore.uvos.api.exceptions.InternalException;
import pl.edu.icm.unicore.uvos.db.DBLock;
import pl.edu.icm.unicore.uvos.util.UVOSServerProperties;

public class DB {
    private static final Logger log = Log.getLogger((String)"unicore.uvos.server", DB.class);
    public static final String DB_VERSION = "1_2_0";
    public static final String P_URL = "url";
    public static final String P_DRIVER = "driver";
    public static final String P_USERNAME = "username";
    public static final String P_PASSWD = "password";
    public static final String INIT_DATA_SCRIPT_DEF = "conf/db/initdata.sql";
    public static final String CLEAR_SCRIPT_DEF = "conf/db/cleardb.sql";
    public static final String CHECK_SCRIPT_DEF = "conf/db/checkdb.sql";
    public static final String P_INIT_DATA_SCRIPT = "initdata.script";
    public static final String P_CLEAR_SCRIPT = "cleardb.script";
    public static final String P_CHECK_SCRIPT = "checkdb.script";
    public static final String P_CREATEDB_SCRIPT = "createdb.script";
    public static final int SESSION_KEEP_WARN_TIME = 2000;
    private SqlSessionFactory sqlMapFactory;
    private boolean shutdown = false;
    private DBLock lock;
    private Map<SqlSession, Holder> used = new HashMap<SqlSession, Holder>();

    public DB(UVOSServerProperties config, DBLock lock) throws InternalException, FileNotFoundException {
        this.lock = lock;
        String configFile = config.getValue("db.mapconfigFile");
        FileReader reader = new FileReader(configFile);
        SqlSessionFactoryBuilder builder = new SqlSessionFactoryBuilder();
        this.sqlMapFactory = builder.build((Reader)reader);
        this.verifyDBVersion(configFile);
    }

    public static List<Attribute> cleanupAttributeList(List<Attribute> withDuplicates) {
        HashMap<String, Attribute> hash = new HashMap<String, Attribute>();
        for (Attribute input : withDuplicates) {
            String typeName = input.getName().toString();
            String scope = input.getScope();
            typeName = (scope == null ? "" : scope) + "//" + typeName;
            Attribute at = (Attribute)hash.get(typeName);
            if (at == null) {
                hash.put(typeName, input);
                continue;
            }
            List newVals = input.getValues();
            if (newVals == null) continue;
            List curVals = at.getValues();
            for (String newVal : newVals) {
                if (curVals.contains(newVal)) continue;
                curVals.add(newVal);
            }
        }
        Vector<Attribute> ret = new Vector<Attribute>();
        Iterator hashVals = hash.values().iterator();
        while (hashVals.hasNext()) {
            ret.add((Attribute)hashVals.next());
        }
        return ret;
    }

    private void verifyDBVersion(String configFile) throws InternalException {
        String actualDbVersion;
        try {
            actualDbVersion = this.checkCurrentVersion();
        }
        catch (Exception e) {
            throw new InternalException("Can't read version of the database. Have you initialized it? Are connection details correctly entered in configuration? The error was:\n\n" + e);
        }
        if (!actualDbVersion.equals(DB_VERSION)) {
            throw new InternalException("The database is initialized with wrong schema. It is of UVOS version: " + actualDbVersion + " while you are using now UVOS version:" + DB_VERSION);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SqlSession getSqlSession() {
        this.runSessionWatchdog();
        SqlSession newSession = this.sqlMapFactory.openSession();
        DB dB = this;
        synchronized (dB) {
            Holder h = new Holder(System.currentTimeMillis(), Thread.currentThread().getStackTrace(), Thread.currentThread().getName());
            Holder p = this.used.put(newSession, h);
            if (p != null) {
                log.warn((Object)"Ups! MyBatis returned a SqlSession which is already used!");
            }
        }
        return newSession;
    }

    public synchronized void runSessionWatchdog() {
        long now = System.currentTimeMillis();
        Iterator<Map.Entry<SqlSession, Holder>> it = this.used.entrySet().iterator();
        while (it.hasNext()) {
            Holder e = it.next().getValue();
            long wait = now - e.timestamp;
            long sinceLastLog = now - e.lastReport;
            if (wait <= 2000L || sinceLastLog <= e.reportDelay) continue;
            e.lastReport = now;
            e.reportDelay *= 2L;
            log.warn((Object)("SqlSession is kept for more than 2s: " + (double)wait / 1000.0 + "s by " + e.threadName + ". Next report in at least " + e.reportDelay + "ms. Stacktrace is:\n" + this.produceStackTrace(e.stackTrace)));
        }
    }

    private String produceStackTrace(StackTraceElement[] stackTrace) {
        StringBuilder sb = new StringBuilder();
        for (StackTraceElement se : stackTrace) {
            sb.append("  ").append(se.toString()).append("\n");
        }
        return sb.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void releaseSqlSession(SqlSession session) {
        DB dB = this;
        synchronized (dB) {
            Holder p = this.used.remove(session);
            if (p == null) {
                log.warn((Object)("Thread trying to release not known session:\n" + this.produceStackTrace(Thread.currentThread().getStackTrace())));
            }
        }
        session.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void shutdown() {
        if (this.shutdown) {
            return;
        }
        SqlSession sqlMap = this.getSqlSession();
        try {
            Properties dbConf = sqlMap.getConfiguration().getVariables();
            String driver = dbConf.getProperty(P_DRIVER);
            if ("org.hsqldb.jdbcDriver".equals(driver)) {
                Connection conn = sqlMap.getConnection();
                conn.createStatement().execute("SHUTDOWN");
            }
            this.shutdown = true;
        }
        catch (ExecutorException e) {
        }
        catch (SQLException e) {
            log.warn((Object)"Can't close DB connection", (Throwable)e);
        }
        catch (PersistenceException e) {
            log.warn((Object)"Can't close DB connection", (Throwable)e);
        }
        finally {
            this.releaseSqlSession(sqlMap);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String checkCurrentVersion() throws Exception {
        SqlSession sqlMap = this.getSqlSession();
        try {
            List versions = sqlMap.selectList("getDBVersions");
            String ver = "1_0_0";
            for (Object o : versions) {
                String v = (String)o;
                if (ver.compareTo(v = v.trim()) >= 0) continue;
                ver = v;
            }
            String string = ver;
            return string;
        }
        finally {
            this.releaseSqlSession(sqlMap);
        }
    }

    public void purgeHistory(Date date, SqlSession sqlMap) throws InternalException {
        this.lock.writeLock();
        try {
            sqlMap.delete("purgeHistory1", (Object)date);
            sqlMap.delete("purgeHistory2", (Object)date);
            sqlMap.delete("purgeHistory3", (Object)date);
            sqlMap.delete("purgeHistory4", (Object)date);
            sqlMap.delete("purgeHistory5", (Object)date);
            sqlMap.delete("purgeHistory6", (Object)date);
            sqlMap.delete("purgeHistory7", (Object)date);
        }
        catch (PersistenceException e) {
            String msg = "Error purging history: " + e.getMessage();
            log.error((Object)(msg + ". SQL exception is: " + (Object)((Object)e)));
            throw new InternalException(msg);
        }
        finally {
            this.lock.writeUnlock();
        }
    }

    private static class Holder {
        private long timestamp;
        private long reportDelay = 1000L;
        private long lastReport = -1000L;
        private StackTraceElement[] stackTrace;
        private String threadName;

        public Holder(long timestamp, StackTraceElement[] stackTrace, String threadName) {
            this.timestamp = timestamp;
            this.stackTrace = stackTrace;
            this.threadName = threadName;
        }
    }
}

