/*
 * Decompiled with CFR 0.152.
 */
package pl.edu.icm.unicore.uvos.wsapi.xmlbeans;

import eu.unicore.samly2.SAMLConstants;
import eu.unicore.samly2.exceptions.SAMLParseException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.apache.xmlbeans.XmlCursor;
import org.apache.xmlbeans.XmlObject;
import org.apache.xmlbeans.XmlString;
import pl.edu.icm.unicore.uvos.api.Attribute;
import pl.edu.icm.unicore.uvos.api.AttributeType;
import pl.edu.icm.unicore.uvos.wsapi.xmlbeans.SAMLAttributeProfile;
import pl.edu.icm.unicore.uvos.wsapi.xmlbeans.UnsupportedSAMLException;
import xmlbeans.pl.edu.icm.samlvo.attrext.ScopedStringAttributeValueType;

public class SAMLUVOSAttributeProfile
implements SAMLAttributeProfile {
    @Override
    public int isSupported(xmlbeans.org.oasis.saml2.assertion.AttributeType xmlAttr) {
        XmlCursor cur = xmlAttr.newCursor();
        String scopingType = cur.getAttributeText(SAMLConstants.SCOPE_TYPE_XMLATTRIBUTE);
        String scope = cur.getAttributeText(SAMLConstants.ATTRIBUTE_SCOPE_XMLATTRIBUTE);
        cur.dispose();
        if (scopingType != null || scope != null) {
            return 100;
        }
        return -1;
    }

    @Override
    public List<Attribute> map(xmlbeans.org.oasis.saml2.assertion.AttributeType xmlAttr) throws UnsupportedSAMLException, SAMLParseException {
        AttributeType at = new AttributeType(xmlAttr.getName());
        String shortDesc = xmlAttr.getFriendlyName();
        if (shortDesc != null) {
            at.setShortDescription(shortDesc);
        }
        XmlObject[] xmlVals = xmlAttr.getAttributeValueArray();
        ArrayList<Attribute> ret = new ArrayList<Attribute>();
        XmlCursor cur = xmlAttr.newCursor();
        String xacmlDT = cur.getAttributeText(SAMLConstants.XACMLDT);
        String scopingType = cur.getAttributeText(SAMLConstants.SCOPE_TYPE_XMLATTRIBUTE);
        String scope = cur.getAttributeText(SAMLConstants.ATTRIBUTE_SCOPE_XMLATTRIBUTE);
        cur.dispose();
        if (xacmlDT != null) {
            at.setDataType(xacmlDT);
        }
        if (xmlVals == null || xmlVals.length == 0) {
            ret.add(new Attribute(at, null, scope));
            return ret;
        }
        HashMap<String, Integer> attrMap = new HashMap<String, Integer>();
        for (int i = 0; i < xmlVals.length; ++i) {
            Attribute tmp = this.mapAttrValue2APIAttr(at, xmlVals[i], scopingType);
            Integer idx = (Integer)attrMap.get(tmp.getScope());
            if (idx == null) {
                attrMap.put(tmp.getScope(), ret.size());
                ret.add(tmp);
                continue;
            }
            Attribute existingA = ret.get(idx);
            if (tmp.getValues().size() <= 0) continue;
            existingA.addValue(tmp.getValues().get(0));
        }
        return ret;
    }

    private Attribute mapAttrValue2APIAttr(AttributeType at, XmlObject value, String scopingType) throws UnsupportedSAMLException, SAMLParseException {
        String scope = null;
        ArrayList<String> values = new ArrayList<String>();
        if (scopingType == null) {
            scopingType = "urn:SAML:voprofile:NonScopedValue";
        }
        if (value instanceof XmlString && scopingType.equals("urn:SAML:voprofile:NonScopedValue")) {
            values.add(((XmlString)value).getStringValue());
        } else if (value instanceof ScopedStringAttributeValueType && scopingType.equals("urn:SAML:voprofile:ScopedValue")) {
            ScopedStringAttributeValueType av = (ScopedStringAttributeValueType)value;
            scope = av.getScope();
            if (scope.equals("/")) {
                scope = null;
            }
            String v = av.getStringValue();
            if (!av.isNil()) {
                values.add(v);
            }
        } else if (value instanceof XmlString && scopingType.equals("urn:SAML:voprofile:SimpleScopedString")) {
            String content = ((XmlString)value).getStringValue();
            if (content == null || !content.contains("@/")) {
                throw new SAMLParseException("Content of SimpleScopedString attriute value is invalid");
            }
            int sep = content.lastIndexOf("@");
            scope = sep + 2 < content.length() ? content.substring(sep + 1) : null;
            String v = content.substring(0, sep);
            if (!v.equals("")) {
                values.add(v);
            }
        } else {
            throw new UnsupportedSAMLException("Unknown type of attribute value received for UVOSSAMLProfile, likely it's a BUG, value " + value.xmlText());
        }
        return new Attribute(at, values, scope);
    }
}

