/*
 * Decompiled with CFR 0.152.
 */
package pl.edu.icm.unicore.uvos.idhelpers;

import eu.emi.security.authn.x509.impl.X500NameUtils;
import java.util.ArrayList;
import java.util.List;
import javax.naming.InvalidNameException;
import pl.edu.icm.unicore.uvos.api.Attribute;
import pl.edu.icm.unicore.uvos.api.Identity;
import pl.edu.icm.unicore.uvos.api.exceptions.InvalidValueException;
import pl.edu.icm.unicore.uvos.idhelpers.GenericIdentityHelper;

public class DNIdentityHelper
extends GenericIdentityHelper {
    public DNIdentityHelper(Identity id) throws InvalidValueException {
        super(id);
        this.validate();
    }

    public void validate() throws InvalidValueException {
        try {
            X500NameUtils.getX500Principal((String)this.identity.getValue());
        }
        catch (Exception e) {
            throw new InvalidValueException("DN is invalid: " + e.getMessage());
        }
    }

    @Override
    public String getComparableValue() {
        String raw = this.identity.getValue();
        return X500NameUtils.getComparableForm((String)raw);
    }

    @Override
    public String toPrettyString() {
        return "[X.500 DN] " + this.toPrettyStringNoPrefix();
    }

    @Override
    public String toPrettyStringNoPrefix() {
        return X500NameUtils.getReadableForm((String)this.identity.getValue());
    }

    @Override
    public List<Attribute> generateAttributes() {
        try {
            return this.generateAttributesFromDN(this.identity.getValue());
        }
        catch (InvalidNameException e) {
            return new ArrayList<Attribute>();
        }
    }
}

