/*
 * Decompiled with CFR 0.152.
 */
package pl.edu.icm.unicore.uvos.api;

import java.io.Serializable;

public class Permissions
implements Serializable {
    private static final long serialVersionUID = -570023381811413884L;
    public static final int READ = 1;
    public static final int FULL_READ = 2;
    public static final int IDENTITY_CTL = 4;
    public static final int WRITE = 8;
    public static final Permissions READ_P = new Permissions(1);
    public static final Permissions FULL_READ_P = new Permissions(2);
    public static final Permissions IDENTITY_CTL_P = new Permissions(4);
    public static final Permissions WRITE_P = new Permissions(8);
    public static final Permissions ALL_P = new Permissions(15);
    private boolean read;
    private boolean fullRead;
    private boolean identityCtl;
    private boolean write;
    private int value;

    public Permissions(boolean read, boolean fullRead, boolean identityCtl, boolean write) {
        this.read = read;
        this.identityCtl = identityCtl;
        this.fullRead = fullRead;
        this.write = write;
        this.value = 0;
        if (read) {
            ++this.value;
        }
        if (fullRead) {
            this.value += 2;
        }
        if (identityCtl) {
            this.value += 4;
        }
        if (write) {
            this.value += 8;
        }
    }

    public Permissions(int perms) {
        this.setValue(perms);
    }

    public int getValue() {
        return this.value;
    }

    public void setValue(int perms) {
        this.read = (perms & 1) != 0;
        this.fullRead = (perms & 2) != 0;
        this.identityCtl = (perms & 4) != 0;
        this.write = (perms & 8) != 0;
        this.value = perms;
    }

    public boolean isFullRead() {
        return this.fullRead;
    }

    public void setFullRead(boolean fullRead) {
        this.fullRead = fullRead;
        this.value = fullRead ? (this.value |= 2) : (this.value &= 0xFFFFFFFD);
    }

    public boolean isRead() {
        return this.read;
    }

    public void setRead(boolean read) {
        this.read = read;
        this.value = read ? (this.value |= 1) : (this.value &= 0xFFFFFFFE);
    }

    public boolean isIdentityCtl() {
        return this.identityCtl;
    }

    public void setIdentityCtl(boolean identityCtl) {
        this.identityCtl = identityCtl;
        this.value = identityCtl ? (this.value |= 4) : (this.value &= 0xFFFFFFFB);
    }

    public boolean isWrite() {
        return this.write;
    }

    public void setWrite(boolean write) {
        this.write = write;
        this.value = write ? (this.value |= 8) : (this.value &= 0xFFFFFFF7);
    }

    public String toString() {
        char[] val = new char[]{'-', '-', '-', '-'};
        if (this.read) {
            val[0] = 114;
        }
        if (this.fullRead) {
            val[1] = 102;
        }
        if (this.identityCtl) {
            val[2] = 105;
        }
        if (this.write) {
            val[3] = 119;
        }
        return new String(val) + "(" + this.value + ")";
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.value;
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Permissions other = (Permissions)obj;
        return this.value == other.value;
    }
}

