/*
 * Decompiled with CFR 0.152.
 */
package eu.unicore.security.xfireutil.client;

import eu.emi.security.authn.x509.impl.X500NameUtils;
import eu.unicore.samly2.elements.SAMLAttribute;
import eu.unicore.security.UnicoreSecurityFactory;
import eu.unicore.security.dsig.DSigException;
import eu.unicore.security.etd.DelegationRestrictions;
import eu.unicore.security.etd.ETDApi;
import eu.unicore.security.etd.InconsistentTDChainException;
import eu.unicore.security.etd.TrustDelegation;
import eu.unicore.security.user.UserAssertion;
import eu.unicore.security.xfireutil.client.TDOutHandler;
import eu.unicore.util.Log;
import eu.unicore.util.httpclient.ETDClientSettings;
import eu.unicore.util.httpclient.IClientConfiguration;
import java.security.PrivateKey;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.List;
import java.util.Map;
import javax.security.auth.x500.X500Principal;
import org.apache.log4j.Logger;

public class ExtendedTDOutHandler
extends TDOutHandler {
    private static final Logger logger = Log.getLogger((String)"unicore.security", ExtendedTDOutHandler.class);
    private List<TrustDelegation> assertionList = null;
    private UserAssertion userAssertion = null;

    public ExtendedTDOutHandler(IClientConfiguration config) {
        ETDClientSettings sec = config.getETDSettings();
        X509Certificate[] issuer = sec.getIssuerCertificateChain();
        if (issuer == null || issuer.length == 0) {
            logger.debug((Object)"No issuer was set, won't add any ETD/User assertion");
            return;
        }
        String issuerDN = issuer[0].getSubjectX500Principal().getName();
        List list = this.assertionList = sec.getTrustDelegationTokens() != null ? sec.getTrustDelegationTokens() : new ArrayList();
        if (sec.isExtendTrustDelegation()) {
            try {
                PrivateKey pk = config.getCredential().getKey();
                X500Principal receiver = sec.getReceiver();
                if (receiver == null) {
                    logger.debug((Object)"No receiver set, not creating TD assertion.");
                } else {
                    String receiverName = receiver.getName();
                    DelegationRestrictions restrictions = sec.getDelegationRestrictions();
                    if (sec.getRelativeDelegationValidityDays() != null) {
                        Calendar start = Calendar.getInstance();
                        start.add(10, -1);
                        Calendar end = Calendar.getInstance();
                        end.add(6, sec.getRelativeDelegationValidityDays());
                        restrictions.setNotBefore(start.getTime());
                        restrictions.setNotOnOrAfter(end.getTime());
                    }
                    if (this.assertionList.size() == 0) {
                        this.assertionList.add(this.createAssertion(issuer, pk, receiverName, restrictions));
                    } else {
                        this.assertionList = this.extendAssertion(this.assertionList, issuer, pk, receiverName, restrictions);
                    }
                    if (logger.isDebugEnabled()) {
                        logger.debug((Object)("Initialised trust delegation to receiver <" + X500NameUtils.getReadableForm((String)receiverName) + ">"));
                    }
                }
            }
            catch (Exception je) {
                logger.fatal((Object)"Can't create TD assertion.", (Throwable)je);
            }
        }
        logger.debug((Object)("Initialised TD Outhandler, TD chain length = " + this.assertionList.size()));
        String requestedUser = sec.getRequestedUser();
        if (requestedUser == null) {
            requestedUser = this.assertionList.size() > 0 ? this.assertionList.get(0).getIssuerFromSignature()[0].getSubjectX500Principal().getName() : issuerDN;
        }
        if (this.needCustomUserAssertion(sec)) {
            this.userAssertion = super.createUserAssertion(null, requestedUser, issuerDN);
            for (Map.Entry e : sec.getRequestedUserAttributes2().entrySet()) {
                SAMLAttribute at = new SAMLAttribute((String)e.getKey(), "urn:unicore:subject-requested-attribute");
                for (String val : (String[])e.getValue()) {
                    at.addStringAttributeValue(val);
                }
                this.userAssertion.addAttribute(at);
            }
            super.init(this.assertionList, this.userAssertion);
        } else {
            X509Certificate[] userCert = null;
            if (this.assertionList.size() > 0) {
                userCert = this.assertionList.get(0).getIssuerFromSignature();
            }
            super.init(this.assertionList, userCert, null, issuerDN);
        }
    }

    private boolean needCustomUserAssertion(ETDClientSettings sec) {
        return sec != null && (sec.getRequestedUserAttributes2().size() > 0 || sec.getRequestedUser() != null);
    }

    protected synchronized TrustDelegation createAssertion(X509Certificate[] issuer, PrivateKey pk, String receiver, DelegationRestrictions restrictions) {
        ETDApi engine = UnicoreSecurityFactory.getETDEngine();
        try {
            return engine.generateTD(issuer[0].getSubjectX500Principal().getName(), issuer, pk, receiver, restrictions);
        }
        catch (DSigException e) {
            logger.fatal((Object)"Can't sign TD assertion.", (Throwable)e);
            return null;
        }
    }

    protected synchronized List<TrustDelegation> extendAssertion(List<TrustDelegation> tdList, X509Certificate[] issuer, PrivateKey pk, String receiver, DelegationRestrictions restrictions) {
        int l = tdList.size();
        String lastReceiver = tdList.get(l - 1).getSubjectDN();
        if (receiver.equals(lastReceiver)) {
            logger.debug((Object)("TD chain already includes receiver <" + receiver + ">"));
            return tdList;
        }
        logger.debug((Object)("Extending TD chain to receiver <" + receiver + ">"));
        ETDApi engine = UnicoreSecurityFactory.getETDEngine();
        try {
            return engine.issueChainedTD(tdList, issuer, pk, receiver, restrictions);
        }
        catch (DSigException e) {
            logger.fatal((Object)"Can't sign TD assertion.", (Throwable)e);
            return null;
        }
        catch (InconsistentTDChainException tde) {
            logger.fatal((Object)"TD chain is inconsistent", (Throwable)tde);
            return null;
        }
    }

    public List<TrustDelegation> getAssertionList() {
        return this.assertionList;
    }

    public UserAssertion getUserAssertion() {
        return this.userAssertion;
    }
}

