/*
 * Decompiled with CFR 0.152.
 */
package eu.unicore.security.xfireutil.client;

import eu.emi.security.authn.x509.X509Credential;
import eu.unicore.security.xfireutil.DSigDecider;
import eu.unicore.security.xfireutil.client.TDOutHandler;
import eu.unicore.security.xfireutil.client.ToBeSignedDecider;
import eu.unicore.security.xfireutil.client.WSS4JCryptoImpl;
import eu.unicore.util.Log;
import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.util.Collections;
import java.util.List;
import java.util.Vector;
import javax.xml.namespace.QName;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.stream.XMLStreamWriter;
import javax.xml.transform.TransformerException;
import org.apache.log4j.Logger;
import org.apache.ws.security.WSEncryptionPart;
import org.apache.ws.security.WSSConfig;
import org.apache.ws.security.WSSecurityException;
import org.apache.ws.security.components.crypto.Crypto;
import org.apache.ws.security.message.WSSecHeader;
import org.apache.ws.security.message.WSSecSignature;
import org.codehaus.xfire.MessageContext;
import org.codehaus.xfire.addressing.AddressingOutHandler;
import org.codehaus.xfire.exchange.MessageSerializer;
import org.codehaus.xfire.exchange.OutMessage;
import org.codehaus.xfire.handler.AbstractHandler;
import org.codehaus.xfire.soap.handler.FaultSoapSerializerHandler;
import org.codehaus.xfire.soap.handler.SoapSerializerHandler;
import org.codehaus.xfire.util.DOMUtils;
import org.codehaus.xfire.util.dom.DOMSerializer;
import org.codehaus.xfire.util.stax.W3CDOMStreamWriter;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class DSigOutHandler
extends AbstractHandler {
    static final Logger logger = Log.getLogger((String)"unicore.security.dsig", DSigOutHandler.class);
    private static final String WSS_NS_STRING = "http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-secext-1.0.xsd";
    public static final QName WS_SECURITY = new QName("http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-secext-1.0.xsd", "Security");
    private DocumentBuilder docBuilder;
    private Crypto merlin;
    private DSigDecider decider;
    private X509Credential credential;
    private ToBeSignedDecider partsDecider;
    private boolean disabled = false;

    public DSigOutHandler(X509Credential credential, DSigDecider decider) {
        this.setPhase("post-invoke");
        this.after(TDOutHandler.class.getName());
        this.after(SoapSerializerHandler.class.getName());
        this.after(AddressingOutHandler.class.getName());
        this.before(FaultSoapSerializerHandler.class.getName());
        this.reinit(credential, decider, null);
    }

    public DSigOutHandler(X509Credential credential, DSigDecider decider, ToBeSignedDecider partsDecider) {
        this.setPhase("post-invoke");
        this.after(TDOutHandler.class.getName());
        this.after(SoapSerializerHandler.class.getName());
        this.after(AddressingOutHandler.class.getName());
        this.before(FaultSoapSerializerHandler.class.getName());
        this.reinit(credential, decider, partsDecider);
    }

    protected void reinit(X509Credential credential, DSigDecider decider, ToBeSignedDecider partsDecider) {
        if (credential == null) {
            throw new IllegalArgumentException("Credential can not be null when signatures handler is enabled.");
        }
        this.decider = decider;
        this.partsDecider = partsDecider;
        this.credential = credential;
        try {
            DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
            dbf.setNamespaceAware(true);
            this.docBuilder = dbf.newDocumentBuilder();
            this.merlin = new WSS4JCryptoImpl(credential);
        }
        catch (Exception e) {
            logger.fatal((Object)"Could not set up digital signature out handler.", (Throwable)e);
        }
    }

    public void invoke(MessageContext context) {
        Document docToSign;
        if (this.disabled || this.decider != null && !this.decider.isMessageDSigCandidate(context)) {
            return;
        }
        long start = System.currentTimeMillis();
        OutMessage message = (OutMessage)context.getCurrentMessage();
        if (message == null) {
            return;
        }
        try {
            W3CDOMStreamWriter writer = new W3CDOMStreamWriter(this.docBuilder);
            context.setProperty("xfire.serializeProlog", (Object)Boolean.TRUE);
            message.getSerializer().writeMessage(message, (XMLStreamWriter)writer, context);
            docToSign = writer.getDocument();
        }
        catch (Exception e) {
            logger.fatal((Object)"IO exception while building DOM of SOAP envelope before signing: ", (Throwable)e);
            return;
        }
        if (logger.isTraceEnabled()) {
            try {
                ByteArrayOutputStream bos = new ByteArrayOutputStream();
                DOMUtils.writeXml((Node)docToSign.getDocumentElement(), (OutputStream)bos);
                logger.trace((Object)("Message before signing:\n" + bos.toString()));
            }
            catch (TransformerException e) {
                logger.fatal((Object)"", (Throwable)e);
            }
        }
        MyWSSecSignature signatory = new MyWSSecSignature();
        WSSConfig config = WSSConfig.getNewInstance();
        config.setWsiBSPCompliant(true);
        signatory.setWsConfig(config);
        Vector<WSEncryptionPart> toBeSigned = this.getElementsToBeSigned(docToSign);
        WSSecHeader secHeader = new WSSecHeader();
        try {
            secHeader.insertSecurityHeader(docToSign);
            signatory.setUserInfo(this.credential.getKeyAlias(), new String(this.credential.getKeyPassword()));
            signatory.prepare(docToSign, this.merlin, secHeader);
            List references = signatory.addReferencesToSign(toBeSigned, secHeader);
            signatory.computeSignature(references);
        }
        catch (WSSecurityException e) {
            logger.fatal((Object)"Problem while signing SOAP message: ", (Throwable)e);
            return;
        }
        long end = System.currentTimeMillis();
        logger.debug((Object)("Signed outgoing message, processing time: " + (end - start)));
        if (logger.isTraceEnabled()) {
            try {
                ByteArrayOutputStream bos = new ByteArrayOutputStream();
                DOMUtils.writeXml((Node)docToSign.getDocumentElement(), (OutputStream)bos);
                logger.trace((Object)("Signed message:\n" + bos.toString()));
            }
            catch (TransformerException e) {
                logger.fatal((Object)"", (Throwable)e);
            }
        }
        message.setProperty((Object)"dom.message", (Object)docToSign);
        message.setSerializer((MessageSerializer)new DOMSerializer());
    }

    public QName[] getUnderstoodHeaders() {
        return new QName[]{WS_SECURITY};
    }

    private Vector<WSEncryptionPart> getElementsToBeSigned(Document docToSign) {
        if (this.partsDecider != null) {
            return this.partsDecider.getElementsToBeSigned(docToSign);
        }
        Vector<WSEncryptionPart> toBeSigned = new Vector<WSEncryptionPart>();
        toBeSigned.add(new WSEncryptionPart("Body", "http://schemas.xmlsoap.org/soap/envelope/", ""));
        return toBeSigned;
    }

    private static class MyWSSecSignature
    extends WSSecSignature {
        private MyWSSecSignature() {
        }

        public List<String> getInclusivePrefixes(Element target, boolean excludeVisible) {
            if (target.getLocalName().equals("Security")) {
                String ns = target.getNamespaceURI();
                if (ns == null) {
                    return super.getInclusivePrefixes(target, excludeVisible);
                }
                if (target.getNamespaceURI().equals(DSigOutHandler.WSS_NS_STRING)) {
                    NodeList nl = target.getElementsByTagName("SignedInfo");
                    if (nl.getLength() == 0) {
                        return Collections.emptyList();
                    }
                    return super.getInclusivePrefixes((Element)nl.item(0), excludeVisible);
                }
            }
            return super.getInclusivePrefixes(target, excludeVisible);
        }
    }
}

