/*
 * Decompiled with CFR 0.152.
 */
package eu.unicore.security.xfireutil;

import eu.unicore.util.Log;
import java.util.List;
import org.apache.log4j.Logger;
import org.jdom.Attribute;
import org.jdom.Content;
import org.jdom.Element;
import org.jdom.Namespace;

public class WSSecHeader {
    private static final Logger log = Log.getLogger((String)"unicore.security", WSSecHeader.class);
    public static final String SOAP11_URI = "http://schemas.xmlsoap.org/soap/envelope/";
    public static final Namespace SOAP11_NS = Namespace.getNamespace((String)"http://schemas.xmlsoap.org/soap/envelope/");
    public static final String WSSE_NS_URI = "http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-secext-1.0.xsd";
    public static final Namespace WSSE_NS = Namespace.getNamespace((String)"http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-secext-1.0.xsd");
    public static final String WSSE_LN = "Security";
    public static final String WSSE_PREFIX = "wsse";
    public static final String ATTR_ACTOR = "actor";
    public static final String ATTR_UNDERSTAND = "mustUnderstand";
    private String actor;
    private boolean mustUnderstand;

    public WSSecHeader(boolean mustUnderstand) {
        this.actor = null;
        this.mustUnderstand = mustUnderstand;
    }

    public WSSecHeader(String actor, boolean mustUnderstand) {
        this.actor = actor;
        this.mustUnderstand = mustUnderstand;
    }

    public Element getOrInsertWSSecElement(Element header) throws Exception {
        if (!this.isSOAP11(header)) {
            throw new Exception("Unsupported SOAP version");
        }
        Element ret = this.findWSSecElement(header);
        if (ret != null) {
            log.debug((Object)"Found existing WSSec header element");
            return ret;
        }
        ret = this.createWSSecElement(header);
        return ret;
    }

    private Element createWSSecElement(Element header) {
        Element newWsSec = new Element(WSSE_LN, WSSE_PREFIX, WSSE_NS_URI);
        Namespace ns = Namespace.getNamespace((String)"soap", (String)SOAP11_URI);
        if (this.actor != null) {
            newWsSec.setAttribute(ATTR_ACTOR, this.actor, ns);
        }
        newWsSec.setAttribute(ATTR_UNDERSTAND, this.mustUnderstand ? "1" : "0", ns);
        header.addContent(0, (Content)newWsSec);
        return newWsSec;
    }

    public Element findWSSecElement(Element header) {
        List wsseEls = header.getChildren(WSSE_LN, WSSE_NS);
        for (Object o : wsseEls) {
            Element e = (Element)o;
            Attribute a = e.getAttribute(ATTR_ACTOR, SOAP11_NS);
            if (a == null && this.actor == null) {
                return e;
            }
            if (this.actor == null || a == null || !this.actor.equals(a.getValue())) continue;
            return e;
        }
        return null;
    }

    private boolean isSOAP11(Element header) {
        String ns = header.getNamespaceURI();
        if (ns == null) {
            log.debug((Object)"SOAP Header has no namespace set??");
            return false;
        }
        return ns.equals(SOAP11_URI);
    }
}

