/*
 * Decompiled with CFR 0.152.
 */
package eu.unicore.security.xfireutil;

import eu.emi.security.authn.x509.impl.CertificateUtils;
import eu.emi.security.authn.x509.impl.FormatMode;
import eu.emi.security.authn.x509.impl.X500NameUtils;
import eu.unicore.security.HTTPAuthNTokens;
import eu.unicore.security.SecurityTokens;
import eu.unicore.security.UnicoreSecurityFactory;
import eu.unicore.security.UserAttributeHandler;
import eu.unicore.security.ValidationResult;
import eu.unicore.security.consignor.ConsignorAPI;
import eu.unicore.security.consignor.ConsignorAssertion;
import eu.unicore.security.user.UserAssertion;
import eu.unicore.security.xfireutil.WSSecHeader;
import eu.unicore.util.Log;
import java.io.IOException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.List;
import javax.security.auth.x500.X500Principal;
import javax.servlet.http.HttpServletRequest;
import javax.xml.namespace.QName;
import org.apache.log4j.Logger;
import org.apache.xmlbeans.XmlObject;
import org.codehaus.xfire.MessageContext;
import org.codehaus.xfire.addressing.AddressingHeaders;
import org.codehaus.xfire.addressing.AddressingInHandler;
import org.codehaus.xfire.handler.AbstractHandler;
import org.codehaus.xfire.transport.http.XFireServletController;
import org.codehaus.xfire.util.Base64;
import org.jdom.Attribute;
import org.jdom.Element;
import org.jdom.Namespace;
import org.jdom.output.Format;
import org.jdom.output.XMLOutputter;
import xmlbeans.org.oasis.saml2.assertion.AssertionDocument;
import xmlbeans.org.oasis.saml2.assertion.AttributeStatementType;
import xmlbeans.org.oasis.saml2.assertion.AttributeType;
import xmlbeans.org.oasis.saml2.assertion.AuthnStatementType;
import xmlbeans.org.oasis.saml2.assertion.SubjectLocalityType;

public class AuthInHandler
extends AbstractHandler {
    protected static final Logger logger = Log.getLogger((String)"unicore.security", AuthInHandler.class);
    public static final Namespace SAML2_NS = Namespace.getNamespace((String)"urn:oasis:names:tc:SAML:2.0:assertion");
    public static final String RAW_SAML_ASSERTIONS_KEY = AuthInHandler.class.getName() + ".RAW_SAML_ASSERTIONS";
    private boolean useGatewayAssertions;
    private boolean useHTTPBasic;
    private boolean useSSLData;
    private X509Certificate gatewayC;
    private boolean verifyConsignor;
    private String actor;
    private List<UserAttributeHandler> userAttributeHandlers = new ArrayList<UserAttributeHandler>();

    public AuthInHandler(boolean useGatewayAssertions, boolean useSSLData, boolean extractHTTPData, X509Certificate gatewayC) {
        this(useGatewayAssertions, useSSLData, extractHTTPData, gatewayC, null);
    }

    public AuthInHandler(boolean useGatewayAssertions, boolean useSSLData, boolean extractHTTPData, X509Certificate gatewayC, String actor) {
        this.setPhase("policy");
        this.after(AddressingInHandler.class.getName());
        this.useGatewayAssertions = useGatewayAssertions;
        this.useHTTPBasic = extractHTTPData;
        this.useSSLData = useSSLData;
        this.verifyConsignor = false;
        if (gatewayC != null && useGatewayAssertions) {
            this.gatewayC = gatewayC;
            this.verifyConsignor = true;
        }
        this.actor = actor;
    }

    public void addUserAttributeHandler(UserAttributeHandler uh) {
        this.userAttributeHandlers.add(uh);
    }

    public QName[] getUnderstoodHeaders() {
        return new QName[]{new QName("http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-secext-1.0.xsd", "Security")};
    }

    public void invoke(MessageContext ctx) throws Exception {
        HTTPAuthNTokens fromHttp;
        SecurityTokens mainToken = new SecurityTokens();
        if (this.useHTTPBasic && (fromHttp = this.getHTTPCredentials()) != null) {
            mainToken.getContext().put(SecurityTokens.CTX_LOGIN_HTTP, fromHttp);
        }
        Element header = ctx.getInMessage().getHeader();
        ConsignorAssertion cAssertion = null;
        Element uAssertion = null;
        if (header != null) {
            List<?> assertions = this.extractSAMLAssertions(header);
            if (this.useGatewayAssertions) {
                cAssertion = this.getConsignorAssertion(assertions);
            }
            uAssertion = this.getUserAssertion(assertions);
            mainToken.getContext().put(RAW_SAML_ASSERTIONS_KEY, assertions);
        }
        this.processConsignor(cAssertion, mainToken);
        if (uAssertion != null) {
            this.processUser(uAssertion, mainToken);
        }
        mainToken.getContext().put(SecurityTokens.CTX_SCOPE_KEY, "request");
        mainToken.getContext().put("REQUEST.soapAction", this.getSOAPAction(ctx));
        ctx.setProperty(SecurityTokens.KEY, (Object)mainToken);
    }

    protected List<?> extractSAMLAssertions(Element header) {
        ArrayList ret = new ArrayList();
        if (header == null) {
            logger.debug((Object)"No SOAP header");
            return ret;
        }
        Element wsSecEl = null;
        if (this.actor != null) {
            WSSecHeader utilActor = new WSSecHeader(this.actor, true);
            wsSecEl = utilActor.findWSSecElement(header);
        }
        if (wsSecEl == null) {
            WSSecHeader utilNoActor = new WSSecHeader(true);
            wsSecEl = utilNoActor.findWSSecElement(header);
        }
        ArrayList assertions = new ArrayList();
        List directAssertions = header.getChildren("Assertion", SAML2_NS);
        assertions.addAll(directAssertions);
        if (wsSecEl != null) {
            assertions.addAll(wsSecEl.getChildren("Assertion", SAML2_NS));
            if (assertions.size() == 0) {
                logger.debug((Object)"No assertion found in the wssec:Security element");
            }
        } else {
            logger.debug((Object)"No valid WS Security element found in SOAP header");
        }
        return assertions;
    }

    protected void processUser(Element uAssertion, SecurityTokens mainToken) throws IOException {
        logger.debug((Object)"Found user assertion in request");
        UserAssertion userA = this.processUserAssertion(uAssertion);
        X509Certificate[] user = this.extractCertPath(userA);
        if (user == null) {
            X500Principal userP = this.extractDN(userA);
            mainToken.setUserName(userP);
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Requested USER (retrived as a DN): " + X500NameUtils.getReadableForm((String)userP.getName())));
            }
        } else {
            mainToken.setUser(user);
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Requested USER (retrieved as a full certificate): " + CertificateUtils.format((X509Certificate)user[0], (FormatMode)FormatMode.COMPACT_ONE_LINE)));
            }
        }
        if (userA.getAttributes() != null && this.userAttributeHandlers.size() > 0) {
            for (AttributeStatementType attrStatement : userA.getAttributes()) {
                for (AttributeType attr : attrStatement.getAttributeArray()) {
                    String nameFormat = attr.getNameFormat();
                    if ("urn:unicore:subject-role".equals(nameFormat)) continue;
                    String name = attr.getName();
                    XmlObject[] values = attr.getAttributeValueArray();
                    for (UserAttributeHandler h : this.userAttributeHandlers) {
                        h.processUserDefinedAttribute(name, nameFormat, values, mainToken);
                    }
                }
            }
        }
    }

    protected void processConsignor(ConsignorAssertion cAssertion, SecurityTokens mainToken) {
        if (cAssertion == null && this.useGatewayAssertions) {
            logger.debug((Object)"No consignor info in request -> request didn't come through a gateway");
        }
        X509Certificate[] consignor = null;
        String clientIP = null;
        if (cAssertion != null && this.useGatewayAssertions && (consignor = this.processConsignorAssertion(cAssertion)) != null) {
            logger.debug((Object)"Using consignor info from Gateway.");
            clientIP = this.extractIPFromConsignorAssertion(cAssertion);
        }
        if (cAssertion == null && this.useSSLData) {
            consignor = this.getSSLCertPath();
            clientIP = this.getClientIP();
            if (consignor != null) {
                logger.debug((Object)"Using consignor info from SSL connection.");
            }
        }
        if (logger.isDebugEnabled() && consignor != null) {
            logger.debug((Object)("Consignor: " + X500NameUtils.getReadableForm((X500Principal)consignor[0].getSubjectX500Principal())));
        }
        if (consignor == null) {
            logger.debug((Object)"No valid Consignor info received, request is not authenticated.");
        } else {
            mainToken.setConsignor(consignor);
        }
        if (clientIP != null) {
            mainToken.setClientIP(clientIP);
        }
    }

    protected X509Certificate[] getSSLCertPath() {
        HttpServletRequest request = XFireServletController.getRequest();
        if (request == null) {
            return null;
        }
        X509Certificate[] certs = (X509Certificate[])request.getAttribute("javax.servlet.request.X509Certificate");
        return certs;
    }

    protected String getClientIP() {
        HttpServletRequest request = XFireServletController.getRequest();
        if (request == null) {
            return null;
        }
        return request.getRemoteAddr();
    }

    protected String extractIPFromConsignorAssertion(ConsignorAssertion cAssertion) {
        AuthnStatementType[] authNs = cAssertion.getAuthStatements();
        if (authNs == null || authNs.length == 0) {
            return null;
        }
        SubjectLocalityType loc = authNs[0].getSubjectLocality();
        if (loc == null) {
            return null;
        }
        return loc.getAddress();
    }

    protected String getSOAPAction(MessageContext ctx) {
        AddressingHeaders wsa;
        String action = (String)ctx.getInMessage().getProperty((Object)"SOAPAction");
        if (action != null && action.equals("")) {
            action = null;
        }
        if (action == null && (wsa = (AddressingHeaders)ctx.getInMessage().getProperty(AddressingInHandler.ADRESSING_HEADERS)) != null) {
            action = wsa.getAction();
        }
        if (action != null) {
            logger.debug((Object)("Setting SOAP action to '" + action + "'"));
        }
        return action;
    }

    protected HTTPAuthNTokens getHTTPCredentials() {
        HttpServletRequest req = XFireServletController.getRequest();
        if (req == null) {
            return null;
        }
        String aa = req.getHeader("Authorization");
        if (aa == null) {
            return null;
        }
        if (aa.length() < 7) {
            logger.warn((Object)("Ignoring too short Authorization header element in HTTP request: " + aa));
            return null;
        }
        String encoded = aa.substring(6);
        String decoded = new String(Base64.decode((String)encoded));
        String[] split = decoded.split(":");
        if (split.length > 2) {
            logger.warn((Object)("Ignoring malformed Authorization HTTP header element (to many ':' after decode: " + decoded + ")"));
            return null;
        }
        if (split.length == 2) {
            return new HTTPAuthNTokens(split[0], split[1]);
        }
        if (split.length == 1) {
            return new HTTPAuthNTokens(split[0], null);
        }
        logger.warn((Object)"Ignoring malformed Authorization HTTP header element (empty string after decode)");
        return null;
    }

    protected Element getUserAssertion(List<?> assertions) {
        for (int i = assertions.size() - 1; i >= 0; --i) {
            Element a = (Element)assertions.get(i);
            Element as = a.getChild("AttributeStatement", SAML2_NS);
            if (as == null) continue;
            List attrs = as.getChildren("Attribute", SAML2_NS);
            for (Object obj2 : attrs) {
                Element attr = (Element)obj2;
                Attribute a1 = attr.getAttribute("Name");
                Attribute a2 = attr.getAttribute("NameFormat");
                if (a1 == null || a2 == null || !a1.getValue().equals("USER") || !a2.getValue().equals("urn:unicore:subject-role")) continue;
                assertions.remove(i);
                return a;
            }
        }
        return null;
    }

    protected ConsignorAssertion getConsignorAssertion(List<?> assertions) {
        if (assertions.size() == 0) {
            return null;
        }
        XMLOutputter outputter = new XMLOutputter(Format.getRawFormat());
        try {
            AssertionDocument aDoc = AssertionDocument.Factory.parse((String)outputter.outputString((Element)assertions.get(0)));
            ConsignorAssertion ca = new ConsignorAssertion(aDoc);
            assertions.remove(0);
            return ca;
        }
        catch (Exception e) {
            logger.debug((Object)("The first assertion is not a valid CONSIGNOR assertion, ignoring: " + e.getMessage()));
            return null;
        }
    }

    protected X509Certificate[] processConsignorAssertion(ConsignorAssertion consignorA) {
        X509Certificate[] cert = consignorA.getConsignor();
        if (this.verifyConsignor) {
            if (!consignorA.isSigned()) {
                logger.warn((Object)"Consignor assertion is unsigned. Probably gateway is not configured properly to sign consignor assertions. Either fix gateway configuration or turn off signature checking in this server's configuration");
                return null;
            }
            ConsignorAPI engine = UnicoreSecurityFactory.getConsignorAPI();
            ValidationResult res = engine.verifyConsignorToken(consignorA, this.gatewayC);
            if (!res.isValid()) {
                String subject = cert == null || cert.length == 0 ? "null" : X500NameUtils.getReadableForm((X500Principal)cert[0].getSubjectX500Principal());
                logger.warn((Object)("Consignor assertion is invalid (probably FAKED): " + res.getInvalidResaon() + ", inserted consignor was: " + subject));
                return null;
            }
            logger.debug((Object)"Successfuly verified consignor assertion.");
        }
        if (cert == null) {
            logger.debug((Object)"Anonymous CONSIGNOR");
        }
        return cert;
    }

    protected UserAssertion processUserAssertion(Element assertion) {
        XMLOutputter outputter = new XMLOutputter(Format.getRawFormat());
        try {
            AssertionDocument aDoc = AssertionDocument.Factory.parse((String)outputter.outputString(assertion));
            UserAssertion userA = new UserAssertion(aDoc);
            return userA;
        }
        catch (Exception e) {
            logger.warn((Object)("The USER assertion is invalid, ignoring: " + e.getMessage()));
            return null;
        }
    }

    protected X509Certificate[] extractCertPath(UserAssertion userA) {
        X509Certificate[] cert = userA.getSubjectFromConfirmation();
        if (cert == null) {
            logger.debug((Object)"USER retrieved, but no certificate is given.");
        }
        return cert;
    }

    protected X500Principal extractDN(UserAssertion userA) throws IOException {
        String userDN = userA.getSubjectDN();
        return X500NameUtils.getX500Principal((String)userDN);
    }
}

