/*
 * Decompiled with CFR 0.152.
 */
package eu.unicore.util.configuration;

import eu.unicore.util.configuration.ConfigurationException;
import eu.unicore.util.configuration.FilePropertiesHelper;
import eu.unicore.util.configuration.PropertiesHelper;
import java.io.File;
import java.io.IOException;

public class WrappingFilePropertiesHelper
implements Runnable {
    protected File file;
    protected long lastAccess;
    protected PropertiesHelper wrapped;

    public WrappingFilePropertiesHelper(PropertiesHelper helper, String file) throws ConfigurationException, IOException {
        this(helper, new File(file));
    }

    public WrappingFilePropertiesHelper(PropertiesHelper helper, File file) throws ConfigurationException, IOException {
        this.file = file;
        this.wrapped = helper;
        this.lastAccess = file.lastModified();
    }

    public void reload() throws IOException, ConfigurationException {
        this.wrapped.setProperties(FilePropertiesHelper.load(this.file));
    }

    public File getFile() {
        return this.file;
    }

    private boolean hasChanged() {
        return FilePropertiesHelper.hasFileChanged(this.lastAccess, this.file);
    }

    public boolean reloadIfChanged() throws IOException, ConfigurationException {
        if (this.hasChanged()) {
            this.reload();
            return true;
        }
        return false;
    }

    @Override
    public void run() {
        try {
            this.reloadIfChanged();
        }
        catch (ConfigurationException e) {
            this.wrapped.getLoger().warn((Object)("The reloaded configuration is invalid: " + e.getMessage()), (Throwable)e);
        }
        catch (IOException e) {
            this.wrapped.getLoger().warn((Object)("Can't re-read the configuration file " + this.file + ": " + e.getMessage()), (Throwable)e);
        }
    }
}

