/*
 * Decompiled with CFR 0.152.
 */
package pl.edu.icm.unicore.uvos.wsapi.xmlbeans;

import eu.unicore.samly2.exceptions.SAMLParseException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.xml.namespace.QName;
import org.apache.xmlbeans.XmlCursor;
import org.apache.xmlbeans.XmlObject;
import org.apache.xmlbeans.XmlString;
import pl.edu.icm.unicore.uvos.api.Attribute;
import pl.edu.icm.unicore.uvos.api.AttributeType;
import pl.edu.icm.unicore.uvos.wsapi.xmlbeans.SAMLAttributeProfile;
import pl.edu.icm.unicore.uvos.wsapi.xmlbeans.UnsupportedSAMLException;
import xmlbeans.pl.edu.icm.uvos.emivoprofile.Role;

public class SAMLEMIVOAttributeProfile
implements SAMLAttributeProfile {
    public static final String ROLE = "http://dci-sec.org/saml/attribute/role";
    public static final String PRIMARY_ROLE = "http://dci-sec.org/saml/attribute/role/primary";
    public static final String[] KNOWN_ATTRIBUTE_NAMES = new String[]{"http://dci-sec.org/saml/attribute/virtual-organization", "http://dci-sec.org/saml/attribute/group", "http://dci-sec.org/saml/attribute/group/primary", "http://dci-sec.org/saml/attribute/role", "http://dci-sec.org/saml/attribute/role/primary"};
    public static final String NS = "http://dci-sec.org/saml/profile/virtual-organization/1.0";
    public static final QName SCOPE_XATTR = new QName("http://dci-sec.org/saml/profile/virtual-organization/1.0", "scope");
    public static final QName ROLE_XSD_TYPE = new QName("http://dci-sec.org/saml/profile/virtual-organization/1.0", "role");

    @Override
    public int isSupported(xmlbeans.org.oasis.saml2.assertion.AttributeType xmlAttr) {
        int i;
        if (!"urn:oasis:names:tc:SAML:2.0:attrname-format:uri".equals(xmlAttr.getNameFormat())) {
            return -1;
        }
        String name = xmlAttr.getName();
        for (i = 0; i < KNOWN_ATTRIBUTE_NAMES.length && !KNOWN_ATTRIBUTE_NAMES[i].equals(name); ++i) {
        }
        if (i == KNOWN_ATTRIBUTE_NAMES.length) {
            return -1;
        }
        return 100;
    }

    @Override
    public List<Attribute> map(xmlbeans.org.oasis.saml2.assertion.AttributeType xmlAttr) throws UnsupportedSAMLException, SAMLParseException {
        XmlObject[] xmlVals;
        String name = xmlAttr.getName();
        ArrayList<Attribute> ret = new ArrayList<Attribute>();
        boolean scopeRequired = false;
        if (name.equals(ROLE) || name.equals(PRIMARY_ROLE)) {
            scopeRequired = true;
        }
        AttributeType at = new AttributeType(xmlAttr.getName());
        String shortDesc = xmlAttr.getFriendlyName();
        if (shortDesc != null) {
            at.setShortDescription(shortDesc);
        }
        if ((xmlVals = xmlAttr.getAttributeValueArray()) == null || xmlVals.length == 0) {
            ret.add(new Attribute(at, null, null));
            return ret;
        }
        HashMap<String, Integer> attrMap = new HashMap<String, Integer>();
        for (int i = 0; i < xmlVals.length; ++i) {
            Attribute tmp = this.mapAttrValue2APIAttr(at, xmlVals[i], scopeRequired);
            Integer idx = (Integer)attrMap.get(tmp.getScope());
            if (idx == null) {
                attrMap.put(tmp.getScope(), ret.size());
                ret.add(tmp);
                continue;
            }
            Attribute existingA = (Attribute)ret.get(idx);
            if (tmp.getValues().size() <= 0) continue;
            existingA.addValue(tmp.getValues().get(0));
        }
        return ret;
    }

    private Attribute mapAttrValue2APIAttr(AttributeType at, XmlObject value, boolean scopingRequired) throws SAMLParseException {
        String scope = null;
        ArrayList<String> values = new ArrayList<String>();
        if (at.getName().equals(ROLE) || at.getName().equals(PRIMARY_ROLE)) {
            return this.mapRoleAttrValue2APIAttr(at, value);
        }
        if (!(value instanceof XmlString)) {
            throw new SAMLParseException("Wrong XSD type of value of attribute " + at.getName() + " received in EMIProfile SAML attribute, should be xsd:string, value was: " + value.xmlText());
        }
        values.add(((XmlString)value).getStringValue());
        if (scopingRequired) {
            XmlCursor cur = value.newCursor();
            scope = cur.getAttributeText(SCOPE_XATTR);
            cur.dispose();
            if (scope == null) {
                throw new SAMLParseException("Value without a scope attribute received in EMIProfile SAML attribute, while the scope is required for the attribute " + at.getName() + ", value is: " + value.xmlText());
            }
        }
        return new Attribute(at, values, scope);
    }

    private Attribute mapRoleAttrValue2APIAttr(AttributeType at, XmlObject value) throws SAMLParseException {
        String scope = null;
        ArrayList<String> values = new ArrayList<String>();
        if (!(value instanceof Role)) {
            throw new SAMLParseException("Wrong XSD type of value of role attribute received in EMIProfile SAML attribute, should be " + ROLE_XSD_TYPE + ", value was" + value.xmlText());
        }
        values.add(((XmlString)value).getStringValue());
        XmlCursor cur = value.newCursor();
        scope = cur.getAttributeText(SCOPE_XATTR);
        cur.dispose();
        if (scope == null) {
            throw new SAMLParseException("Role without a scope attribute received in EMIProfile SAML attribute, while the scope is required, value is: " + value.xmlText());
        }
        return new Attribute(at, values, scope);
    }
}

