/*
 * Decompiled with CFR 0.152.
 */
package pl.edu.icm.unicore.uvos.idhelpers;

import pl.edu.icm.unicore.uvos.api.Identity;
import pl.edu.icm.unicore.uvos.api.IdentityType;
import pl.edu.icm.unicore.uvos.api.exceptions.InvalidValueException;
import pl.edu.icm.unicore.uvos.idhelpers.DNIdentityHelper;
import pl.edu.icm.unicore.uvos.idhelpers.EmailIdentityHelper;
import pl.edu.icm.unicore.uvos.idhelpers.GenericIdentityHelper;
import pl.edu.icm.unicore.uvos.idhelpers.IdentityTypeHelper;
import pl.edu.icm.unicore.uvos.idhelpers.X509IdentityHelper;

public class IdentityHelperFactory {
    public static IdentityTypeHelper getHelper(Identity id) throws InvalidValueException {
        if (id == null) {
            throw new InvalidValueException("Identity can't be null.");
        }
        IdentityType type = id.getType();
        if (type == null) {
            throw new InvalidValueException("Identity type can't be null.");
        }
        if (type.equals(IdentityType.EMAIL)) {
            return new EmailIdentityHelper(id);
        }
        if (type.equals(IdentityType.DN)) {
            return new DNIdentityHelper(id);
        }
        if (type.equals(IdentityType.X509CERT)) {
            return new X509IdentityHelper(id);
        }
        return new GenericIdentityHelper(id);
    }
}

