/*
 * Decompiled with CFR 0.152.
 */
package pl.edu.icm.unicore.uvos.api;

import java.util.Date;
import java.util.List;
import java.util.Vector;
import pl.edu.icm.unicore.uvos.api.AttributeType;
import pl.edu.icm.unicore.uvos.api.PersistentObject;

public class Attribute
extends PersistentObject {
    private static final long serialVersionUID = 7315398480527318622L;
    private AttributeType type;
    private String scope;
    private List<String> values;

    public Attribute(AttributeType type, List<String> values, String scope, Date creationTS, Date removalTS) {
        super(creationTS, removalTS);
        this.type = type;
        this.values = values;
        this.scope = scope;
        this.setScope(scope);
    }

    public Attribute(AttributeType type, List<String> values, String scope) {
        this(type, values, scope, null, null);
    }

    public Attribute(String name, List<String> values, String scope, Date creationTS, Date removalTS) {
        this(new AttributeType(name), values, scope, creationTS, removalTS);
    }

    public Attribute(String name, List<String> values, String scope) {
        this(new AttributeType(name), values, scope, null, null);
    }

    public AttributeType getType() {
        return this.type;
    }

    public String getName() {
        return this.type.getName();
    }

    public List<String> getValues() {
        return this.values;
    }

    public void setValues(List<String> values) {
        this.values = values;
    }

    public void addValue(String value) {
        if (this.values == null) {
            this.values = new Vector<String>();
        }
        this.values.add(value);
    }

    public boolean equals(Object cmpO) {
        if (!(cmpO instanceof Attribute)) {
            return false;
        }
        Attribute other = (Attribute)cmpO;
        if (!other.type.equals(this.type)) {
            return false;
        }
        if (other.scope != null ? !other.scope.equals(this.scope) : this.scope != null) {
            return false;
        }
        if (this.values != null && this.values.size() > 0) {
            if (other.values == null || this.values.size() == 0) {
                return false;
            }
            if (!this.values.containsAll(other.values)) {
                return false;
            }
            if (!other.values.containsAll(this.values)) {
                return false;
            }
        } else if (other.values != null && other.values.size() > 0) {
            return false;
        }
        return true;
    }

    public int hashCode() {
        int hashCode = 31 + (this.scope == null ? 0 : this.scope.hashCode());
        hashCode = 31 * hashCode + (this.type == null ? 0 : this.type.hashCode());
        hashCode = 31 * hashCode + (this.values == null ? 0 : ((Object)this.values).hashCode());
        return hashCode;
    }

    public String toString() {
        String scopeS = "";
        if (this.scope != null) {
            scopeS = "@" + this.scope;
        }
        String ret = this.type.toString() + scopeS + ": ";
        StringBuilder retB = new StringBuilder(ret);
        if (this.values != null) {
            for (String val : this.values) {
                retB.append(val).append(", ");
            }
            ret = retB.toString();
            if (ret.endsWith(", ")) {
                ret = ret.substring(0, ret.length() - 2);
            }
        }
        return ret;
    }

    public String getScope() {
        return this.scope;
    }

    public void setScope(String scope) {
        if (scope != null && scope.equals("")) {
            scope = null;
        }
        this.scope = scope;
    }

    public boolean equalScope(String other) {
        return Attribute.scopesEqual(other, this.scope);
    }

    public boolean equalScope(Attribute otherA) {
        if (otherA == null) {
            return false;
        }
        return this.equalScope(otherA.getScope());
    }

    public static boolean scopesEqual(String scopeA, String scopeB) {
        if (scopeA == null && scopeB == null) {
            return true;
        }
        if (scopeA == null || scopeB == null) {
            return false;
        }
        return scopeA.equals(scopeB);
    }
}

