/*
 * Decompiled with CFR 0.152.
 */
package eu.unicore.security.xfireutil.client;

import eu.emi.security.authn.x509.X509Credential;
import eu.emi.security.authn.x509.impl.X500NameUtils;
import java.io.IOException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.cert.X509Certificate;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.x500.X500Principal;
import org.apache.ws.security.WSSecurityException;
import org.apache.ws.security.components.crypto.CredentialException;
import org.apache.ws.security.components.crypto.Crypto;
import org.apache.ws.security.components.crypto.CryptoBase;
import org.apache.ws.security.components.crypto.CryptoType;
import org.bouncycastle.util.Arrays;

public class WSS4JCryptoImpl
extends CryptoBase
implements Crypto {
    private X509Credential credential;

    public WSS4JCryptoImpl(X509Credential credential) throws CredentialException, IOException {
        this.credential = credential;
    }

    private void checkCerts(X509Certificate arg) throws WSSecurityException {
        if (!Arrays.areEqual((byte[])this.credential.getCertificate().getSignature(), (byte[])arg.getSignature())) {
            throw new WSSecurityException(WSS4JCryptoImpl.class + " was asked about data of certificate " + "which is not associated with credential: " + arg.toString());
        }
    }

    public PrivateKey getPrivateKey(X509Certificate arg0, CallbackHandler arg1) throws WSSecurityException {
        this.checkCerts(arg0);
        return this.credential.getKey();
    }

    public PrivateKey getPrivateKey(String arg0, String arg1) throws WSSecurityException {
        if (!this.credential.getKeyAlias().equals(arg0)) {
            throw new WSSecurityException(WSS4JCryptoImpl.class + " was asked about private key with wrong alias: " + arg0);
        }
        return this.credential.getKey();
    }

    public X509Certificate[] getX509Certificates(CryptoType cryptoType) throws WSSecurityException {
        if (cryptoType == null) {
            return null;
        }
        CryptoType.TYPE type = cryptoType.getType();
        switch (type) {
            case ISSUER_SERIAL: {
                if (!X500NameUtils.equal((X500Principal)this.credential.getCertificate().getIssuerX500Principal(), (String)cryptoType.getIssuer())) {
                    throw new WSSecurityException(WSS4JCryptoImpl.class + " was asked about cert chain with wrong issuer: " + cryptoType.getIssuer());
                }
                if (cryptoType.getSerial().equals(this.credential.getCertificate().getSerialNumber())) break;
                throw new WSSecurityException(WSS4JCryptoImpl.class + " was asked about cert chain with wrong serial: " + cryptoType.getSerial());
            }
            case THUMBPRINT_SHA1: {
                throw new WSSecurityException(WSS4JCryptoImpl.class + " not implemented: THUMB_SHA1");
            }
            case SKI_BYTES: {
                throw new WSSecurityException(WSS4JCryptoImpl.class + " not implemented: SKI_BYTES");
            }
            case SUBJECT_DN: {
                if (X500NameUtils.equal((X500Principal)this.credential.getCertificate().getSubjectX500Principal(), (String)cryptoType.getSubjectDN())) break;
                throw new WSSecurityException(WSS4JCryptoImpl.class + " was asked about cert chain with wrong subject: " + cryptoType.getSubjectDN());
            }
            case ALIAS: {
                if (cryptoType.getAlias() == null) {
                    throw new WSSecurityException(WSS4JCryptoImpl.class + " was asked about cert chain with null alias");
                }
                if (cryptoType.getAlias().equals(this.credential.getKeyAlias())) break;
                throw new WSSecurityException(WSS4JCryptoImpl.class + " was asked about cert chain with wrong alias: " + cryptoType.getAlias());
            }
        }
        return this.credential.getCertificateChain();
    }

    public String getX509Identifier(X509Certificate arg0) throws WSSecurityException {
        this.checkCerts(arg0);
        return this.credential.getKeyAlias();
    }

    public boolean verifyTrust(X509Certificate[] arg0) throws WSSecurityException {
        throw new WSSecurityException(WSS4JCryptoImpl.class + " not implemented: verifyTrust(X509Certificate[])");
    }

    public boolean verifyTrust(PublicKey arg0) throws WSSecurityException {
        throw new WSSecurityException(WSS4JCryptoImpl.class + " not implemented: verifyTrust(PublicKey)");
    }

    public boolean verifyTrust(X509Certificate[] arg0, boolean arg1) throws WSSecurityException {
        throw new WSSecurityException(WSS4JCryptoImpl.class + " not implemented: verifyTrust(X509Certificate[], boolean)");
    }
}

