/*
 * Decompiled with CFR 0.152.
 */
package pl.edu.icm.unicore.uvos.wsclient.samlapi;

import eu.emi.security.authn.x509.X509CertChainValidator;
import eu.emi.security.authn.x509.X509Credential;
import eu.unicore.samly2.assertion.Assertion;
import eu.unicore.samly2.exceptions.SAMLParseException;
import eu.unicore.samly2.proto.AbstractStatusResponse;
import eu.unicore.samly2.proto.AssertionResponse;
import eu.unicore.util.httpclient.IClientConfiguration;
import java.net.MalformedURLException;
import java.net.URI;
import java.security.PublicKey;
import pl.edu.icm.unicore.uvos.wsapi.xmlbeans.SAMLAuthnInterface;
import pl.edu.icm.unicore.uvos.wsapi.xmlbeans.UVOSFault;
import pl.edu.icm.unicore.uvos.wsapi.xmlbeans.UnsupportedSAMLException;
import pl.edu.icm.unicore.uvos.wsclient.samlapi.InvalidSignatureException;
import pl.edu.icm.unicore.uvos.wsclient.samlapi.InvocationException;
import pl.edu.icm.unicore.uvos.wsclient.samlapi.SAMLErrorResponseException;
import pl.edu.icm.unicore.uvos.wsclient.samlapi.SAMLVOAuthnClientPOST;
import pl.edu.icm.unicore.uvos.wsclient.samlapi.SAMLVOClient;
import pl.edu.icm.unicore.uvos.wsclient.samlapi.SecuritySetupException;
import xmlbeans.org.oasis.saml2.protocol.AuthnRequestDocument;
import xmlbeans.org.oasis.saml2.protocol.ResponseDocument;

public class SAMLVOAuthnClientSOAP
extends SAMLVOClient {
    private SAMLAuthnInterface proxy;
    private SAMLVOAuthnClientPOST util;

    public SAMLVOAuthnClientSOAP(String address, IClientConfiguration secProv, URI issuer, X509CertChainValidator validator) throws SecuritySetupException, MalformedURLException {
        super(address, secProv, issuer);
        this.setDSigPolicy(true, true, secProv.getCredential(), validator);
        try {
            if (this.proxy == null) {
                this.proxy = this.fact.getSAMLAuthnClient(address);
            }
        }
        catch (MalformedURLException e) {
            // empty catch block
        }
        this.util = new SAMLVOAuthnClientPOST(secProv, issuer, issuer, validator);
    }

    @Override
    public Object getProxy() {
        return this.proxy;
    }

    @Override
    public void setDSigPolicy(boolean requireSignedReqResp, boolean requireSignedAssertion, X509Credential credential, PublicKey publicKey) {
        if (!requireSignedAssertion) {
            throw new IllegalArgumentException("For SAML authentication, the signatures of response assertions must be required");
        }
        super.setDSigPolicy(requireSignedReqResp, requireSignedAssertion, credential, publicKey);
        this.requireSignedResp = false;
    }

    @Override
    public void setDSigPolicy(boolean requireSignedReqResp, boolean requireSignedAssertion, X509Credential credential, X509CertChainValidator validator) {
        if (!requireSignedAssertion) {
            throw new IllegalArgumentException("For SAML authentication, the signatures of response assertions must be required");
        }
        super.setDSigPolicy(requireSignedReqResp, requireSignedAssertion, credential, validator);
        this.requireSignedResp = false;
    }

    public Assertion authenticate(String requestedFormat) throws SAMLParseException, UnsupportedSAMLException, InvalidSignatureException, InvocationException, SAMLErrorResponseException {
        Assertion[] assertions;
        ResponseDocument xmlRespDoc;
        AuthnRequestDocument reqDoc = this.util.createRequest(requestedFormat).getDoc();
        try {
            xmlRespDoc = this.proxy.authnRequest(reqDoc);
            this.lastResponse = xmlRespDoc;
        }
        catch (UVOSFault e) {
            throw new InvocationException(e);
        }
        AssertionResponse resp = new AssertionResponse(xmlRespDoc);
        resp.parse();
        if (!resp.isStatusOK()) {
            throw new SAMLErrorResponseException(resp.getErrorMessage(), resp.getErrorStatus(), resp.getSubErrorStatus());
        }
        this.checkResponseSignature((AbstractStatusResponse)resp);
        try {
            assertions = resp.getAssertions();
        }
        catch (Exception e) {
            throw new SAMLParseException(e.toString());
        }
        if (assertions.length == 0) {
            return null;
        }
        if (assertions.length > 1) {
            throw new UnsupportedSAMLException("More than one assertion was returned. It is OK,however this implementation supports only responses with a single assertion.");
        }
        Assertion assertion = assertions[0];
        this.checkAssertionSignature((AbstractStatusResponse)resp, assertion);
        return assertion;
    }
}

