/*
 * Decompiled with CFR 0.152.
 */
package pl.edu.icm.unicore.uvos.wsclient.samlapi;

import eu.emi.security.authn.x509.X509CertChainValidator;
import eu.emi.security.authn.x509.X509Credential;
import eu.unicore.samly2.assertion.Assertion;
import eu.unicore.samly2.elements.NameID;
import eu.unicore.samly2.exceptions.SAMLParseException;
import eu.unicore.samly2.proto.AbstractRequest;
import eu.unicore.samly2.proto.AbstractStatusResponse;
import eu.unicore.samly2.proto.AssertionResponse;
import eu.unicore.samly2.proto.AuthnRequest;
import eu.unicore.util.httpclient.IClientConfiguration;
import java.net.MalformedURLException;
import java.net.URI;
import java.security.PublicKey;
import org.apache.xmlbeans.XmlException;
import org.apache.xmlbeans.impl.util.Base64;
import pl.edu.icm.unicore.uvos.api.Identity;
import pl.edu.icm.unicore.uvos.wsapi.xmlbeans.SAMLXMLBeansMapper;
import pl.edu.icm.unicore.uvos.wsapi.xmlbeans.UnsupportedSAMLException;
import pl.edu.icm.unicore.uvos.wsclient.samlapi.AbstractSAMLBase;
import pl.edu.icm.unicore.uvos.wsclient.samlapi.InvalidSignatureException;
import pl.edu.icm.unicore.uvos.wsclient.samlapi.SAMLErrorResponseException;
import pl.edu.icm.unicore.uvos.wsclient.samlapi.SecuritySetupException;
import xmlbeans.org.oasis.saml2.assertion.AuthnStatementType;
import xmlbeans.org.oasis.saml2.assertion.NameIDType;
import xmlbeans.org.oasis.saml2.assertion.SubjectType;
import xmlbeans.org.oasis.saml2.protocol.ResponseDocument;

public class SAMLVOAuthnClientPOST
extends AbstractSAMLBase {
    private String returnURL;
    protected NameID issuer;
    private static final String formForm = "<?xml version=\"1.0\" encoding=\"UTF-8\"?><!DOCTYPE html PUBLIC \"-//W3C//DTD XHTML 1.1//EN\"http://www.w3.org/TR/xhtml11/DTD/xhtml11.dtd\"><html xmlns=\"http://www.w3.org/1999/xhtml\" xml:lang=\"en\"><body onload=\"document.forms[0].submit()\"><noscript><p><strong>Note:</strong> Since your browser does not support JavaScript,you must press the Continue button once to proceed.</p></noscript><form action=\"__ACTION__\" method=\"post\"><div><input type=\"hidden\" name=\"RelayState\" value=\"__RELAYSTATE__\"/><input type=\"hidden\" name=\"SAMLRequest\" value=\"__SAMLREQUEST__\"/></div><noscript><div><input type=\"submit\" value=\"Continue\"/></div></noscript></form></body></html>";

    public SAMLVOAuthnClientPOST(IClientConfiguration secProv, URI issuer, URI returnURL, X509CertChainValidator validator) throws SecuritySetupException, MalformedURLException {
        this.returnURL = returnURL.toString();
        if (issuer == null) {
            throw new IllegalArgumentException("No issuer was provided");
        }
        this.issuer = new NameID(issuer.toString(), "urn:oasis:names:tc:SAML:2.0:nameid-format:entity");
        this.setDSigPolicy(true, true, secProv.getCredential(), validator);
    }

    @Override
    public void setDSigPolicy(boolean requireSignedReqResp, boolean requireSignedAssertion, X509Credential credential, PublicKey publicKey) {
        if (!requireSignedAssertion) {
            throw new IllegalArgumentException("For SAML authentication, the signatures of response assertions must be required");
        }
        super.setDSigPolicy(requireSignedReqResp, requireSignedAssertion, credential, publicKey);
    }

    @Override
    public void setDSigPolicy(boolean requireSignedReqResp, boolean requireSignedAssertion, X509Credential credential, X509CertChainValidator validator) {
        if (!requireSignedAssertion) {
            throw new IllegalArgumentException("For SAML authentication, the signatures of response assertions must be required");
        }
        super.setDSigPolicy(requireSignedReqResp, requireSignedAssertion, credential, validator);
    }

    public static Identity getIdentityFromAssertion(Assertion ass) {
        AuthnStatementType[] aS = ass.getAuthStatements();
        if (aS == null || aS.length != 1) {
            throw new IllegalArgumentException("The assertion passed has zero or more then one authentication statements.");
        }
        SubjectType subject = ass.getXML().getAssertion().getSubject();
        if (subject == null) {
            throw new IllegalArgumentException("The assertion passed has no subjectset.");
        }
        if (subject.getNameID() == null) {
            throw new IllegalArgumentException("The subjeect in assertion passed has no nameID set.");
        }
        return SAMLXMLBeansMapper.map2APIIdentity((NameIDType)subject.getNameID());
    }

    public static String encodeRequest(AuthnRequest request) {
        String assertion = request.getDoc().xmlText();
        return new String(Base64.encode((byte[])assertion.getBytes()));
    }

    public static AssertionResponse decodeResponse(String response) throws SAMLParseException {
        ResponseDocument xmlRespDoc;
        String respString = new String(Base64.decode((byte[])response.getBytes()));
        try {
            xmlRespDoc = ResponseDocument.Factory.parse((String)respString);
        }
        catch (XmlException e) {
            throw new SAMLParseException(e.getMessage());
        }
        AssertionResponse resp = new AssertionResponse(xmlRespDoc);
        resp.parse();
        return resp;
    }

    public static String writeRequestForm(String identityProviderURL, AuthnRequest request, String relayState) {
        String f = formForm.replace("__ACTION__", identityProviderURL);
        f = f.replace("__RELAYSTATE__", relayState == null ? "" : relayState);
        String encodedReq = SAMLVOAuthnClientPOST.encodeRequest(request);
        f = f.replace("__SAMLREQUEST__", encodedReq);
        return f;
    }

    public AuthnRequest createRequest(String requestedFormat) throws InvalidSignatureException {
        AuthnRequest request = new AuthnRequest(this.issuer);
        if (requestedFormat != null) {
            request.setFormat(requestedFormat);
        }
        request.setConsumerURL(this.returnURL);
        this.signIfNeeded((AbstractRequest)request);
        return request;
    }

    public Assertion processAuthnResponse(AssertionResponse resp) throws SAMLErrorResponseException, SAMLParseException, UnsupportedSAMLException, InvalidSignatureException {
        Assertion[] assertions;
        if (!resp.isStatusOK()) {
            throw new SAMLErrorResponseException(resp.getErrorMessage(), resp.getErrorStatus(), resp.getSubErrorStatus());
        }
        this.checkResponseSignature((AbstractStatusResponse)resp);
        try {
            assertions = resp.getAssertions();
        }
        catch (Exception e) {
            throw new SAMLParseException(e.toString());
        }
        if (assertions.length == 0) {
            return null;
        }
        if (assertions.length > 1) {
            throw new UnsupportedSAMLException("More than one assertion was returned. It is OK,however this implementation supports only responses with a single assertion.");
        }
        Assertion assertion = assertions[0];
        this.checkAssertionSignature((AbstractStatusResponse)resp, assertion);
        return assertion;
    }

    public Assertion decodeAndProcess(String response) throws SAMLParseException, SAMLErrorResponseException, UnsupportedSAMLException, InvalidSignatureException {
        AssertionResponse resp = SAMLVOAuthnClientPOST.decodeResponse(response);
        return this.processAuthnResponse(resp);
    }
}

