/*
 * Decompiled with CFR 0.152.
 */
package pl.edu.icm.unicore.uvos.wsclient.api;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.apache.xmlbeans.XmlException;
import pl.edu.icm.unicore.uvos.api.Attribute;
import pl.edu.icm.unicore.uvos.api.AttributeType;
import pl.edu.icm.unicore.uvos.api.Element;
import pl.edu.icm.unicore.uvos.api.Group;
import pl.edu.icm.unicore.uvos.api.Identity;
import pl.edu.icm.unicore.uvos.api.IdentityType;
import pl.edu.icm.unicore.uvos.api.Notification;
import pl.edu.icm.unicore.uvos.api.exceptions.InvalidValueException;
import pl.edu.icm.unicore.uvos.api.exceptions.UVOSException;
import pl.edu.icm.unicore.uvos.wsapi.xmlbeans.UVOSFault;
import pl.edu.icm.unicore.uvos.wsapi.xmlbeans.WSManagementInterface;
import pl.edu.icm.unicore.uvos.wsapi.xmlbeans.XMLBeansMapper;
import pl.edu.icm.unicore.uvos.wsclient.api.UVOSManagementExtInterface;
import xmlbeans.pl.edu.icm.uvos.internal.AttributeXType;
import xmlbeans.pl.edu.icm.uvos.internal.GroupDocument;
import xmlbeans.pl.edu.icm.uvos.internal.NotificationListDocument;

public class WSManagementClient
implements UVOSManagementExtInterface {
    private WSManagementInterface proxy;

    public WSManagementClient(WSManagementInterface proxy) {
        this.proxy = proxy;
    }

    @Override
    public Group addGroup(Group parent, String name) throws UVOSException {
        try {
            return XMLBeansMapper.map2APIGroup((GroupDocument)this.proxy.addGroup(XMLBeansMapper.map2XMLGroupDoc((Group)parent), name));
        }
        catch (UVOSFault e) {
            throw e.getAsAPIException();
        }
    }

    @Override
    public void addIdentity(Identity toAdd) throws UVOSException {
        try {
            this.proxy.addIdentity(XMLBeansMapper.map2XMLIdentityDoc((Identity)toAdd));
        }
        catch (UVOSFault e) {
            throw e.getAsAPIException();
        }
    }

    @Override
    public void addIdentity(Identity toAdd, Identity equivalentIdentity) throws UVOSException {
        try {
            this.proxy.addIdentity(XMLBeansMapper.map2XMLIdentityDoc((Identity)toAdd), XMLBeansMapper.map2XMLIdentityDoc((Identity)equivalentIdentity));
        }
        catch (UVOSFault e) {
            throw e.getAsAPIException();
        }
    }

    @Override
    public void addToGroup(Identity toAdd, Group group) throws UVOSException {
        try {
            this.proxy.addToGroup(XMLBeansMapper.map2XMLIdentityDoc((Identity)toAdd), XMLBeansMapper.map2XMLGroupDoc((Group)group));
        }
        catch (UVOSFault e) {
            throw e.getAsAPIException();
        }
    }

    @Override
    public void disableAttribute(Element whose, String toDisable, String valueToDisable) throws UVOSException {
        try {
            this.proxy.disableAttribute(XMLBeansMapper.map2XMLElementDoc((Element)whose), toDisable.toString(), valueToDisable);
        }
        catch (UVOSFault e) {
            throw e.getAsAPIException();
        }
    }

    @Override
    public void enableAttribute(Element whose, String toEnable, String valueToEnable) throws UVOSException {
        try {
            this.proxy.enableAttribute(XMLBeansMapper.map2XMLElementDoc((Element)whose), toEnable.toString(), valueToEnable);
        }
        catch (UVOSFault e) {
            throw e.getAsAPIException();
        }
    }

    @Override
    public List<AttributeType> getAttributeTypes() throws UVOSException {
        AttributeXType[] raw;
        try {
            raw = this.proxy.getAttributeTypes().getAttributesList().getElementArray();
        }
        catch (UVOSFault e1) {
            throw e1.getAsAPIException();
        }
        ArrayList<AttributeType> ret = new ArrayList<AttributeType>();
        for (AttributeXType u : raw) {
            ret.add(new AttributeType(u.getName(), u.getShortDescription(), u.getDescription()));
        }
        return ret;
    }

    @Override
    public List<Attribute> getDisabledAttributes(Element whose) throws UVOSException {
        AttributeXType[] raw;
        try {
            raw = this.proxy.getDisabledAttributes(XMLBeansMapper.map2XMLElementDoc((Element)whose)).getAttributesList().getElementArray();
        }
        catch (UVOSFault e1) {
            throw e1.getAsAPIException();
        }
        ArrayList<Attribute> ret = new ArrayList<Attribute>();
        for (AttributeXType u : raw) {
            try {
                ret.add(XMLBeansMapper.map2APIAttribute((AttributeXType)u));
            }
            catch (XmlException e) {
                throw new InvalidValueException(e.getMessage());
            }
        }
        return ret;
    }

    @Override
    public List<IdentityType> getIdentityTypes() throws UVOSException {
        String[] raw;
        try {
            raw = this.proxy.getIdentityTypes().getNamesList().getElementArray();
        }
        catch (UVOSFault e1) {
            throw e1.getAsAPIException();
        }
        ArrayList<IdentityType> ret = new ArrayList<IdentityType>();
        for (String u : raw) {
            ret.add(new IdentityType(u));
        }
        return ret;
    }

    @Override
    public Group copyGroup(Group toCopy, Group newParent, String newName, boolean removeOriginal) throws UVOSException {
        try {
            return XMLBeansMapper.map2APIGroup((GroupDocument)this.proxy.copyGroup(XMLBeansMapper.map2XMLGroupDoc((Group)toCopy), XMLBeansMapper.map2XMLGroupDoc((Group)newParent), newName, removeOriginal));
        }
        catch (UVOSFault e) {
            throw e.getAsAPIException();
        }
    }

    @Override
    public void purgeHistoricalData(Date deleteFrom) throws UVOSException {
        try {
            this.proxy.purgeHistoricalData(XMLBeansMapper.d2c((Date)deleteFrom));
        }
        catch (UVOSFault e) {
            throw e.getAsAPIException();
        }
    }

    @Override
    public void removeAttribute(Element whom, String toRemove) throws UVOSException {
        try {
            this.proxy.removeAttribute(XMLBeansMapper.map2XMLElementDoc((Element)whom), toRemove.toString());
        }
        catch (UVOSFault e) {
            throw e.getAsAPIException();
        }
    }

    @Override
    public void removeFromGroup(Identity toRemove, Group group) throws UVOSException {
        try {
            this.proxy.removeFromGroup(XMLBeansMapper.map2XMLIdentityDoc((Identity)toRemove), XMLBeansMapper.map2XMLGroupDoc((Group)group));
        }
        catch (UVOSFault e) {
            throw e.getAsAPIException();
        }
    }

    @Override
    public void removeGroup(Group toRemove, boolean recursive) throws UVOSException {
        try {
            this.proxy.removeGroup(XMLBeansMapper.map2XMLGroupDoc((Group)toRemove), recursive);
        }
        catch (UVOSFault e) {
            throw e.getAsAPIException();
        }
    }

    @Override
    public void removeIdentity(Identity toRemove) throws UVOSException {
        try {
            this.proxy.removeIdentity(XMLBeansMapper.map2XMLIdentityDoc((Identity)toRemove));
        }
        catch (UVOSFault e) {
            throw e.getAsAPIException();
        }
    }

    @Override
    public void setAttribute(Element whom, Attribute toAdd, boolean update) throws UVOSException {
        try {
            this.proxy.setAttribute(XMLBeansMapper.map2XMLElementDoc((Element)whom), XMLBeansMapper.map2XMLAttributeDoc((Attribute)toAdd), update);
        }
        catch (UVOSFault e) {
            throw e.getAsAPIException();
        }
    }

    @Override
    public void setIdentityLabel(Identity toChange, String label) throws UVOSException {
        try {
            this.proxy.setIdentityLabel(XMLBeansMapper.map2XMLIdentityDoc((Identity)toChange), label);
        }
        catch (UVOSFault e) {
            throw e.getAsAPIException();
        }
    }

    @Override
    public void updateAttributeTypes(List<AttributeType> toUpdate, boolean clear) throws UVOSException {
        try {
            this.proxy.updateAttributeTypes(XMLBeansMapper.map2XMLAttributesListAt(toUpdate), clear);
        }
        catch (UVOSFault e) {
            throw e.getAsAPIException();
        }
    }

    @Override
    public void setIdentityStatus(Identity toChange, boolean how) throws UVOSException {
        try {
            this.proxy.setIdentityStatus(XMLBeansMapper.map2XMLIdentityDoc((Identity)toChange), how);
        }
        catch (UVOSFault e) {
            throw e.getAsAPIException();
        }
    }

    @Override
    public void addNotification(String action, String receipents, String groupFilter) throws UVOSException {
        try {
            this.proxy.addNotification(action, receipents, groupFilter);
        }
        catch (UVOSFault e) {
            throw e.getAsAPIException();
        }
    }

    @Override
    public List<Notification> getNotifications(String action, String groupFilter) throws UVOSException {
        try {
            return XMLBeansMapper.map2APINotificationList((NotificationListDocument)this.proxy.getNotifications(action, groupFilter));
        }
        catch (UVOSFault e) {
            throw e.getAsAPIException();
        }
    }

    @Override
    public void removeNotification(int id) throws UVOSException {
        try {
            this.proxy.removeNotification(id);
        }
        catch (UVOSFault e) {
            throw e.getAsAPIException();
        }
    }

    public WSManagementInterface getProxy() {
        return this.proxy;
    }
}

