/*
 * Decompiled with CFR 0.152.
 */
package pl.edu.icm.unicore.uvos.wsclient;

import eu.emi.security.authn.x509.X509CertChainValidator;
import eu.unicore.security.dsig.DigSignatureUtil;
import eu.unicore.util.configuration.FilePropertiesHelper;
import eu.unicore.util.httpclient.IClientConfiguration;
import java.util.List;
import java.util.Properties;
import org.apache.xmlbeans.XmlOptions;
import org.w3c.dom.Document;
import pl.edu.icm.unicore.uvos.api.Attribute;
import pl.edu.icm.unicore.uvos.api.Identity;
import pl.edu.icm.unicore.uvos.api.IdentityType;
import pl.edu.icm.unicore.uvos.client.util.UVOSClientProperties;
import pl.edu.icm.unicore.uvos.wsclient.samlapi.SAMLVOClient;
import pl.edu.icm.unicore.uvos.wsclient.samlapi.SAMLVOQueryClient;

public class SAMLSelfInfoClient {
    public static void main(String[] args) {
        UVOSClientProperties conf = null;
        try {
            String cf = null;
            if (args.length > 1 && args[0].equals("-c")) {
                cf = args[1];
            }
            Properties p = FilePropertiesHelper.load(cf);
            conf = new UVOSClientProperties(p);
        }
        catch (Exception e1) {
            e1.printStackTrace();
            System.exit(1);
        }
        String addr = conf.getProtocol() + "://" + conf.getServerHost() + ":" + conf.getServerPort() + conf.getServicePath();
        System.out.println("Using address: " + addr);
        SAMLSelfInfoClient.runHLATest(conf, addr);
    }

    static void runHLATest(UVOSClientProperties conf, String addr) {
        block3: {
            SAMLVOClient client = null;
            try {
                String dn = SAMLSelfInfoClient.getDN(conf);
                Identity subject = new Identity(IdentityType.DN, dn);
                System.out.println("Quering for DN: " + dn);
                client = new SAMLVOQueryClient(addr, (IClientConfiguration)conf);
                client.setDSigPolicy(false, true, conf.getCredential(), (X509CertChainValidator)conf.getValidator());
                List<Attribute> attrs = ((SAMLVOQueryClient)client).getAttributes(subject);
                for (Attribute a : attrs) {
                    System.out.println("Got attr: " + a);
                }
                Document doc = (Document)client.getLastResponse().getDomNode();
                String dump = DigSignatureUtil.dumpDOMToString((Document)doc);
                System.out.println("\n\nRESPONSE WAS (via DOM):\n " + dump + "\n\n");
                System.out.println("\n\nRESPONSE WAS:\n " + client.getLastResponse().xmlText(new XmlOptions().setSavePrettyPrint()) + "\n\n");
            }
            catch (Exception e) {
                e.printStackTrace();
                if (client == null || client.getLastResponse() == null) break block3;
                System.out.println("\nRESPONSE WAS: " + client.getLastResponse().xmlText(new XmlOptions().setSavePrettyPrint()));
            }
        }
    }

    static String getDN(UVOSClientProperties conf) throws Exception {
        return conf.getCredential().getCertificate().getSubjectX500Principal().getName("RFC2253");
    }
}

