/*
 * Decompiled with CFR 0.152.
 */
package pl.edu.icm.unicore.uvos.clc;

import pl.edu.icm.unicore.uvos.api.Identity;
import pl.edu.icm.unicore.uvos.api.exceptions.UVOSException;
import pl.edu.icm.unicore.uvos.clc.AbstractAction;
import pl.edu.icm.unicore.uvos.clc.ConnectionManager;

class SetIdentityStatusAction
extends AbstractAction {
    SetIdentityStatusAction(ConnectionManager cm) {
        super(cm, "setIdentityStatus", "Changes the given identity status to disable or enable it.\nSyntax:\n   setIdentityStatus <dn|x509|email> <identity> <true|false>\nThe last argument equal to 'true' will make the identity enabled (active) and 'false' will disable it.Example:\n   setIdentityStatus email ann@example.com false\n", 3);
    }

    @Override
    public boolean invoke(String[] args) throws UVOSException {
        Identity i = this.getIdentity(args[1], args[2], null);
        if (i == null) {
            return true;
        }
        boolean how = Boolean.parseBoolean(args[3]);
        this.cm.voMan.setIdentityStatus(i, how);
        System.out.println("Identity " + i + " is enabled: " + how);
        return true;
    }
}

