/*
 * Decompiled with CFR 0.152.
 */
package pl.edu.icm.unicore.uvos.clc;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import pl.edu.icm.unicore.uvos.api.exceptions.UVOSException;
import pl.edu.icm.unicore.uvos.clc.AbstractAction;
import pl.edu.icm.unicore.uvos.clc.ConnectionManager;

class PurgeAction
extends AbstractAction {
    PurgeAction(ConnectionManager cm) {
        super(cm, "purgeHistory", "Deletes all historical content of database which is older then requested. Syntax:\n  purgeHistory <yyyy-mm-dd> <hh:mm:ss>\n\nExample:\n  purgeHistory 2007-03-28 21:49:00\n", 2);
    }

    @Override
    public boolean invoke(String[] args) throws UVOSException {
        Date deleteFrom = null;
        SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss");
        try {
            deleteFrom = format.parse(args[1] + "T" + args[2]);
        }
        catch (ParseException e) {
            System.out.println("Can't parse date and time: " + e.getMessage());
            return true;
        }
        this.cm.voMan.purgeHistoricalData(deleteFrom);
        System.out.println("Deleted all historical entries older then: " + format.format(deleteFrom));
        return true;
    }
}

