/*
 * Decompiled with CFR 0.152.
 */
package pl.edu.icm.unicore.uvos.clc;

import pl.edu.icm.unicore.uvos.api.ApplicationActions;
import pl.edu.icm.unicore.uvos.api.exceptions.InternalException;
import pl.edu.icm.unicore.uvos.api.exceptions.UVOSException;
import pl.edu.icm.unicore.uvos.clc.AbstractAction;
import pl.edu.icm.unicore.uvos.clc.ConnectionManager;

class ProcessApplicationAction
extends AbstractAction {
    ProcessApplicationAction(ConnectionManager cm) {
        super(cm, "processApplication", "Process an application. This method doesn't fulfill any of extra requests attached to the application.\nSyntax:\n   processApplication <appId> <action> <sendEmail:true|false> [additionalNotes]\nValid actions are REJECT, ACCEPT or REMOVE", 3);
    }

    @Override
    public boolean invoke(String[] args) throws UVOSException {
        Integer id = null;
        ApplicationActions action = null;
        boolean sendConfirm = false;
        try {
            id = Integer.parseInt(args[1]);
            action = ApplicationActions.valueOf((String)args[2]);
            sendConfirm = "true".equalsIgnoreCase(args[3]);
        }
        catch (NumberFormatException e) {
            throw new InternalException(args[1] + " is not an integer.");
        }
        catch (IllegalArgumentException e) {
            throw new InternalException(args[2] + " is invalid.");
        }
        String notes = null;
        if (args.length > 4) {
            notes = args[4];
        }
        this.cm.voApps.processApplication(id, action, notes, sendConfirm, null);
        System.out.println("VO application was processed successfuly");
        return true;
    }
}

