/*
 * Decompiled with CFR 0.152.
 */
package pl.edu.icm.unicore.uvos.clc;

import java.util.List;
import pl.edu.icm.unicore.uvos.api.ApplicationStatus;
import pl.edu.icm.unicore.uvos.api.VOApplication;
import pl.edu.icm.unicore.uvos.api.exceptions.InternalException;
import pl.edu.icm.unicore.uvos.api.exceptions.UVOSException;
import pl.edu.icm.unicore.uvos.clc.AbstractAction;
import pl.edu.icm.unicore.uvos.clc.ConnectionManager;

class ListApplicationsAction
extends AbstractAction {
    ListApplicationsAction(ConnectionManager cm) {
        super(cm, "getApplications", "Lists application actions. Arguments filter the resopnse. Negative formId means any formId.\nSyntax:\n   getApplications [formId] [status]", 0, "listApplications");
    }

    @Override
    public boolean invoke(String[] args) throws UVOSException {
        Integer formId = null;
        ApplicationStatus status = null;
        if (args.length > 1) {
            try {
                formId = Integer.parseInt(args[1]);
            }
            catch (NumberFormatException e) {
                throw new InternalException(args[1] + " is not an integer.");
            }
        }
        try {
            if (args.length > 2) {
                status = ApplicationStatus.valueOf((String)args[2]);
            }
        }
        catch (IllegalArgumentException e) {
            throw new InternalException(args[2] + " is invalid.");
        }
        List<VOApplication> appsList = this.cm.voApps.getApplications(formId, status);
        System.out.println("Received the following VO applications:");
        for (VOApplication app : appsList) {
            System.out.println(app + "\n");
        }
        return true;
    }
}

