/*
 * Decompiled with CFR 0.152.
 */
package pl.edu.icm.unicore.uvos.clc;

import java.util.List;
import pl.edu.icm.unicore.uvos.api.Group;
import pl.edu.icm.unicore.uvos.api.Identity;
import pl.edu.icm.unicore.uvos.api.exceptions.UVOSException;
import pl.edu.icm.unicore.uvos.clc.AbstractAction;
import pl.edu.icm.unicore.uvos.clc.ConnectionManager;

class GetAllGroupsAction
extends AbstractAction {
    GetAllGroupsAction(ConnectionManager cm) {
        super(cm, "getAllGroups", "Retrieves a list of all groups the given identity is a member of.\nSyntax:\n   getAllGroups <dn|x509|email> <identity> [implied]\nIf the last arg is given then also groups implied are returned, i.e. if user is a member of group /A/B then /Awill be returned then too.Example:\n   getAllGroups email ann@example.com\n", 2);
    }

    @Override
    public boolean invoke(String[] args) throws UVOSException {
        Identity i = this.getIdentity(args[1], args[2], null);
        if (i == null) {
            return true;
        }
        boolean implied = false;
        if (args.length > 3 && args[3].equals("implied")) {
            implied = true;
        }
        List<Group> groups = this.cm.qTime == null ? this.cm.voQuery.getAllGroups(i, implied) : this.cm.voQueryHistory.getAllGroups(i, implied, this.cm.qTime);
        System.out.println(i + " is a member of the following groups:");
        for (Group g : groups) {
            System.out.println("  " + g);
        }
        return true;
    }
}

