/*
 * Decompiled with CFR 0.152.
 */
package pl.edu.icm.unicore.uvos.clc;

import pl.edu.icm.unicore.uvos.api.Identity;
import pl.edu.icm.unicore.uvos.api.exceptions.UVOSException;
import pl.edu.icm.unicore.uvos.clc.AbstractAction;
import pl.edu.icm.unicore.uvos.clc.ConnectionManager;

class AddIdentityAction
extends AbstractAction {
    AddIdentityAction(ConnectionManager cm) {
        super(cm, "addIdentity", "Creates a new identity. Syntax:\n  addIdentity <dn|x509|email> <value> [label]\nor:  addIdentity email <value> passwd <password> [label]\nThe first argument is an identity type. Next is value, which is a simple string in case of 'dn' or 'email' types and a file name with certificate in case of 'x509' type. 3rd (optional) argument is a friendly (unique) name for the identity. It is common for all equivalent identities. When adding email type identity it is also possible to set it's password.\nExample:\n  addIdentity email test@example.com Johnny\n", 2);
    }

    @Override
    public boolean invoke(String[] args) throws UVOSException {
        Identity i;
        if (args.length > 4 && args[3].equals("passwd")) {
            i = this.getIdentity(args[1], args[2], args.length > 5 ? args[5] : null);
            i.setAuthnData((Object)args[4]);
        } else {
            i = this.getIdentity(args[1], args[2], args.length >= 4 ? args[3] : null);
        }
        if (i == null) {
            return true;
        }
        this.cm.voMan.addIdentity(i);
        System.out.println("Added identity: " + i);
        return true;
    }
}

