/*
 * Decompiled with CFR 0.152.
 */
package pl.edu.icm.unicore.uvos.clc;

import java.io.FileInputStream;
import java.io.IOException;
import java.util.Vector;
import pl.edu.icm.unicore.uvos.api.Attribute;
import pl.edu.icm.unicore.uvos.api.Element;
import pl.edu.icm.unicore.uvos.api.Group;
import pl.edu.icm.unicore.uvos.api.Identity;
import pl.edu.icm.unicore.uvos.api.IdentityType;
import pl.edu.icm.unicore.uvos.api.exceptions.UVOSException;
import pl.edu.icm.unicore.uvos.clc.ConnectionManager;

public abstract class AbstractAction
implements Comparable<AbstractAction> {
    protected String cmd;
    protected String[] aliases;
    protected String help;
    protected int minArgs;
    protected ConnectionManager cm;

    protected AbstractAction(ConnectionManager cm, String cmd, String help) {
        this.cm = cm;
        this.cmd = cmd;
        this.help = help;
        this.minArgs = 0;
        this.aliases = new String[0];
    }

    protected AbstractAction(ConnectionManager cm, String cmd, String help, int minArgs) {
        this(cm, cmd, help);
        this.minArgs = minArgs;
    }

    protected AbstractAction(ConnectionManager cm, String cmd, String help, int minArgs, String alias) {
        this(cm, cmd, help, minArgs);
        this.aliases = new String[]{alias};
    }

    public String getName() {
        return this.cmd;
    }

    public String getHelp() {
        return this.help;
    }

    public int getMinArgsNumber() {
        return this.minArgs;
    }

    @Override
    public int compareTo(AbstractAction a) {
        return a.getName().compareTo(this.cmd);
    }

    public String[] getAliases() {
        return this.aliases;
    }

    public abstract boolean invoke(String[] var1) throws UVOSException;

    protected IdentityType getIdentityType(String name) {
        if (name.equals("dn")) {
            return IdentityType.DN;
        }
        if (name.equals("email")) {
            return IdentityType.EMAIL;
        }
        if (name.equals("x509")) {
            return IdentityType.X509CERT;
        }
        System.out.println("Wrong identity type (" + name + ")");
        return null;
    }

    protected String getIdentityValue(IdentityType it, String arg) {
        if (it.equals((Object)IdentityType.X509CERT)) {
            try {
                FileInputStream fis = new FileInputStream(arg);
                int len = fis.available();
                byte[] buffer = new byte[len];
                fis.read(buffer);
                fis.close();
                return new String(buffer);
            }
            catch (IOException e) {
                e.printStackTrace();
                return null;
            }
        }
        return arg;
    }

    protected Identity getIdentity(String type, String v, String l) {
        IdentityType it = this.getIdentityType(type);
        if (it == null) {
            return null;
        }
        String value = this.getIdentityValue(it, v);
        if (value == null) {
            return null;
        }
        return new Identity(it, value, l);
    }

    protected Attribute getAttribute(String type, String[] values, int valuesStart, int valuesEnd) {
        Vector<String> vs = new Vector<String>();
        for (int i = valuesStart; i < valuesEnd; ++i) {
            vs.add(values[i]);
        }
        return new Attribute(type, vs, null);
    }

    protected Element getElement(String[] args, int argsStart, int argsEnd) {
        String kind = args[argsStart++];
        int nArgs = argsEnd - argsStart;
        if (kind.equals("global")) {
            if (nArgs < 2) {
                System.out.println("Not complete subject specification");
                return null;
            }
            Identity id = this.getIdentity(args[argsStart], args[argsStart + 1], null);
            if (id == null) {
                return null;
            }
            return new Element(null, id);
        }
        if (kind.equals("group")) {
            if (nArgs < 1) {
                System.out.println("Not complete subject specification");
                return null;
            }
            Group g = new Group(args[argsStart]);
            return new Element(g, null);
        }
        if (kind.equals("ig")) {
            if (nArgs < 3) {
                System.out.println("Not complete subject specification");
                return null;
            }
            Identity id = this.getIdentity(args[argsStart], args[argsStart + 1], null);
            if (id == null) {
                return null;
            }
            Group g = new Group(args[argsStart + 2]);
            return new Element(g, id);
        }
        System.out.println("Unknown element kind: " + kind);
        return null;
    }
}

