/*
 * Decompiled with CFR 0.152.
 */
package eu.unicore.security.dsig;

import eu.unicore.security.dsig.DSigException;
import eu.unicore.security.dsig.IdAttribute;
import java.io.StringWriter;
import java.security.InvalidAlgorithmParameterException;
import java.security.KeyException;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.Provider;
import java.security.PublicKey;
import java.security.Security;
import java.security.cert.CertificateEncodingException;
import java.security.cert.CertificateExpiredException;
import java.security.cert.CertificateNotYetValidException;
import java.security.cert.X509Certificate;
import java.security.interfaces.DSAPrivateKey;
import java.security.interfaces.RSAPrivateKey;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.Vector;
import javax.xml.crypto.MarshalException;
import javax.xml.crypto.XMLStructure;
import javax.xml.crypto.dom.DOMCryptoContext;
import javax.xml.crypto.dom.DOMStructure;
import javax.xml.crypto.dsig.CanonicalizationMethod;
import javax.xml.crypto.dsig.DigestMethod;
import javax.xml.crypto.dsig.Reference;
import javax.xml.crypto.dsig.SignatureMethod;
import javax.xml.crypto.dsig.SignedInfo;
import javax.xml.crypto.dsig.Transform;
import javax.xml.crypto.dsig.XMLSignature;
import javax.xml.crypto.dsig.XMLSignatureException;
import javax.xml.crypto.dsig.XMLSignatureFactory;
import javax.xml.crypto.dsig.dom.DOMSignContext;
import javax.xml.crypto.dsig.dom.DOMValidateContext;
import javax.xml.crypto.dsig.keyinfo.KeyInfo;
import javax.xml.crypto.dsig.keyinfo.KeyInfoFactory;
import javax.xml.crypto.dsig.keyinfo.KeyValue;
import javax.xml.crypto.dsig.keyinfo.X509Data;
import javax.xml.crypto.dsig.spec.C14NMethodParameterSpec;
import javax.xml.crypto.dsig.spec.TransformParameterSpec;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.apache.jcp.xml.dsig.internal.dom.XMLDSigRI;
import org.apache.log4j.Logger;
import org.apache.xml.security.utils.Base64;
import org.apache.xmlbeans.XmlBase64Binary;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import xmlbeans.org.w3.x2000.x09.xmldsig.KeyInfoType;
import xmlbeans.org.w3.x2000.x09.xmldsig.X509DataType;

public class DigSignatureUtil {
    private static final Logger log = Logger.getLogger((String)("unicore.security.dsig." + DigSignatureUtil.class.getSimpleName()));
    private XMLSignatureFactory fac = null;

    public DigSignatureUtil() throws DSigException {
        try {
            Security.addProvider((Provider)new XMLDSigRI());
            this.fac = XMLSignatureFactory.getInstance("DOM", "ApacheXMLDSig");
            double ver = this.fac.getProvider().getVersion();
            if (ver < 1.5) {
                log.error((Object)("xmlsec library is not properly configured, XML dsig will sometimes fail! Currently version " + ver + " is used, while at least version 1.44 should be used." + " Most often this means that xmlsec-x.xx.jar is not in Java endorsed directory."));
            }
        }
        catch (Exception e) {
            throw new DSigException("Initialization of digital signature engine failed", e);
        }
    }

    public void genEnvelopedSignature(PrivateKey privKey, PublicKey pubKey, X509Certificate[] cert, Document docToSign, Node insertBefore, IdAttribute idAttribute) throws DSigException {
        try {
            this.genEnvelopedSignatureInternal(privKey, pubKey, cert, docToSign, insertBefore, idAttribute);
        }
        catch (Exception e) {
            throw new DSigException("Creation of enveloped signature failed", e);
        }
    }

    private void genEnvelopedSignatureInternal(PrivateKey privKey, PublicKey pubKey, X509Certificate[] cert, Document docToSign, Node insertBefore, IdAttribute idAttribute) throws MarshalException, XMLSignatureException, NoSuchAlgorithmException, InvalidAlgorithmParameterException, KeyException, CertificateExpiredException, CertificateNotYetValidException {
        SignatureMethod sigMethod;
        DigestMethod digistMethod = this.fac.newDigestMethod("http://www.w3.org/2000/09/xmldsig#sha1", null);
        Vector<Transform> transforms = new Vector<Transform>();
        transforms.add(this.fac.newTransform("http://www.w3.org/2000/09/xmldsig#enveloped-signature", (TransformParameterSpec)null));
        transforms.add(this.fac.newTransform("http://www.w3.org/2001/10/xml-exc-c14n#", (TransformParameterSpec)null));
        CanonicalizationMethod canMethod = this.fac.newCanonicalizationMethod("http://www.w3.org/2001/10/xml-exc-c14n#", (C14NMethodParameterSpec)null);
        if (privKey instanceof RSAPrivateKey) {
            sigMethod = this.fac.newSignatureMethod("http://www.w3.org/2000/09/xmldsig#rsa-sha1", null);
        } else if (privKey instanceof DSAPrivateKey) {
            sigMethod = this.fac.newSignatureMethod("http://www.w3.org/2000/09/xmldsig#dsa-sha1", null);
        } else {
            throw new KeyException("Unsupported private key algorithm (must be DSA or RSA) :" + privKey.getAlgorithm());
        }
        Element elToSign = docToSign.getDocumentElement();
        if (!elToSign.hasAttributeNS(idAttribute.getNamespace(), idAttribute.getLocalName())) {
            throw new IllegalArgumentException("The document to be signed doesn't contain the requested ID attribtue " + idAttribute);
        }
        String id = elToSign.getAttributeNS(idAttribute.getNamespace(), idAttribute.getLocalName());
        if (id != null) {
            id = "#" + id;
        }
        Reference ref = this.fac.newReference(id, digistMethod, transforms, null, null);
        SignedInfo si = this.fac.newSignedInfo(canMethod, sigMethod, Collections.singletonList(ref));
        if (log.isTraceEnabled()) {
            log.trace((Object)("Will generate signature of a document:\n" + DigSignatureUtil.dumpDOMToString(docToSign)));
        }
        DOMSignContext dsc = null;
        dsc = insertBefore == null ? new DOMSignContext(privKey, (Node)elToSign) : new DOMSignContext(privKey, (Node)elToSign, insertBefore);
        dsc.setIdAttributeNS(elToSign, idAttribute.getNamespace(), idAttribute.getLocalName());
        dsc.putNamespacePrefix("http://www.w3.org/2000/09/xmldsig#", "dsig");
        KeyInfo ki = null;
        KeyInfoFactory kif = this.fac.getKeyInfoFactory();
        Vector<XMLStructure> kiVals = new Vector<XMLStructure>();
        if (pubKey != null) {
            KeyValue kv = kif.newKeyValue(pubKey);
            kiVals.add(kv);
        }
        if (cert != null) {
            ArrayList<X509Certificate> certList = new ArrayList<X509Certificate>();
            for (X509Certificate c : cert) {
                certList.add(c);
            }
            X509Data x509Data = kif.newX509Data(certList);
            kiVals.add(x509Data);
        }
        if (kiVals.size() > 0) {
            ki = kif.newKeyInfo(kiVals);
        }
        XMLSignature signature = this.fac.newXMLSignature(si, ki);
        signature.sign(dsc);
        if (log.isTraceEnabled()) {
            log.trace((Object)("Signed document:\n" + DigSignatureUtil.dumpDOMToString(docToSign)));
        }
    }

    public boolean verifyEnvelopedSignature(Document signedDocument, List<Element> shallBeSigned, IdAttribute idAttribute, PublicKey validatingKey) throws DSigException {
        try {
            return this.verifyEnvelopedSignatureInternal(signedDocument, shallBeSigned, idAttribute, validatingKey);
        }
        catch (Exception e) {
            throw new DSigException("Verification of enveloped signature failed", e);
        }
    }

    private boolean verifyEnvelopedSignatureInternal(Document signedDocument, List<Element> shallBeSigned, IdAttribute idAttribute, PublicKey validatingKey) throws MarshalException, XMLSignatureException {
        NodeList nl = signedDocument.getElementsByTagNameNS("http://www.w3.org/2000/09/xmldsig#", "Signature");
        if (nl.getLength() == 0) {
            throw new XMLSignatureException("Document not signed");
        }
        return this.verifySignatureInternal(signedDocument, shallBeSigned, idAttribute, validatingKey, nl.item(0));
    }

    public boolean verifyDetachedSignature(Document signedDocument, List<Element> shallBeSigned, IdAttribute idAttribute, PublicKey validatingKey, Node signatureNode) throws DSigException {
        try {
            return this.verifySignatureInternal(signedDocument, shallBeSigned, idAttribute, validatingKey, signatureNode);
        }
        catch (Exception e) {
            throw new DSigException("Verification of detached signature failed", e);
        }
    }

    private boolean verifySignatureInternal(Document signedDocument, List<Element> shallBeSigned, IdAttribute idAttribute, PublicKey validatingKey, Node signatureNode) throws MarshalException, XMLSignatureException {
        if (log.isTraceEnabled()) {
            log.trace((Object)("Will verify signature of document:\n" + DigSignatureUtil.dumpDOMToString(signedDocument)));
        }
        DOMValidateContext valContext = new DOMValidateContext(validatingKey, signatureNode);
        this.setResolverAttributes(valContext, signedDocument.getDocumentElement(), idAttribute);
        XMLSignature signature = this.fac.unmarshalXMLSignature(valContext);
        boolean coreValidity = signature.validate(valContext);
        if (!coreValidity) {
            log.debug((Object)"Signature failed core validation");
        }
        if (!coreValidity && log.isDebugEnabled()) {
            boolean sv = signature.getSignatureValue().validate(valContext);
            log.debug((Object)("signature validation status: " + sv));
            Iterator<Reference> i = signature.getSignedInfo().getReferences().iterator();
            int j = 0;
            while (i.hasNext()) {
                Reference ref = i.next();
                boolean refValid = ref.validate(valContext);
                log.debug((Object)("ref[" + j + "] validity status: " + refValid));
                String s = Base64.encode((byte[])ref.getDigestValue());
                log.debug((Object)("ref[" + j + "] digest: " + s));
                s = Base64.encode((byte[])ref.getCalculatedDigestValue());
                log.debug((Object)("ref[" + j + "] calculated digest: " + s));
                ++j;
            }
        }
        if (!coreValidity) {
            return false;
        }
        boolean everythingSigned = this.checkCompletness(signature.getSignedInfo().getReferences(), shallBeSigned, signedDocument, idAttribute);
        if (!everythingSigned) {
            log.debug((Object)"Signature is correct but some of the required elements are not signed");
            return false;
        }
        return true;
    }

    public static KeyInfoType generateX509KeyInfo(X509Certificate[] certs) throws CertificateEncodingException {
        KeyInfoType ret = KeyInfoType.Factory.newInstance();
        X509DataType x509Data = ret.addNewX509Data();
        for (X509Certificate cert : certs) {
            XmlBase64Binary binCert = x509Data.addNewX509Certificate();
            byte[] certRaw = cert.getEncoded();
            binCert.setByteArrayValue(certRaw);
        }
        return ret;
    }

    public List<?> getReferencesFromSignature(Node signatureNode) throws DSigException {
        XMLSignature signature;
        DOMStructure xml = new DOMStructure(signatureNode);
        try {
            signature = this.fac.unmarshalXMLSignature(xml);
        }
        catch (MarshalException e) {
            throw new DSigException("Can't unmarshal signature", e);
        }
        return signature.getSignedInfo().getReferences();
    }

    private void setResolverAttributes(DOMCryptoContext cryptoContext, Element element, IdAttribute idAttribute) throws XMLSignatureException {
        this.checkElementForIdAttribute(cryptoContext, element, idAttribute);
        NodeList nodes = element.getChildNodes();
        for (int i = 0; i < nodes.getLength(); ++i) {
            Node n = nodes.item(i);
            if (!(n instanceof Element)) continue;
            Element e = (Element)n;
            this.setResolverAttributes(cryptoContext, e, idAttribute);
        }
    }

    private void checkElementForIdAttribute(DOMCryptoContext cryptoContext, Element element, IdAttribute idAttribute) throws XMLSignatureException {
        if (element.hasAttributeNS(idAttribute.getNamespace(), idAttribute.getLocalName())) {
            String value = element.getAttributeNS(idAttribute.getNamespace(), idAttribute.getLocalName());
            if (cryptoContext.getElementById(value) != null) {
                log.warn((Object)("The XML document contains more then one element with the same identifier " + value + ": " + element.getNodeName() + " and " + cryptoContext.getElementById(value).getNodeName() + ". In case of signing this is a bug, in case of verification can mean that there is an XSW attack."));
                throw new XMLSignatureException("The XML document contains more then one element with the same identifier " + value + ": " + element.getNodeName() + " and " + cryptoContext.getElementById(value).getNodeName() + ". In case of signing this is a bug, in case of verification can mean that there is an XSW attack.");
            }
            cryptoContext.setIdAttributeNS(element, idAttribute.getNamespace(), idAttribute.getLocalName());
        }
    }

    public boolean checkCompletness(List<Reference> signedReferences, List<Element> shallBeSigned, Document signedDocument, IdAttribute idAttribute) {
        HashSet<String> signedIds = new HashSet<String>();
        for (Reference ref : signedReferences) {
            signedIds.add(ref.getURI());
        }
        for (Element part : shallBeSigned) {
            log.trace((Object)("Required part: " + part.getTagName()));
            if (this.checkIfNodeSigned(signedIds, part, idAttribute)) continue;
            return false;
        }
        return true;
    }

    private boolean checkIfNodeSigned(Set<String> signedIds, Element el, IdAttribute idAttribute) {
        if (!el.hasAttributeNS(idAttribute.getNamespace(), idAttribute.getLocalName())) {
            log.debug((Object)("Assuming that element {" + el.getNamespaceURI() + "}" + el.getLocalName() + " is not signed as it doesn't have id attribute"));
            return false;
        }
        String idVal = el.getAttributeNS(idAttribute.getNamespace(), idAttribute.getLocalName());
        String id = "#" + idVal;
        if (signedIds.contains(id)) {
            return true;
        }
        log.warn((Object)("Didn't find among signed references a required element: {" + el.getNamespaceURI() + "}" + el.getLocalName() + " with id " + id));
        return false;
    }

    public static String dumpDOMToString(Element node) {
        return DigSignatureUtil.dumpNodeToString(node);
    }

    public static String dumpDOMToString(Document node) {
        return DigSignatureUtil.dumpNodeToString(node);
    }

    private static String dumpNodeToString(Node document) {
        TransformerFactory transformerFactory = TransformerFactory.newInstance();
        try {
            Transformer transformer = transformerFactory.newTransformer();
            StringWriter stringWriter = new StringWriter();
            StreamResult streamResult = new StreamResult(stringWriter);
            DOMSource domSource = new DOMSource(document);
            transformer.transform(domSource, streamResult);
            return stringWriter.toString();
        }
        catch (TransformerException e) {
            log.warn((Object)("Can't serialize DOM Document to String: " + e));
            return null;
        }
    }
}

