from ucfg_updater import *
from ucfg_utils import info, error

from ucfg_main import ConfigUtilities

import os
import re

from _use import USEUpdater

class UUpdater(USEUpdater):
	
	def printDescription(self, options):
		info(options, "Updates Unicore/X configuration from pre 6.6.0 versions to the 6.6.0 syntax")

	def run(self, options):
		info(options, "UNICORE/X configuration updater")
		super(UUpdater, self).run(options, 'unicorex')
		cfgUtil = ConfigUtilities(options, 'unicorex')

		dict = {
			'defaultsms.workdir'						: 'coreServices.defaultsms.workdir',
			'uas.targetsystemfactory.xnjs.configfile'	: 'coreServices.targetsystemfactory.xnjs.configfile',
			'uas.sms.protocols'							: 'coreServices.sms.protocols',
			'uas.storagefactory.types' 					: 'coreServices.sms.enabledFactories',
			'unicore.gridbean.directory'				: 'coreServices.gridbean.directory',
			'cip.data.path'								: 'coreServices.cip.dataPath',
			'bes.naming.profile'						: 'coreServices.bes.namingProfile',
			'bes.job.mode'								: 'coreServices.bes.jobMode',
			'bes.is.accepting.new.activities'			: 'coreServices.bes.isAcceptingNewActivities',
			'bes.naming.profile'						: 'coreServices.bes.namingProfile',
			'bes.local.resource.manager.type'			: 'coreServices.bes.localResourceManagerType',
			'bes.common.name'							: 'coreServices.bes.commonName',
			'bes.long.description'						: 'coreServices.bes.longDescription',
			'bes.extension'								: 'coreServices.bes.extension',
		}

		javaProps = cfgUtil.getJavaPropertyKeys('uas.config')
		for propName in javaProps:
			m = re.match('^(uas\.storagefactory\.)(.*)', propName)
			if m != None and not (propName == 'uas.storagefactory.types'):
				dict[propName] = 'coreServices.sms.factory.' + m.group(2) 

		cfgUtil.updateJavaPropertyNames('uas.config', dict)

		dict = {
			'bes.factory.id' : 'This property is not available anymore without a replacement.'
		}

		cfgUtil.commentJavaProperties('uas.config', dict);
		
		info(options, "Finished update of configuration of Unicore/X")


