/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.transport.failover;

import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.InterruptedIOException;
import java.net.InetAddress;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.activemq.broker.SslContext;
import org.apache.activemq.command.Command;
import org.apache.activemq.command.ConnectionControl;
import org.apache.activemq.command.ConnectionId;
import org.apache.activemq.command.RemoveInfo;
import org.apache.activemq.command.Response;
import org.apache.activemq.state.ConnectionStateTracker;
import org.apache.activemq.state.Tracked;
import org.apache.activemq.thread.DefaultThreadPools;
import org.apache.activemq.thread.Task;
import org.apache.activemq.thread.TaskRunner;
import org.apache.activemq.transport.CompositeTransport;
import org.apache.activemq.transport.DefaultTransportListener;
import org.apache.activemq.transport.FutureResponse;
import org.apache.activemq.transport.ResponseCallback;
import org.apache.activemq.transport.Transport;
import org.apache.activemq.transport.TransportFactory;
import org.apache.activemq.transport.TransportListener;
import org.apache.activemq.transport.failover.BackupTransport;
import org.apache.activemq.util.IOExceptionSupport;
import org.apache.activemq.util.ServiceSupport;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FailoverTransport
implements CompositeTransport {
    private static final Log LOG = LogFactory.getLog(FailoverTransport.class);
    private TransportListener transportListener;
    private boolean disposed;
    private boolean connected;
    private final CopyOnWriteArrayList<URI> uris = new CopyOnWriteArrayList();
    private final CopyOnWriteArrayList<URI> updated = new CopyOnWriteArrayList();
    private final Object reconnectMutex = new Object();
    private final Object backupMutex = new Object();
    private final Object sleepMutex = new Object();
    private final Object listenerMutex = new Object();
    private final ConnectionStateTracker stateTracker = new ConnectionStateTracker();
    private final Map<Integer, Command> requestMap = new LinkedHashMap<Integer, Command>();
    private URI connectedTransportURI;
    private URI failedConnectTransportURI;
    private final AtomicReference<Transport> connectedTransport = new AtomicReference();
    private final TaskRunner reconnectTask;
    private boolean started;
    private boolean initialized;
    private long initialReconnectDelay = 10L;
    private long maxReconnectDelay = 30000L;
    private double backOffMultiplier = 2.0;
    private long timeout = -1L;
    private boolean useExponentialBackOff = true;
    private boolean randomize = true;
    private int maxReconnectAttempts;
    private int startupMaxReconnectAttempts;
    private int connectFailures;
    private long reconnectDelay = this.initialReconnectDelay;
    private Exception connectionFailure;
    private boolean firstConnection = true;
    private boolean backup = false;
    private final List<BackupTransport> backups = new CopyOnWriteArrayList<BackupTransport>();
    private int backupPoolSize = 1;
    private boolean trackMessages = false;
    private boolean trackTransactionProducers = true;
    private int maxCacheSize = 131072;
    private final TransportListener disposedListener = new DefaultTransportListener(){};
    private final TransportListener myTransportListener = this.createTransportListener();
    private boolean updateURIsSupported = true;
    private boolean reconnectSupported = true;
    private SslContext brokerSslContext = SslContext.getCurrentSslContext();
    private String updateURIsURL = null;
    private boolean rebalanceUpdateURIs = true;

    public FailoverTransport() throws InterruptedIOException {
        this.stateTracker.setTrackTransactions(true);
        this.reconnectTask = DefaultThreadPools.getDefaultTaskRunnerFactory().createTaskRunner(new Task(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public boolean iterate() {
                boolean result = false;
                boolean buildBackup = true;
                boolean doReconnect = !FailoverTransport.this.disposed;
                Object object = FailoverTransport.this.backupMutex;
                synchronized (object) {
                    if (FailoverTransport.this.connectedTransport.get() == null && !FailoverTransport.this.disposed) {
                        result = FailoverTransport.this.doReconnect();
                        buildBackup = false;
                    }
                }
                if (buildBackup) {
                    FailoverTransport.this.buildBackups();
                } else {
                    result = true;
                    try {
                        FailoverTransport.this.reconnectTask.wakeup();
                    }
                    catch (InterruptedException e) {
                        LOG.debug((Object)"Reconnect task has been interrupted.", (Throwable)e);
                    }
                }
                return result;
            }
        }, "ActiveMQ Failover Worker: " + System.identityHashCode(this));
    }

    TransportListener createTransportListener() {
        return new TransportListener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void onCommand(Object o) {
                Command command = (Command)o;
                if (command == null) {
                    return;
                }
                if (command.isResponse()) {
                    Object object = null;
                    Map map = FailoverTransport.this.requestMap;
                    synchronized (map) {
                        object = FailoverTransport.this.requestMap.remove(((Response)command).getCorrelationId());
                    }
                    if (object != null && object.getClass() == Tracked.class) {
                        ((Tracked)object).onResponses(command);
                    }
                }
                if (!FailoverTransport.this.initialized) {
                    FailoverTransport.this.initialized = true;
                }
                if (command.isConnectionControl()) {
                    FailoverTransport.this.handleConnectionControl((ConnectionControl)command);
                }
                if (FailoverTransport.this.transportListener != null) {
                    FailoverTransport.this.transportListener.onCommand(command);
                }
            }

            public void onException(IOException error) {
                try {
                    FailoverTransport.this.handleTransportFailure(error);
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                    FailoverTransport.this.transportListener.onException(new InterruptedIOException());
                }
            }

            public void transportInterupted() {
                if (FailoverTransport.this.transportListener != null) {
                    FailoverTransport.this.transportListener.transportInterupted();
                }
            }

            public void transportResumed() {
                if (FailoverTransport.this.transportListener != null) {
                    FailoverTransport.this.transportListener.transportResumed();
                }
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void handleTransportFailure(IOException e) throws InterruptedException {
        Transport transport;
        if (LOG.isTraceEnabled()) {
            LOG.trace((Object)(this + " handleTransportFailure: " + e));
        }
        if ((transport = (Transport)this.connectedTransport.getAndSet(null)) == null) {
            Object object = this.reconnectMutex;
            synchronized (object) {
                transport = this.connectedTransport.getAndSet(null);
            }
        }
        if (transport != null) {
            transport.setTransportListener(this.disposedListener);
            ServiceSupport.dispose(transport);
            boolean reconnectOk = false;
            Object object = this.reconnectMutex;
            synchronized (object) {
                if (this.started) {
                    LOG.warn((Object)("Transport (" + transport.getRemoteAddress() + ") failed to " + this.connectedTransportURI + " , attempting to automatically reconnect due to: " + e));
                    LOG.debug((Object)"Transport failed with the following exception:", (Throwable)e);
                    reconnectOk = true;
                }
                this.initialized = false;
                this.failedConnectTransportURI = this.connectedTransportURI;
                this.connectedTransportURI = null;
                this.connected = false;
                if (this.transportListener != null) {
                    this.transportListener.transportInterupted();
                }
                if (reconnectOk) {
                    this.reconnectTask.wakeup();
                }
            }
        }
    }

    public final void handleConnectionControl(ConnectionControl control) {
        String reconnectStr = control.getReconnectTo();
        if (reconnectStr != null && (reconnectStr = reconnectStr.trim()).length() > 0) {
            try {
                URI uri = new URI(reconnectStr);
                if (this.isReconnectSupported()) {
                    this.reconnect(uri);
                    LOG.info((Object)("Reconnected to: " + uri));
                }
            }
            catch (Exception e) {
                LOG.error((Object)("Failed to handle ConnectionControl reconnect to " + reconnectStr), (Throwable)e);
            }
        }
        this.processNewTransports(control.isRebalanceConnection(), control.getConnectedBrokers());
    }

    private final void processNewTransports(boolean rebalance, String newTransports) {
        if (newTransports != null && (newTransports = newTransports.trim()).length() > 0 && this.isUpdateURIsSupported()) {
            ArrayList<URI> list = new ArrayList<URI>();
            StringTokenizer tokenizer = new StringTokenizer(newTransports, ",");
            while (tokenizer.hasMoreTokens()) {
                String str = tokenizer.nextToken();
                try {
                    URI uri = new URI(str);
                    list.add(uri);
                }
                catch (Exception e) {
                    LOG.error((Object)("Failed to parse broker address: " + str), (Throwable)e);
                }
            }
            if (!list.isEmpty()) {
                try {
                    this.updateURIs(rebalance, list.toArray(new URI[list.size()]));
                }
                catch (IOException e) {
                    LOG.error((Object)("Failed to update transport URI's from: " + newTransports), (Throwable)e);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void start() throws Exception {
        Object object = this.reconnectMutex;
        synchronized (object) {
            LOG.debug((Object)"Started.");
            if (this.started) {
                return;
            }
            this.started = true;
            this.stateTracker.setMaxCacheSize(this.getMaxCacheSize());
            this.stateTracker.setTrackMessages(this.isTrackMessages());
            this.stateTracker.setTrackTransactionProducers(this.isTrackTransactionProducers());
            if (this.connectedTransport.get() != null) {
                this.stateTracker.restore(this.connectedTransport.get());
            } else {
                this.reconnect(false);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void stop() throws Exception {
        Transport transportToStop = null;
        Object object = this.reconnectMutex;
        synchronized (object) {
            LOG.debug((Object)"Stopped.");
            if (!this.started) {
                return;
            }
            this.started = false;
            this.disposed = true;
            this.connected = false;
            for (BackupTransport t : this.backups) {
                t.setDisposed(true);
            }
            this.backups.clear();
            if (this.connectedTransport.get() != null) {
                transportToStop = this.connectedTransport.getAndSet(null);
            }
            this.reconnectMutex.notifyAll();
        }
        object = this.sleepMutex;
        synchronized (object) {
            this.sleepMutex.notifyAll();
        }
        this.reconnectTask.shutdown();
        if (transportToStop != null) {
            transportToStop.stop();
        }
    }

    public long getInitialReconnectDelay() {
        return this.initialReconnectDelay;
    }

    public void setInitialReconnectDelay(long initialReconnectDelay) {
        this.initialReconnectDelay = initialReconnectDelay;
    }

    public long getMaxReconnectDelay() {
        return this.maxReconnectDelay;
    }

    public void setMaxReconnectDelay(long maxReconnectDelay) {
        this.maxReconnectDelay = maxReconnectDelay;
    }

    public long getReconnectDelay() {
        return this.reconnectDelay;
    }

    public void setReconnectDelay(long reconnectDelay) {
        this.reconnectDelay = reconnectDelay;
    }

    public double getReconnectDelayExponent() {
        return this.backOffMultiplier;
    }

    public void setReconnectDelayExponent(double reconnectDelayExponent) {
        this.backOffMultiplier = reconnectDelayExponent;
    }

    public Transport getConnectedTransport() {
        return this.connectedTransport.get();
    }

    public URI getConnectedTransportURI() {
        return this.connectedTransportURI;
    }

    public int getMaxReconnectAttempts() {
        return this.maxReconnectAttempts;
    }

    public void setMaxReconnectAttempts(int maxReconnectAttempts) {
        this.maxReconnectAttempts = maxReconnectAttempts;
    }

    public int getStartupMaxReconnectAttempts() {
        return this.startupMaxReconnectAttempts;
    }

    public void setStartupMaxReconnectAttempts(int startupMaxReconnectAttempts) {
        this.startupMaxReconnectAttempts = startupMaxReconnectAttempts;
    }

    public long getTimeout() {
        return this.timeout;
    }

    public void setTimeout(long timeout) {
        this.timeout = timeout;
    }

    public boolean isRandomize() {
        return this.randomize;
    }

    public void setRandomize(boolean randomize) {
        this.randomize = randomize;
    }

    public boolean isBackup() {
        return this.backup;
    }

    public void setBackup(boolean backup) {
        this.backup = backup;
    }

    public int getBackupPoolSize() {
        return this.backupPoolSize;
    }

    public void setBackupPoolSize(int backupPoolSize) {
        this.backupPoolSize = backupPoolSize;
    }

    public boolean isTrackMessages() {
        return this.trackMessages;
    }

    public void setTrackMessages(boolean trackMessages) {
        this.trackMessages = trackMessages;
    }

    public boolean isTrackTransactionProducers() {
        return this.trackTransactionProducers;
    }

    public void setTrackTransactionProducers(boolean trackTransactionProducers) {
        this.trackTransactionProducers = trackTransactionProducers;
    }

    public int getMaxCacheSize() {
        return this.maxCacheSize;
    }

    public void setMaxCacheSize(int maxCacheSize) {
        this.maxCacheSize = maxCacheSize;
    }

    private boolean isShutdownCommand(Command command) {
        return command != null && (command.isShutdownInfo() || command instanceof RemoveInfo);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void oneway(Object o) throws IOException {
        Command command = (Command)o;
        Exception error = null;
        try {
            Object object = this.reconnectMutex;
            synchronized (object) {
                if (this.isShutdownCommand(command) && this.connectedTransport.get() == null) {
                    if (command.isShutdownInfo()) {
                        return;
                    }
                    if (command instanceof RemoveInfo || command.isMessageAck()) {
                        this.stateTracker.track(command);
                        Response response = new Response();
                        response.setCorrelationId(command.getCommandId());
                        this.myTransportListener.onCommand(response);
                        return;
                    }
                }
                int i = 0;
                while (!this.disposed) {
                    try {
                        block28: {
                            Transport transport = this.connectedTransport.get();
                            long start = System.currentTimeMillis();
                            boolean timedout = false;
                            while (transport == null && !this.disposed && this.connectionFailure == null && !Thread.currentThread().isInterrupted()) {
                                LOG.trace((Object)("Waiting for transport to reconnect..: " + command));
                                long end = System.currentTimeMillis();
                                if (this.timeout > 0L && end - start > this.timeout) {
                                    timedout = true;
                                    LOG.info((Object)("Failover timed out after " + (end - start) + "ms"));
                                    break;
                                }
                                try {
                                    this.reconnectMutex.wait(100L);
                                }
                                catch (InterruptedException e) {
                                    Thread.currentThread().interrupt();
                                    LOG.debug((Object)("Interupted: " + e), (Throwable)e);
                                }
                                transport = this.connectedTransport.get();
                            }
                            if (transport == null) {
                                error = this.disposed ? new IOException("Transport disposed.") : (this.connectionFailure != null ? this.connectionFailure : (timedout ? new IOException("Failover timeout of " + this.timeout + " ms reached.") : new IOException("Unexpected failure.")));
                                break;
                            }
                            Tracked tracked = this.stateTracker.track(command);
                            Map<Integer, Command> map = this.requestMap;
                            synchronized (map) {
                                if (tracked != null && tracked.isWaitingForResponse()) {
                                    this.requestMap.put(command.getCommandId(), tracked);
                                } else if (tracked == null && command.isResponseRequired()) {
                                    this.requestMap.put(command.getCommandId(), command);
                                }
                            }
                            try {
                                transport.oneway(command);
                                this.stateTracker.trackBack(command);
                            }
                            catch (IOException e) {
                                if (tracked != null) break block28;
                                if (command.isResponseRequired()) {
                                    this.requestMap.remove(command.getCommandId());
                                }
                                throw e;
                            }
                        }
                        return;
                    }
                    catch (IOException e) {
                        if (LOG.isDebugEnabled()) {
                            LOG.debug((Object)("Send oneway attempt: " + i + " failed for command:" + command));
                        }
                        this.handleTransportFailure(e);
                        ++i;
                    }
                }
            }
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new InterruptedIOException();
        }
        if (!this.disposed && error != null) {
            if (error instanceof IOException) {
                throw (IOException)error;
            }
            throw IOExceptionSupport.create(error);
        }
    }

    @Override
    public FutureResponse asyncRequest(Object command, ResponseCallback responseCallback) throws IOException {
        throw new AssertionError((Object)"Unsupported Method");
    }

    @Override
    public Object request(Object command) throws IOException {
        throw new AssertionError((Object)"Unsupported Method");
    }

    @Override
    public Object request(Object command, int timeout) throws IOException {
        throw new AssertionError((Object)"Unsupported Method");
    }

    @Override
    public void add(boolean rebalance, URI[] u) {
        boolean newURI = false;
        for (int i = 0; i < u.length; ++i) {
            if (this.contains(u[i])) continue;
            this.uris.add(i, u[i]);
            newURI = true;
        }
        if (newURI) {
            this.reconnect(rebalance);
        }
    }

    @Override
    public void remove(boolean rebalance, URI[] u) {
        for (int i = 0; i < u.length; ++i) {
            this.uris.remove(u[i]);
        }
        this.reconnect(rebalance);
    }

    public void add(boolean rebalance, String u) {
        try {
            URI newURI = new URI(u);
            if (!this.contains(newURI)) {
                this.uris.add(newURI);
                this.reconnect(rebalance);
            }
        }
        catch (Exception e) {
            LOG.error((Object)("Failed to parse URI: " + u));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reconnect(boolean rebalance) {
        Object object = this.reconnectMutex;
        synchronized (object) {
            if (this.started) {
                Transport transport;
                if (rebalance && (transport = (Transport)this.connectedTransport.getAndSet(null)) != null) {
                    try {
                        transport.stop();
                    }
                    catch (Exception e) {
                        LOG.debug((Object)"Caught an exception stopping existing transport", (Throwable)e);
                    }
                }
                LOG.debug((Object)"Waking up reconnect task");
                try {
                    this.reconnectTask.wakeup();
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                }
            } else {
                LOG.debug((Object)"Reconnect was triggered but transport is not started yet. Wait for start to connect the transport.");
            }
        }
    }

    private List<URI> getConnectList() {
        ArrayList<URI> l = new ArrayList<URI>(this.uris);
        boolean removed = false;
        if (this.failedConnectTransportURI != null) {
            removed = l.remove(this.failedConnectTransportURI);
        }
        if (this.randomize) {
            for (int i = 0; i < l.size(); ++i) {
                int p = (int)(Math.random() * 100.0 % (double)l.size());
                URI t = l.get(p);
                l.set(p, l.get(i));
                l.set(i, t);
            }
        }
        if (removed) {
            l.add(this.failedConnectTransportURI);
        }
        LOG.debug((Object)("urlList connectionList:" + l));
        return l;
    }

    @Override
    public TransportListener getTransportListener() {
        return this.transportListener;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setTransportListener(TransportListener commandListener) {
        Object object = this.listenerMutex;
        synchronized (object) {
            this.transportListener = commandListener;
            this.listenerMutex.notifyAll();
        }
    }

    @Override
    public <T> T narrow(Class<T> target) {
        if (target.isAssignableFrom(this.getClass())) {
            return target.cast(this);
        }
        Transport transport = this.connectedTransport.get();
        if (transport != null) {
            return transport.narrow(target);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void restoreTransport(Transport t) throws Exception, IOException {
        t.start();
        ConnectionControl cc = new ConnectionControl();
        cc.setFaultTolerant(true);
        t.oneway(cc);
        this.stateTracker.restore(t);
        LinkedHashMap<Integer, Command> tmpMap = null;
        Map<Integer, Command> map = this.requestMap;
        synchronized (map) {
            tmpMap = new LinkedHashMap<Integer, Command>(this.requestMap);
        }
        for (Command command : tmpMap.values()) {
            if (LOG.isTraceEnabled()) {
                LOG.trace((Object)("restore requestMap, replay: " + command));
            }
            t.oneway(command);
        }
    }

    public boolean isUseExponentialBackOff() {
        return this.useExponentialBackOff;
    }

    public void setUseExponentialBackOff(boolean useExponentialBackOff) {
        this.useExponentialBackOff = useExponentialBackOff;
    }

    public String toString() {
        return this.connectedTransportURI == null ? "unconnected" : this.connectedTransportURI.toString();
    }

    @Override
    public String getRemoteAddress() {
        Transport transport = this.connectedTransport.get();
        if (transport != null) {
            return transport.getRemoteAddress();
        }
        return null;
    }

    @Override
    public boolean isFaultTolerant() {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive exception aggregation
     */
    final boolean doReconnect() {
        Exception failure = null;
        Object object = this.reconnectMutex;
        synchronized (object) {
            Object newUris;
            String fileURL = this.getUpdateURIsURL();
            if (fileURL != null) {
                BufferedReader in = null;
                newUris = null;
                StringBuffer buffer = new StringBuffer();
                try {
                    String line;
                    in = new BufferedReader(this.getURLStream(fileURL));
                    while ((line = in.readLine()) != null) {
                        buffer.append(line);
                    }
                    newUris = buffer.toString();
                }
                catch (IOException ioe) {
                    LOG.error((Object)("Failed to read updateURIsURL: " + fileURL), (Throwable)ioe);
                }
                finally {
                    if (in != null) {
                        try {
                            in.close();
                        }
                        catch (IOException ioe) {}
                    }
                }
                this.processNewTransports(this.isRebalanceUpdateURIs(), (String)newUris);
            }
            if (this.disposed || this.connectionFailure != null) {
                this.reconnectMutex.notifyAll();
            }
            if (this.connectedTransport.get() != null || this.disposed || this.connectionFailure != null) {
                return false;
            }
            List<URI> connectList = this.getConnectList();
            if (connectList.isEmpty()) {
                failure = new IOException("No uris available to connect to.");
            } else {
                Object uri22;
                Transport t;
                if (!this.useExponentialBackOff) {
                    this.reconnectDelay = this.initialReconnectDelay;
                }
                newUris = this.backupMutex;
                synchronized (newUris) {
                    if (this.backup && !this.backups.isEmpty()) {
                        BackupTransport bt = this.backups.remove(0);
                        t = bt.getTransport();
                        uri22 = bt.getUri();
                        t.setTransportListener(this.myTransportListener);
                        try {
                            if (this.started) {
                                this.restoreTransport(t);
                            }
                            this.reconnectDelay = this.initialReconnectDelay;
                            this.failedConnectTransportURI = null;
                            this.connectedTransportURI = uri22;
                            this.connectedTransport.set(t);
                            this.reconnectMutex.notifyAll();
                            this.connectFailures = 0;
                            LOG.info((Object)("Successfully reconnected to backup " + uri22));
                            return false;
                        }
                        catch (Exception e) {
                            LOG.debug((Object)"Backup transport failed", (Throwable)e);
                        }
                    }
                }
                Iterator<URI> iter = connectList.iterator();
                while (iter.hasNext() && this.connectedTransport.get() == null && !this.disposed) {
                    URI uri = iter.next();
                    t = null;
                    try {
                        LOG.debug((Object)("Attempting connect to: " + uri));
                        SslContext.setCurrentSslContext(this.brokerSslContext);
                        t = TransportFactory.compositeConnect(uri);
                        t.setTransportListener(this.myTransportListener);
                        t.start();
                        if (this.started) {
                            this.restoreTransport(t);
                        }
                        LOG.debug((Object)"Connection established");
                        this.reconnectDelay = this.initialReconnectDelay;
                        this.connectedTransportURI = uri;
                        this.connectedTransport.set(t);
                        this.reconnectMutex.notifyAll();
                        this.connectFailures = 0;
                        uri22 = this.listenerMutex;
                        synchronized (uri22) {
                            if (this.transportListener == null) {
                                try {
                                    this.listenerMutex.wait(2000L);
                                }
                                catch (InterruptedException ex) {
                                    // empty catch block
                                }
                            }
                        }
                        if (this.transportListener != null) {
                            this.transportListener.transportResumed();
                        } else {
                            LOG.debug((Object)"transport resumed by transport listener not set");
                        }
                        if (this.firstConnection) {
                            this.firstConnection = false;
                            LOG.info((Object)("Successfully connected to " + uri));
                        } else {
                            LOG.info((Object)("Successfully reconnected to " + uri));
                        }
                        this.connected = true;
                        boolean uri22 = false;
                        return uri22;
                    }
                    catch (Exception e) {
                        failure = e;
                        LOG.debug((Object)("Connect fail to: " + uri + ", reason: " + e));
                        if (t == null) continue;
                        try {
                            t.stop();
                        }
                        catch (Exception ee) {
                            LOG.debug((Object)("Stop of failed transport: " + t + " failed with reason: " + ee));
                        }
                    }
                    finally {
                        SslContext.setCurrentSslContext(null);
                    }
                }
            }
            int reconnectAttempts = 0;
            if (this.firstConnection && this.startupMaxReconnectAttempts != 0) {
                reconnectAttempts = this.startupMaxReconnectAttempts;
            }
            if (reconnectAttempts == 0) {
                reconnectAttempts = this.maxReconnectAttempts;
            }
            if (reconnectAttempts > 0 && ++this.connectFailures >= reconnectAttempts) {
                LOG.error((Object)("Failed to connect to transport after: " + this.connectFailures + " attempt(s)"));
                this.connectionFailure = failure;
                Object object2 = this.listenerMutex;
                synchronized (object2) {
                    if (this.transportListener == null) {
                        try {
                            this.listenerMutex.wait(2000L);
                        }
                        catch (InterruptedException ex) {
                            // empty catch block
                        }
                    }
                }
                if (this.transportListener != null) {
                    if (this.connectionFailure instanceof IOException) {
                        this.transportListener.onException((IOException)this.connectionFailure);
                    } else {
                        this.transportListener.onException(IOExceptionSupport.create(this.connectionFailure));
                    }
                }
                this.reconnectMutex.notifyAll();
                return false;
            }
        }
        if (!this.disposed) {
            LOG.debug((Object)("Waiting " + this.reconnectDelay + " ms before attempting connection. "));
            object = this.sleepMutex;
            synchronized (object) {
                try {
                    this.sleepMutex.wait(this.reconnectDelay);
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                }
            }
            if (this.useExponentialBackOff) {
                this.reconnectDelay = (long)((double)this.reconnectDelay * this.backOffMultiplier);
                if (this.reconnectDelay > this.maxReconnectDelay) {
                    this.reconnectDelay = this.maxReconnectDelay;
                }
            }
        }
        return !this.disposed;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final boolean buildBackups() {
        Object object = this.backupMutex;
        synchronized (object) {
            if (!this.disposed && this.backup && this.backups.size() < this.backupPoolSize) {
                List<URI> connectList = this.getConnectList();
                ArrayList<BackupTransport> disposedList = new ArrayList<BackupTransport>();
                for (BackupTransport bt : this.backups) {
                    if (!bt.isDisposed()) continue;
                    disposedList.add(bt);
                }
                this.backups.removeAll(disposedList);
                disposedList.clear();
                Iterator<URI> iter = connectList.iterator();
                while (iter.hasNext() && this.backups.size() < this.backupPoolSize) {
                    URI uri = iter.next();
                    if (this.connectedTransportURI == null || this.connectedTransportURI.equals(uri)) continue;
                    try {
                        SslContext.setCurrentSslContext(this.brokerSslContext);
                        BackupTransport bt = new BackupTransport(this);
                        bt.setUri(uri);
                        if (this.backups.contains(bt)) continue;
                        Transport t = TransportFactory.compositeConnect(uri);
                        t.setTransportListener(bt);
                        t.start();
                        bt.setTransport(t);
                        this.backups.add(bt);
                    }
                    catch (Exception e) {
                        LOG.debug((Object)"Failed to build backup ", (Throwable)e);
                    }
                    finally {
                        SslContext.setCurrentSslContext(null);
                    }
                }
            }
        }
        return false;
    }

    @Override
    public boolean isDisposed() {
        return this.disposed;
    }

    @Override
    public boolean isConnected() {
        return this.connected;
    }

    @Override
    public void reconnect(URI uri) throws IOException {
        this.add(true, new URI[]{uri});
    }

    @Override
    public boolean isReconnectSupported() {
        return this.reconnectSupported;
    }

    public void setReconnectSupported(boolean value) {
        this.reconnectSupported = value;
    }

    @Override
    public boolean isUpdateURIsSupported() {
        return this.updateURIsSupported;
    }

    public void setUpdateURIsSupported(boolean value) {
        this.updateURIsSupported = value;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateURIs(boolean rebalance, URI[] updatedURIs) throws IOException {
        if (this.isUpdateURIsSupported()) {
            ArrayList<URI> copy = new ArrayList<URI>(this.updated);
            ArrayList<URI> add = new ArrayList<URI>();
            if (updatedURIs != null && updatedURIs.length > 0) {
                HashSet<URI> set = new HashSet<URI>();
                for (int i = 0; i < updatedURIs.length; ++i) {
                    URI uri = updatedURIs[i];
                    if (uri == null) continue;
                    set.add(uri);
                }
                for (URI uri : set) {
                    if (copy.remove(uri)) continue;
                    add.add(uri);
                }
                Object object = this.reconnectMutex;
                synchronized (object) {
                    this.updated.clear();
                    this.updated.addAll(add);
                    for (URI uri : copy) {
                        this.uris.remove(uri);
                    }
                    this.add(rebalance, add.toArray(new URI[add.size()]));
                }
            }
        }
    }

    public String getUpdateURIsURL() {
        return this.updateURIsURL;
    }

    public void setUpdateURIsURL(String updateURIsURL) {
        this.updateURIsURL = updateURIsURL;
    }

    public boolean isRebalanceUpdateURIs() {
        return this.rebalanceUpdateURIs;
    }

    public void setRebalanceUpdateURIs(boolean rebalanceUpdateURIs) {
        this.rebalanceUpdateURIs = rebalanceUpdateURIs;
    }

    @Override
    public int getReceiveCounter() {
        Transport transport = this.connectedTransport.get();
        if (transport == null) {
            return 0;
        }
        return transport.getReceiveCounter();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void connectionInterruptProcessingComplete(ConnectionId connectionId) {
        Object object = this.reconnectMutex;
        synchronized (object) {
            this.stateTracker.connectionInterruptProcessingComplete(this, connectionId);
        }
    }

    public ConnectionStateTracker getStateTracker() {
        return this.stateTracker;
    }

    private boolean contains(URI newURI) {
        boolean result = false;
        try {
            for (URI uri : this.uris) {
                if (newURI.getPort() != uri.getPort()) continue;
                InetAddress newAddr = InetAddress.getByName(newURI.getHost());
                InetAddress addr = InetAddress.getByName(uri.getHost());
                if (!addr.equals(newAddr)) continue;
                result = true;
                break;
            }
        }
        catch (IOException e) {
            result = true;
            LOG.error((Object)("Failed to verify URI " + newURI + " already known: " + e));
        }
        return result;
    }

    private InputStreamReader getURLStream(String path) throws IOException {
        InputStreamReader result = null;
        URL url = null;
        try {
            url = new URL(path);
            result = new InputStreamReader(url.openStream());
        }
        catch (MalformedURLException e) {
            // empty catch block
        }
        if (result == null) {
            result = new FileReader(path);
        }
        return result;
    }
}

