/*
 * Decompiled with CFR 0.152.
 */
package eu.unicore.uas.metadata;

import de.fzj.unicore.xnjs.io.XnjsFile;
import org.apache.commons.io.FilenameUtils;

public class MetadataFile {
    private XnjsFile gridFile;
    public static final String MD_FILE_EXTENSION = "metadata";
    private static final String MD_NAME_FORMATER = ".%s.metadata";
    private MD_State mdStates;
    private boolean isAlreadyGenerated;

    public MetadataFile(XnjsFile gridFile) {
        this.gridFile = gridFile;
    }

    public MD_State getMdStates() {
        return this.mdStates;
    }

    public void setMdStates(MD_State mdStates) {
        this.mdStates = mdStates;
    }

    public XnjsFile getGridFile() {
        return this.gridFile;
    }

    public void setGridFile(XnjsFile gridFile) {
        this.gridFile = gridFile;
    }

    public boolean isAlreadyGenerated() {
        return this.isAlreadyGenerated;
    }

    public void setAlreadyGenerated(boolean isAlreadyGenerated) {
        this.isAlreadyGenerated = isAlreadyGenerated;
    }

    public String toString() {
        StringBuffer buf = new StringBuffer("-- Path: ").append(this.gridFile.getPath()).append("-- State:").append((Object)this.mdStates);
        return buf.toString();
    }

    public static boolean isMetadataFileName(String fileName) {
        if (fileName == null || fileName.trim().isEmpty()) {
            return false;
        }
        return FilenameUtils.isExtension((String)fileName, (String)MD_FILE_EXTENSION);
    }

    private static String transformFileName(String fileName) {
        return String.format(MD_NAME_FORMATER, fileName);
    }

    public static String getMetadatafileName(String resourceName) {
        String path = FilenameUtils.getFullPath((String)resourceName);
        String name = FilenameUtils.getName((String)resourceName);
        return path + MetadataFile.transformFileName(name);
    }

    public static String getResourceName(String metadataFilename) {
        String path = FilenameUtils.getFullPath((String)metadataFilename);
        String name = FilenameUtils.getBaseName((String)metadataFilename).substring(1);
        return path + name;
    }

    public static enum MD_State {
        CONSISTENT,
        RESOURCE_DELETED,
        INCONSISTENT,
        CHK_CONSISTENCE,
        NEW;

    }
}

