/*
 * Decompiled with CFR 0.152.
 */
package eu.unicore.uas.metadata;

import de.fzj.unicore.uas.client.MetadataClient;
import de.fzj.unicore.uas.metadata.ExtractionStatistics;
import de.fzj.unicore.uas.util.LogUtil;
import de.fzj.unicore.wsrflite.Kernel;
import de.fzj.unicore.xnjs.ems.ExecutionException;
import de.fzj.unicore.xnjs.io.IStorageAdapter;
import de.fzj.unicore.xnjs.io.XnjsFile;
import de.fzj.unicore.xnjs.io.XnjsFileWithACL;
import eu.unicore.uas.metadata.LuceneMetadataManager;
import eu.unicore.uas.metadata.MetadataFile;
import eu.unicore.uas.metadata.MetadataProperties;
import eu.unicore.util.Log;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.Callable;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.regex.Pattern;
import org.apache.log4j.Logger;
import org.apache.tika.exception.TikaException;
import org.apache.tika.metadata.Metadata;
import org.apache.tika.parser.ParseContext;
import org.apache.tika.parser.Parser;
import org.apache.tika.sax.BodyContentHandler;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;

public class MetadataCrawler
implements Callable<ExtractionStatistics> {
    private static final Logger LOG = LogUtil.getLogger((String)"unicore.services", MetadataCrawler.class);
    public static final long DEFAULTSCHEDULEDELAY = 1L;
    public static final String CRAWLER_CONTROL_FILENAME = ".unicore_metadata_control";
    private final String base;
    private final ContentHandler handler = new BodyContentHandler(-1);
    private final ParseContext parseContext = new ParseContext();
    private final Parser parser;
    private final int depthLimit;
    private final LuceneMetadataManager metadataManager;
    private final IStorageAdapter storage;
    private int currentLevel = 0;
    private AtomicInteger documentsProcessed = new AtomicInteger(0);
    private static NameFilter defaultIncludes = new NameFilter(){

        @Override
        public boolean accept(String name) {
            return true;
        }
    };
    private static NameFilter defaultExcludes = new NameFilter(){

        @Override
        public boolean accept(String name) {
            return name.endsWith(".svn") || name.endsWith(MetadataCrawler.CRAWLER_CONTROL_FILENAME) || name.endsWith(".unicore_rft.parts");
        }
    };

    public MetadataCrawler(LuceneMetadataManager metadataManager, IStorageAdapter storage, String base, int depthLimit, Kernel kernel) throws InstantiationException, IllegalAccessException {
        this.base = base;
        this.depthLimit = depthLimit;
        this.metadataManager = metadataManager;
        this.storage = storage;
        MetadataProperties cfg = (MetadataProperties)((Object)kernel.getAttribute(MetadataProperties.class));
        Class parserClass = cfg.getClassValue("parserClass", Parser.class);
        this.parser = (Parser)parserClass.newInstance();
    }

    @Override
    public ExtractionStatistics call() {
        String fullBase = this.base;
        LOG.info((Object)("STARTING crawler from " + fullBase + " crawling depth " + this.depthLimit));
        long start = System.currentTimeMillis();
        ArrayList<String> fileList = new ArrayList<String>();
        this.metadataManager.setAutoCommit(false);
        try {
            long startSingle = System.currentTimeMillis();
            this.getFiles(fullBase, fileList, this.depthLimit, this.createBaseFilter(fullBase));
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Getting file list (size " + fileList.size() + ") took " + (System.currentTimeMillis() - startSingle) + " ms."));
            }
            startSingle = System.currentTimeMillis();
            Map<String, MetadataFile.MD_State> list = MetadataCrawler.statusCheck(fileList);
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Checking file stati took " + (System.currentTimeMillis() - startSingle) + " ms."));
            }
            for (Map.Entry<String, MetadataFile.MD_State> entry : list.entrySet()) {
                startSingle = System.currentTimeMillis();
                String file = entry.getKey();
                switch (entry.getValue()) {
                    case CHK_CONSISTENCE: {
                        Map<String, String> metadata = Collections.emptyMap();
                        this.metadataManager.updateMetadata(file, metadata);
                        if (!LOG.isDebugEnabled()) break;
                        LOG.debug((Object)("Updated index for <" + file + "> took " + (System.currentTimeMillis() - startSingle) + " ms."));
                        break;
                    }
                    case NEW: {
                        try {
                            Map<String, String> extracted = this.extractMetadata(file);
                            this.metadataManager.createMetadata(file, extracted);
                            if (!LOG.isDebugEnabled()) break;
                            LOG.debug((Object)("Extracted metadata for <" + file + "> in " + (System.currentTimeMillis() - startSingle) + " ms."));
                        }
                        catch (TikaException te) {
                            LogUtil.logException((String)("Error while extracting metadata for <" + file + ">"), (Throwable)te, (Logger)LOG);
                        }
                        break;
                    }
                    case RESOURCE_DELETED: {
                        this.metadataManager.removeMetadata(file);
                        break;
                    }
                }
                this.documentsProcessed.incrementAndGet();
            }
        }
        catch (Exception ex) {
            LogUtil.logException((String)"Error while crawling the metadata", (Throwable)ex, (Logger)LOG);
        }
        try {
            long startCommit = System.currentTimeMillis();
            this.metadataManager.commit();
            this.metadataManager.setAutoCommit(true);
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Committing updated index took " + (System.currentTimeMillis() - startCommit) + " ms."));
            }
        }
        catch (Exception ex) {
            LogUtil.logException((String)"Error committing the metadata index.", (Throwable)ex, (Logger)LOG);
        }
        long time = System.currentTimeMillis() - start;
        LOG.info((Object)("EXITING crawler on " + fullBase + " time " + time + " ms."));
        ExtractionStatistics stats = new ExtractionStatistics();
        stats.setDocumentsProcessed(this.documentsProcessed.get());
        stats.setDurationMillis(time);
        return stats;
    }

    protected static Map<String, MetadataFile.MD_State> statusCheck(List<String> files) {
        HashMap<String, MetadataFile.MD_State> statuses = new HashMap<String, MetadataFile.MD_State>();
        for (String file : files) {
            String resource = null;
            if (MetadataFile.isMetadataFileName(file)) {
                resource = MetadataFile.getResourceName(file);
                if (statuses.containsKey(resource)) {
                    statuses.put(resource, MetadataFile.MD_State.CHK_CONSISTENCE);
                    continue;
                }
                statuses.put(resource, MetadataFile.MD_State.RESOURCE_DELETED);
                continue;
            }
            resource = file;
            if (statuses.containsKey(resource)) {
                statuses.put(resource, MetadataFile.MD_State.CHK_CONSISTENCE);
                continue;
            }
            statuses.put(resource, MetadataFile.MD_State.NEW);
        }
        return statuses;
    }

    private void getFiles(String directoryName, List<String> list, int level, NameFilter nameFilter) throws ExecutionException {
        ++this.currentLevel;
        if (this.isLevelExceeded()) {
            return;
        }
        XnjsFileWithACL x = this.storage.getProperties(directoryName);
        if (x != null) {
            if (x.isDirectory()) {
                XnjsFile[] gridFiles = this.storage.ls(directoryName);
                for (int j = 0; j < gridFiles.length; ++j) {
                    XnjsFile x2 = gridFiles[j];
                    String name = x2.getPath();
                    if (nameFilter == null || nameFilter.accept(name)) {
                        if (LOG.isDebugEnabled()) {
                            LOG.debug((Object)("Include: " + name));
                        }
                        if (x2.isDirectory()) {
                            this.getFiles(name, list, level, this.createChildFilter(nameFilter));
                            continue;
                        }
                        list.add(name);
                        continue;
                    }
                    if (!LOG.isDebugEnabled()) continue;
                    LOG.debug((Object)("Exclude: " + name));
                }
            } else {
                String resource = x.getPath();
                list.add(resource);
                XnjsFileWithACL md = this.storage.getProperties(MetadataFile.getMetadatafileName(resource));
                if (md != null) {
                    list.add(md.getPath());
                }
            }
        }
        --this.currentLevel;
    }

    private boolean isLevelExceeded() {
        return this.currentLevel > this.depthLimit;
    }

    private Map<String, String> extractMetadata(String file) throws ExecutionException, IOException, SAXException, TikaException {
        HashMap<String, String> ret = new HashMap<String, String>();
        Metadata meta = new Metadata();
        meta.add("resourceName", file);
        InputStream is = this.storage.getInputStream(file);
        this.parser.parse(is, this.handler, meta, this.parseContext);
        is.close();
        for (String key : meta.names()) {
            ret.put(key, meta.get(key));
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public NameFilter createBaseFilter(String baseDirectory) {
        block7: {
            try {
                XnjsFileWithACL f = this.storage.getProperties(CRAWLER_CONTROL_FILENAME);
                if (f == null) break block7;
                LOG.info((Object)("Found crawler control file " + f.getPath()));
                Properties p = new Properties();
                InputStream is = this.storage.getInputStream(f.getPath());
                try {
                    p.load(is);
                }
                finally {
                    is.close();
                }
                MetadataClient.CrawlerControl cc = MetadataClient.CrawlerControl.create((Properties)p);
                NameFilter i = cc.getIncludes() != null ? new PatternFilter(cc.getIncludes()) : defaultIncludes;
                NameFilter e = defaultExcludes;
                if (cc.getExcludes() != null) {
                    e = new PatternFilter(cc.getExcludes());
                    if (cc.isUseDefaultExcludes()) {
                        e = new ChainedFilter(e, defaultExcludes);
                    }
                }
                return new CombinedFilter(i, e);
            }
            catch (Exception ex) {
                String msg = Log.createFaultMessage((String)"Cannot create crawler include/exclude filter", (Throwable)ex);
                LOG.info((Object)msg);
            }
        }
        return new CombinedFilter(defaultIncludes, defaultExcludes);
    }

    public NameFilter createChildFilter(NameFilter parent) {
        return parent;
    }

    static class CombinedFilter
    implements NameFilter {
        private final NameFilter include;
        private final NameFilter exclude;

        public CombinedFilter(NameFilter include, NameFilter exclude) {
            this.include = include;
            this.exclude = exclude;
        }

        @Override
        public boolean accept(String name) {
            return this.include.accept(name) && !this.exclude.accept(name);
        }
    }

    static class ChainedFilter
    implements NameFilter {
        private final NameFilter n1;
        private final NameFilter n2;

        public ChainedFilter(NameFilter n1, NameFilter n2) {
            this.n1 = n1;
            this.n2 = n2;
        }

        @Override
        public boolean accept(String name) {
            return this.n1.accept(name) || this.n2.accept(name);
        }
    }

    static class PatternFilter
    implements NameFilter {
        private final Pattern[] patterns;

        public PatternFilter(String ... patterns) {
            this.patterns = this.makePatterns(patterns);
        }

        @Override
        public boolean accept(String name) {
            for (Pattern p : this.patterns) {
                if (!p.matcher(name).find()) continue;
                return true;
            }
            return false;
        }

        private Pattern[] makePatterns(String[] patterns) {
            Pattern[] result = new Pattern[patterns.length];
            for (int i = 0; i < patterns.length; ++i) {
                result[i] = Pattern.compile(patterns[i].replace(".", "\\.").replace("*", ".*").replace("?", "."));
            }
            return result;
        }
    }

    public static interface NameFilter {
        public boolean accept(String var1);
    }
}

