/*
 * Decompiled with CFR 0.152.
 */
package eu.unicore.uas.metadata;

import de.fzj.unicore.uas.metadata.ExtractionStatistics;
import de.fzj.unicore.uas.metadata.SearchResult;
import de.fzj.unicore.uas.metadata.StorageMetadataManager;
import de.fzj.unicore.uas.util.LogUtil;
import de.fzj.unicore.wsrflite.Kernel;
import de.fzj.unicore.xnjs.ems.ExecutionException;
import de.fzj.unicore.xnjs.io.IStorageAdapter;
import de.fzj.unicore.xnjs.io.XnjsFileWithACL;
import eu.unicore.uas.metadata.LuceneIndexer;
import eu.unicore.uas.metadata.MetadataCrawler;
import eu.unicore.uas.metadata.MetadataFile;
import eu.unicore.uas.metadata.MetadataProperties;
import eu.unicore.uas.metadata.utils.JSONAdapter;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import org.apache.log4j.Logger;

public class LuceneMetadataManager
implements StorageMetadataManager {
    public static final int DEFAULT_NUMBER_OF_MATCHES = 200;
    private static final int BUFFERSIZE = 1024;
    private static final Logger LOG = LogUtil.getLogger((String)"unicore.services", LuceneMetadataManager.class);
    private static final JSONAdapter FORMATER = new JSONAdapter();
    private IStorageAdapter storage;
    private LuceneIndexer indexer;
    private Kernel kernel;
    private boolean autoCommit = true;

    public LuceneMetadataManager(Kernel kernel) {
        this.kernel = kernel;
    }

    public void createMetadata(String resourceName, Map<String, String> lstMetadata) throws IOException {
        this.isStorageReady();
        this.isProperResource(resourceName);
        LuceneMetadataManager.isProperMetadata(lstMetadata);
        String fileName = MetadataFile.getMetadatafileName(resourceName);
        HashMap<String, String> copy = new HashMap<String, String>(lstMetadata);
        copy.put("resourceName", resourceName);
        byte[] metadata = FORMATER.convert(copy);
        try {
            this.writeData(fileName, metadata);
            this.indexer.createMetadata(resourceName, copy, new String(metadata));
            if (this.autoCommit) {
                this.commit();
            }
        }
        catch (IOException ex) {
            throw new IOException("Unable to create metadata for resource <" + resourceName + ">", ex);
        }
    }

    public void updateMetadata(String resourceName, Map<String, String> lstMetadata) throws IOException {
        this.isStorageReady();
        this.isProperResource(resourceName);
        if (lstMetadata == null) {
            throw new IllegalArgumentException("Metadata cannot be null");
        }
        String fileName = MetadataFile.getMetadatafileName(resourceName);
        try {
            Map<String, String> original = this.getMetadataByName(resourceName);
            Map<String, String> merged = LuceneMetadataManager.mergeMetadata(original, lstMetadata);
            merged.put("resourceName", resourceName);
            byte[] metadata = FORMATER.convert(merged);
            if (!lstMetadata.isEmpty()) {
                this.writeData(fileName, metadata);
            }
            this.indexer.updateMetadata(resourceName, merged, new String(metadata));
            if (this.autoCommit) {
                this.commit();
            }
        }
        catch (IOException ex) {
            throw new IOException("Unable to update metadata for resource <" + resourceName + ">", ex);
        }
    }

    public void removeMetadata(String resourceName) throws IOException {
        this.isStorageReady();
        if (!LuceneMetadataManager.isProperResourceName(resourceName)) {
            throw new IllegalArgumentException("Resource <" + resourceName + " is not proper resource name");
        }
        try {
            if (this.fileExists(MetadataFile.getMetadatafileName(resourceName))) {
                this.storage.rm(MetadataFile.getMetadatafileName(resourceName));
            }
            this.indexer.removeMetadata(resourceName);
            if (this.autoCommit) {
                this.commit();
            }
        }
        catch (Exception ex) {
            throw new IOException("Unable to remove metadata for <" + resourceName + ">", ex);
        }
    }

    public void renameResource(String source, String target) throws IOException {
        this.isStorageReady();
        this.isProperResource(source);
        if (!LuceneMetadataManager.isProperResourceName(target)) {
            throw new IllegalArgumentException("Resource <" + target + "> is not a proper resource name");
        }
        String sourceFileName = MetadataFile.getMetadatafileName(source);
        String targetFileName = MetadataFile.getMetadatafileName(target);
        if (this.fileExists(targetFileName)) {
            try {
                this.storage.rm(targetFileName);
            }
            catch (ExecutionException ex) {
                throw new IllegalArgumentException("Target resource metadata file <" + targetFileName + "> exists and cannot be overwritten", ex);
            }
        }
        try {
            this.storage.rename(sourceFileName, targetFileName);
            this.indexer.moveMetadata(source, target);
            if (this.autoCommit) {
                this.commit();
            }
        }
        catch (Exception ex) {
            throw new IOException(String.format("Unable to move metadata from %s to %s", source, target), ex);
        }
    }

    public void copyResourceMetadata(String source, String target) throws IOException {
        this.isStorageReady();
        this.isProperResource(source);
        if (!LuceneMetadataManager.isProperResourceName(target)) {
            throw new IllegalArgumentException("Resource <" + target + "> is not a proper resource name");
        }
        try {
            Map<String, String> metadata = this.getMetadataByName(source);
            this.createMetadata(target, metadata);
        }
        catch (IOException ex) {
            throw new IOException(String.format("Unable to copy metadata from %s to %s", source, target), ex);
        }
    }

    public Future<ExtractionStatistics> startAutoMetadataExtraction(String directory, int depthLimit) throws InstantiationException, IllegalAccessException {
        this.isStorageReady();
        MetadataCrawler metaCrawler = new MetadataCrawler(this, this.storage, directory, depthLimit, this.kernel);
        ScheduledFuture<ExtractionStatistics> future = this.kernel.getContainerProperties().getThreadingServices().getScheduledExecutorService().schedule(metaCrawler, 1L, TimeUnit.SECONDS);
        return future;
    }

    public List<SearchResult> searchMetadataByContent(String searchString, boolean isAdvancedSearch) {
        this.isStorageReady();
        List<SearchResult> lstMetafiles = null;
        ArrayList<String> searchTokens = new ArrayList<String>();
        try {
            if (isAdvancedSearch) {
                searchTokens.add(searchString);
            } else {
                StringTokenizer strTokens = new StringTokenizer(searchString, " ");
                while (strTokens.hasMoreTokens()) {
                    searchTokens.add(strTokens.nextToken());
                }
            }
            lstMetafiles = this.indexer.search(searchTokens.toArray(new String[searchTokens.size() - 1]), 200);
        }
        catch (Exception e) {
            LogUtil.logException((String)"Error searching metadata: ", (Throwable)e, (Logger)LOG);
        }
        return lstMetafiles;
    }

    public Map<String, String> getMetadataByName(String resourceName) throws IOException {
        this.isStorageReady();
        this.isProperResource(resourceName);
        Map<String, String> metadata = new HashMap<String, String>();
        String fileName = MetadataFile.getMetadatafileName(resourceName);
        if (!this.fileExists(fileName)) {
            return metadata;
        }
        byte[] data = this.readFully(fileName);
        try {
            metadata = FORMATER.convert(data);
        }
        catch (Exception ex) {
            throw new IOException("Unkow data format of metadata read from file: <" + fileName + "> ", ex);
        }
        return metadata;
    }

    public synchronized void setStorageAdapter(IStorageAdapter storage, String storageID) {
        if (storage == null) {
            throw new IllegalStateException("StorageAdapter cannot be null");
        }
        this.storage = storage;
        String id = storageID != null ? storageID : storage.getFileSystemIdentifier();
        MetadataProperties cfg = (MetadataProperties)((Object)this.kernel.getAttribute(MetadataProperties.class));
        this.indexer = LuceneIndexer.get(id, cfg.getValue("luceneDirectory"));
    }

    public void commit() throws IOException {
        this.indexer.commit();
    }

    public void setAutoCommit(boolean autocommit) {
        this.autoCommit = autocommit;
    }

    protected void writeData(String fileName, byte[] metadata) throws IOException {
        if (this.storage == null) {
            throw new IllegalStateException("Storage cannot be null");
        }
        if (fileName == null || fileName.trim().isEmpty()) {
            throw new IllegalArgumentException("File name cannot be null nor empty");
        }
        if (metadata == null || metadata.length == 0) {
            throw new IllegalArgumentException("Metadata cannot be null nor empty");
        }
        try {
            OutputStream os = this.storage.getOutputStream(fileName, false);
            os.write(metadata);
            os.flush();
            os.close();
        }
        catch (ExecutionException ex) {
            throw new IOException("Unable to wirte metadata", ex);
        }
    }

    protected byte[] readFully(String fileName) throws IOException {
        if (this.storage == null) {
            throw new IllegalStateException("Storage cannot be null");
        }
        if (fileName == null || fileName.trim().isEmpty()) {
            throw new IllegalArgumentException("Filename cannot be null nor empty");
        }
        InputStream is = null;
        try {
            is = this.storage.getInputStream(fileName);
        }
        catch (ExecutionException ex) {
            throw new IOException(String.format("Unable to open file %s to read metadata", fileName), ex);
        }
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        byte[] buf = new byte[1024];
        int r = 0;
        while ((r = is.read(buf)) >= 0) {
            bos.write(buf, 0, r);
        }
        is.close();
        return bos.toByteArray();
    }

    public static Map<String, String> mergeMetadata(Map<String, String> oldData, Map<String, String> newData) {
        if (oldData == null || newData == null) {
            throw new IllegalArgumentException("Metadata to merge cannot be null");
        }
        HashMap<String, String> map = new HashMap<String, String>();
        map.putAll(oldData);
        map.putAll(newData);
        return map;
    }

    private static boolean isProperResourceName(String resourceName) {
        if (resourceName == null || resourceName.trim().isEmpty()) {
            return false;
        }
        return !MetadataFile.isMetadataFileName(resourceName);
    }

    public boolean isProperResource(String resourceName) {
        if (resourceName == null || resourceName.trim().isEmpty()) {
            throw new IllegalArgumentException("Resource name cannot be empty or null.");
        }
        if (MetadataFile.isMetadataFileName(resourceName)) {
            throw new IllegalArgumentException("Resource <" + resourceName + "> is not proper resource name (it is a metadata file)");
        }
        if (!this.fileExists(resourceName)) {
            throw new IllegalArgumentException("Resource <" + resourceName + "> does not exist");
        }
        return true;
    }

    private synchronized boolean isStorageReady() {
        if (this.storage == null || this.indexer == null) {
            throw new IllegalStateException("This metadamanager does not have storage and/or indexer. Unable to index resource");
        }
        return true;
    }

    private static void isProperMetadata(Map<String, String> lstMetadata) {
        if (lstMetadata == null || lstMetadata.isEmpty()) {
            throw new IllegalArgumentException("Metadata cannot be null or empty");
        }
    }

    private boolean fileExists(String resourceName) {
        try {
            XnjsFileWithACL properties = this.storage.getProperties(resourceName);
            if (properties == null) {
                return false;
            }
        }
        catch (ExecutionException ex) {
            return false;
        }
        return true;
    }
}

