/*
 * Decompiled with CFR 0.152.
 */
package eu.unicore.emi.data;

import de.fzj.unicore.xnjs.ems.ExecutionException;
import de.fzj.unicore.xnjs.io.ChangeACL;
import de.fzj.unicore.xnjs.io.ChangePermissions;
import de.fzj.unicore.xnjs.io.FileFilter;
import de.fzj.unicore.xnjs.io.IStorageAdapter;
import de.fzj.unicore.xnjs.io.Permissions;
import de.fzj.unicore.xnjs.io.XnjsFile;
import de.fzj.unicore.xnjs.io.XnjsFileImpl;
import de.fzj.unicore.xnjs.io.XnjsFileWithACL;
import de.fzj.unicore.xnjs.io.XnjsStorageInfo;
import eu.unicore.emi.data.SRMStorageAdapter;
import eu.unicore.security.Client;
import fr.maatg.glite.dm.CNSConnector;
import fr.maatg.glite.dm.connection.ReceiveException;
import fr.maatg.glite.dm.ns.CNSConnection;
import fr.maatg.glite.dm.ns.CNSFileReaddir;
import fr.maatg.glite.dm.ns.CNSReplica;
import fr.maatg.glite.dm.ns.CNSStatusesException;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Calendar;
import java.util.Collection;
import java.util.Iterator;
import org.globus.gsi.GlobusCredential;
import org.globus.gsi.GlobusCredentialException;
import org.globus.gsi.gssapi.GlobusGSSCredentialImpl;
import org.gridforum.jgss.ExtendedGSSCredential;
import org.ietf.jgss.GSSCredential;
import org.ietf.jgss.GSSException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LFCStorageAdapter
implements IStorageAdapter {
    private final Client client;
    private CNSConnector lfcConnector = null;
    private CNSConnection lfcConnection = null;
    private ExtendedGSSCredential credential = null;
    private final int lfcPort;
    private final String lfcHost;
    private String savedProxy = null;
    private String storageRoot = "/";
    private static Logger logger = LoggerFactory.getLogger(LFCStorageAdapter.class);

    public LFCStorageAdapter(Client client, String lfcHost, int lfcPort) {
        this.client = client;
        this.lfcHost = lfcHost;
        this.lfcPort = lfcPort;
    }

    public LFCStorageAdapter(Client client, String lfcHost, int lfcPort, String savedProxy) {
        this(client, lfcHost, lfcPort);
        this.savedProxy = savedProxy;
    }

    public void sessionStart(String lfcHost, int lfcPort) throws ExecutionException {
        block25: {
            String proxy = (String)this.client.getExtraAttributes().get("Proxy");
            byte[] ba = null;
            if (proxy == null) {
                if (this.savedProxy != null) {
                    proxy = this.savedProxy;
                } else {
                    FileInputStream fis = null;
                    ba = new byte[(int)new File("/tmp/x509up_u1000").length()];
                    try {
                        try {
                            fis = new FileInputStream("/tmp/x509up_u1000");
                            fis.read(ba);
                            if (fis != null) {
                                fis.close();
                            }
                        }
                        catch (FileNotFoundException e) {
                            logger.error("", (Throwable)e);
                            throw new ExecutionException((Throwable)e);
                        }
                        catch (IOException e) {
                            logger.error("", (Throwable)e);
                            throw new ExecutionException((Throwable)e);
                        }
                    }
                    finally {
                        try {
                            if (fis != null) {
                                fis.close();
                            }
                        }
                        catch (IOException iOException) {}
                    }
                    if (new String(ba).length() <= 0) {
                        throw new ExecutionException("No proxy cert available! Can't execute LFC");
                    }
                }
            }
            try {
                if (proxy != null) {
                    this.credential = new GlobusGSSCredentialImpl(new GlobusCredential((InputStream)new ByteArrayInputStream(proxy.getBytes())), 0);
                    break block25;
                }
                if (ba != null) {
                    this.credential = new GlobusGSSCredentialImpl(new GlobusCredential((InputStream)new ByteArrayInputStream(ba)), 0);
                    break block25;
                }
                throw new ExecutionException("no credential available");
            }
            catch (GSSException e) {
                logger.error("", (Throwable)e);
                throw new ExecutionException((Throwable)e);
            }
            catch (GlobusCredentialException e) {
                logger.error("", (Throwable)e);
                throw new ExecutionException((Throwable)e);
            }
        }
        try {
            this.lfcConnector = CNSConnector.getInstance((String)lfcHost, (int)lfcPort, null, (GSSCredential)this.credential);
            this.lfcConnection = this.lfcConnector.getNewConnection();
        }
        catch (ReceiveException e) {
            logger.error("", (Throwable)e);
            throw new ExecutionException((Throwable)e);
        }
        catch (IOException e) {
            logger.error("", (Throwable)e);
            throw new ExecutionException((Throwable)e);
        }
    }

    public void sessionEnd() {
        try {
            this.lfcConnection.close();
        }
        catch (IOException e) {
            logger.error("", (Throwable)e);
        }
        try {
            this.credential.dispose();
        }
        catch (GSSException e) {
            logger.error("", (Throwable)e);
        }
    }

    public XnjsFile[] ls(String base, int offset, int limit, boolean filter) throws ExecutionException {
        logger.debug("offset: " + offset + ", limit: " + limit + ", filter: " + filter);
        return this.ls(base);
    }

    public XnjsFile[] ls(String lfn) throws ExecutionException {
        Collection coll;
        block9: {
            if (!lfn.startsWith(this.storageRoot)) {
                lfn = String.valueOf(this.storageRoot) + lfn;
            }
            logger.debug("ls " + lfn);
            this.sessionStart(this.lfcHost, this.lfcPort);
            coll = null;
            try {
                coll = this.lfcConnector.list(lfn, false);
            }
            catch (IOException e) {
                logger.error("ls failed", (Throwable)e);
                this.sessionEnd();
                break block9;
            }
            catch (ReceiveException e) {
                try {
                    logger.error("ls failed", (Throwable)e);
                    break block9;
                }
                catch (Throwable throwable) {
                    throw throwable;
                }
                finally {
                    this.sessionEnd();
                }
            }
            this.sessionEnd();
        }
        XnjsFileImpl[] xnjsFiles = new XnjsFileImpl[coll.size()];
        Iterator it = coll.iterator();
        int i = 0;
        while (it.hasNext()) {
            xnjsFiles[i] = new XnjsFileImpl();
            CNSFileReaddir cnsFile = (CNSFileReaddir)it.next();
            xnjsFiles[i].setPath(cnsFile.getPath());
            xnjsFiles[i].setSize(cnsFile.getFileSize());
            xnjsFiles[i].setDirectory(cnsFile.isDirectory());
            Calendar cal = Calendar.getInstance();
            cal.setTimeInMillis(cnsFile.lastAccessTime());
            xnjsFiles[i].setLastModified(cal);
            short mode = cnsFile.getFileMode();
            String unixPermissions = "";
            unixPermissions = String.valueOf(unixPermissions) + ((mode & 0x100) > 0 ? "r" : "-");
            unixPermissions = String.valueOf(unixPermissions) + ((mode & 0x80) > 0 ? "w" : "-");
            unixPermissions = String.valueOf(unixPermissions) + ((mode & 0x40) > 0 ? "x" : "-");
            unixPermissions = String.valueOf(unixPermissions) + ((mode & 0x20) > 0 ? "r" : "-");
            unixPermissions = String.valueOf(unixPermissions) + ((mode & 0x10) > 0 ? "w" : "-");
            unixPermissions = String.valueOf(unixPermissions) + ((mode & 8) > 0 ? "x" : "-");
            unixPermissions = String.valueOf(unixPermissions) + ((mode & 4) > 0 ? "r" : "-");
            unixPermissions = String.valueOf(unixPermissions) + ((mode & 2) > 0 ? "w" : "-");
            unixPermissions = String.valueOf(unixPermissions) + ((mode & 1) > 0 ? "x" : "-");
            xnjsFiles[i].setUNIXPermissions(unixPermissions);
            Permissions permissions = new Permissions();
            permissions.setReadable((mode & 0x100) > 0);
            permissions.setWritable((mode & 0x80) > 0);
            permissions.setExecutable((mode & 0x40) > 0);
            xnjsFiles[i].setPermissions(permissions);
            ++i;
        }
        return xnjsFiles;
    }

    public void mkdir(String lfn) throws ExecutionException {
        if (!lfn.startsWith(this.storageRoot)) {
            lfn = String.valueOf(this.storageRoot) + lfn;
        }
        if ("/".equals(lfn)) {
            return;
        }
        logger.debug("mkdir " + lfn);
        this.sessionStart(this.lfcHost, this.lfcPort);
        try {
            this.lfcConnector.mkdir(lfn, 509);
        }
        catch (IOException e) {
            logger.error("", (Throwable)e);
            throw new ExecutionException((Throwable)e);
        }
        catch (ReceiveException e) {
            logger.error("", (Throwable)e);
            throw new ExecutionException((Throwable)e);
        }
        this.sessionEnd();
    }

    public void rename(String source, String target) throws ExecutionException {
        if (!source.startsWith(this.storageRoot)) {
            source = String.valueOf(this.storageRoot) + source;
        }
        if (!target.startsWith(this.storageRoot)) {
            target = String.valueOf(this.storageRoot) + target;
        }
        logger.debug("rename " + source + " " + target);
        this.sessionStart(this.lfcHost, this.lfcPort);
        try {
            this.lfcConnector.rename(source, target);
        }
        catch (IOException e) {
            logger.error("", (Throwable)e);
            throw new ExecutionException((Throwable)e);
        }
        catch (ReceiveException e) {
            logger.error("", (Throwable)e);
            throw new ExecutionException((Throwable)e);
        }
        this.sessionEnd();
    }

    public void rmdir(String lfn) throws ExecutionException {
        if (!lfn.startsWith(this.storageRoot)) {
            lfn = String.valueOf(this.storageRoot) + lfn;
        }
        if ("/".equals(lfn)) {
            return;
        }
        logger.debug("rmdir " + lfn);
        this.sessionStart(this.lfcHost, this.lfcPort);
        try {
            this.lfcConnector.deleteDir(lfn);
        }
        catch (IOException e) {
            logger.error("", (Throwable)e);
            throw new ExecutionException((Throwable)e);
        }
        catch (ReceiveException e) {
            logger.error("", (Throwable)e);
            throw new ExecutionException((Throwable)e);
        }
        this.sessionEnd();
    }

    public void rm(String lfn) throws ExecutionException {
        if (!lfn.startsWith(this.storageRoot)) {
            lfn = String.valueOf(this.storageRoot) + lfn;
        }
        logger.debug("rm " + lfn);
        this.sessionStart(this.lfcHost, this.lfcPort);
        String[] lfns = new String[]{lfn};
        try {
            this.lfcConnector.deleteFilesByName(lfns, true);
        }
        catch (IOException e) {
            logger.error("", (Throwable)e);
            throw new ExecutionException((Throwable)e);
        }
        catch (ReceiveException e) {
            logger.error("", (Throwable)e);
            throw new ExecutionException((Throwable)e);
        }
        catch (CNSStatusesException e) {
            logger.error("", (Throwable)e);
            throw new ExecutionException((Throwable)e);
        }
        this.sessionEnd();
    }

    public InputStream getInputStream(String lfn) throws ExecutionException {
        if (!lfn.startsWith(this.storageRoot)) {
            lfn = String.valueOf(this.storageRoot) + lfn;
        }
        logger.debug("getInputStream " + lfn);
        this.sessionStart(this.lfcHost, this.lfcPort);
        Collection coll = null;
        try {
            coll = this.lfcConnector.listReplicas(lfn, null);
        }
        catch (IOException e) {
            e.printStackTrace();
            throw new ExecutionException((Throwable)e);
        }
        catch (ReceiveException e) {
            e.printStackTrace();
            throw new ExecutionException((Throwable)e);
        }
        Iterator it = coll.iterator();
        InputStream is = null;
        ExecutionException ex = null;
        while (it.hasNext()) {
            CNSReplica replica = (CNSReplica)it.next();
            if (!replica.getSfn().startsWith("srm://")) continue;
            try {
                is = SRMStorageAdapter.getInputStream((Client)this.client, (String)replica.getSfn());
            }
            catch (ExecutionException e) {
                logger.error("fc get: get replica failed", (Throwable)e);
                is = null;
                ex = e;
            }
        }
        if (is == null) {
            if (ex == null) {
                throw new ExecutionException("get lfc replica failed: no srm replica available");
            }
            throw new ExecutionException("get lfc replica failed: get srm file failed", ex);
        }
        return is;
    }

    public void chmod(String file, Permissions perm) throws ExecutionException {
        throw new ExecutionException("lfc chmod not implemented");
    }

    public void cp(String source, String target) throws ExecutionException {
        throw new ExecutionException("lfc copy not implemented");
    }

    public XnjsFile[] find(String base, FileFilter options, int offset, int limit) throws ExecutionException {
        throw new ExecutionException("lfc find not implemented");
    }

    public XnjsStorageInfo getAvailableDiskSpace(String path) {
        XnjsStorageInfo info = new XnjsStorageInfo();
        info.setFreeSpace(-1L);
        info.setTotalSpace(-1L);
        info.setUsableSpace(-1L);
        return info;
    }

    public String getFileSeparator() throws ExecutionException {
        return "/";
    }

    public String getFileSystemIdentifier() {
        return this.lfcHost;
    }

    public OutputStream getOutputStream(String resource) throws ExecutionException {
        throw new ExecutionException("lfc put not supported");
    }

    public OutputStream getOutputStream(String resource, boolean append) throws ExecutionException {
        throw new ExecutionException("lfc put not supported");
    }

    public void chgrp(String arg0, String arg1, boolean arg2) throws ExecutionException {
        throw new ExecutionException("not implemented yet");
    }

    public void chmod2(String arg0, ChangePermissions[] arg1, boolean arg2) throws ExecutionException {
        throw new ExecutionException("not implemented yet");
    }

    public String getStorageRoot() {
        return this.storageRoot;
    }

    public boolean isACLSupported(String arg0) throws ExecutionException {
        return false;
    }

    public void setStorageRoot(String root) {
        this.storageRoot = root;
    }

    public void setUmask(String arg0) {
    }

    public void setfacl(String arg0, boolean arg1, ChangeACL[] arg2, boolean arg3) throws ExecutionException {
        throw new ExecutionException("not implemented yet");
    }

    public XnjsFileWithACL getProperties(String arg0) throws ExecutionException {
        logger.debug("getProperties " + arg0);
        return new XnjsFileImpl();
    }

    public String getUmask() {
        return "77";
    }
}

