/*
 * Decompiled with CFR 0.152.
 */
package eu.unicore.emi.data;

import de.fzj.unicore.uas.impl.sms.SMSBaseImpl;
import de.fzj.unicore.uas.impl.sms.StorageDescription;
import de.fzj.unicore.uas.xnjs.StorageAdapterFactory;
import de.fzj.unicore.wsrflite.persistence.Persist;
import de.fzj.unicore.xnjs.io.IStorageAdapter;
import eu.unicore.emi.data.LFCStorageAdapter;
import eu.unicore.emi.data.LFCStorageAdapterFactory;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LFCStorage
extends SMSBaseImpl {
    Logger logger = LoggerFactory.getLogger(LFCStorage.class);
    public static final String LFC_HOST = "lfc.host";
    public static final String LFC_PORT = "lfc.port";
    @Persist
    private String lfcHost;
    @Persist
    private String lfcPort;
    @Persist
    private String savedProxy;

    protected String getStorageRoot() {
        return "/";
    }

    public void initialise(String name, Map<String, Object> params) throws Exception {
        super.initialise(name, params);
        StorageDescription sd = (StorageDescription)params.get(SMSBaseImpl.INIT_STORAGE_DESCRIPTION);
        this.lfcHost = (String)sd.getAdditionalProperties().get(LFC_HOST);
        this.lfcPort = (String)sd.getAdditionalProperties().get(LFC_PORT);
        if (this.getClient().getExtraAttributes().containsKey("Proxy")) {
            this.savedProxy = (String)this.getClient().getExtraAttributes().get("Proxy");
        }
        this.logger.info("Connecting to LFC at " + this.lfcHost + ":" + this.lfcPort);
    }

    public IStorageAdapter getStorageAdapter() {
        if (this.savedProxy == null) {
            return new LFCStorageAdapter(this.getClient(), this.getLFCHost(), this.getLFCPort());
        }
        return new LFCStorageAdapter(this.getClient(), this.getLFCHost(), this.getLFCPort(), this.savedProxy);
    }

    protected StorageAdapterFactory getStorageAdapterFactory() {
        return new LFCStorageAdapterFactory(this.getLFCHost(), this.getLFCPort());
    }

    public String getLFCHost() {
        if (this.lfcHost == null) {
            this.lfcHost = this.kernel.getContainerProperties().getRawProperties().getProperty(LFC_HOST, "localhost");
            this.logger.debug("Using default LFC host " + this.lfcHost);
        }
        return this.lfcHost;
    }

    public int getLFCPort() {
        if (this.lfcPort == null) {
            this.lfcPort = this.kernel.getContainerProperties().getRawProperties().getProperty(LFC_PORT, "5010");
            this.logger.debug("Using default LFC port " + this.lfcPort);
        }
        return Integer.parseInt(this.lfcPort);
    }

    public String getSavedProxy() {
        return this.savedProxy;
    }
}

