/*
 * Decompiled with CFR 0.152.
 */
package com.intel.gpe.gridbeans;

import com.intel.gpe.gridbeans.GridBeanService;
import de.fzj.unicore.uas.UASProperties;
import de.fzj.unicore.uas.util.LogUtil;
import de.fzj.unicore.wsrflite.ContainerProperties;
import de.fzj.unicore.wsrflite.Kernel;
import de.fzj.unicore.wsrflite.security.IContainerSecurityConfiguration;
import de.fzj.unicore.wsrflite.utils.WSServerUtilities;
import de.fzj.unicore.wsrflite.xfire.XFireKernel;
import de.fzj.unicore.wsrflite.xmlbeans.registry.RegistryHandler;
import java.io.File;
import java.io.IOException;
import javax.xml.namespace.QName;
import org.apache.log4j.Logger;
import org.w3.x2005.x08.addressing.EndpointReferenceType;

public class PublishGridBeanService
implements Runnable {
    private static final Logger logger = LogUtil.getLogger((String)"unicore.services", PublishGridBeanService.class);
    private final Kernel kernel;

    public PublishGridBeanService(Kernel kernel) {
        this.kernel = kernel;
    }

    @Override
    public void run() {
        this.publish();
    }

    protected void publish() {
        try {
            if (XFireKernel.get((Kernel)this.kernel).getService(GridBeanService.ServiceName) == null) {
                logger.error((Object)"GridBean service is not deployed, please check your configuration.");
                return;
            }
            this.checkCreateDirectory();
            RegistryHandler rh = (RegistryHandler)this.kernel.getAttribute(RegistryHandler.class);
            rh.getRegistryClient().addRegistryEntry(this.getEPR());
            logger.info((Object)("Added registry entry for " + GridBeanService.ServiceName));
        }
        catch (Exception e) {
            LogUtil.logException((String)"Could not publish to registry", (Throwable)e, (Logger)logger);
        }
    }

    protected synchronized EndpointReferenceType getEPR() {
        EndpointReferenceType myEPR = WSServerUtilities.newEPR((IContainerSecurityConfiguration)this.kernel.getContainerSecurityConfiguration());
        myEPR.addNewAddress().setStringValue(WSServerUtilities.makeAddress((String)GridBeanService.ServiceName, (ContainerProperties)this.kernel.getContainerProperties()));
        WSServerUtilities.addPortType((EndpointReferenceType)myEPR, (QName)GridBeanService.PORT_TYPE);
        return myEPR;
    }

    protected void checkCreateDirectory() throws IOException {
        String dir = this.getGridBeanPath();
        if (dir == null) {
            throw new IOException("Gridbean directory not defined! please define it using the <coreServices.gridbean.directory> property.");
        }
        File file = new File(dir);
        if (!file.exists()) {
            boolean created = file.mkdirs();
            if (!created) {
                throw new IOException("Could not create Gridbean directory: <" + dir + ">");
            }
        } else if (!file.isDirectory()) {
            throw new IOException("Not a valid Gridbean directory: <" + dir + ">");
        }
    }

    protected String getGridBeanPath() {
        UASProperties uasProperties = (UASProperties)this.kernel.getAttribute(UASProperties.class);
        String res = uasProperties.getValue("gridbean.directory");
        return res;
    }
}

