/*
 * Decompiled with CFR 0.152.
 */
package com.intel.gpe.gridbeans;

import com.intel.gpe.gridbeans.ElementUtil;
import com.intel.gpe.gridbeans.GetGridBeanDocument;
import com.intel.gpe.gridbeans.GetGridBeanInfoDocument;
import com.intel.gpe.gridbeans.GetGridBeanInfoResponseDocument;
import com.intel.gpe.gridbeans.GetGridBeanResponseDocument;
import com.intel.gpe.gridbeans.GridBeanDescriptionType;
import com.intel.gpe.gridbeans.GridBeanInfoNotGotFaultType;
import com.intel.gpe.gridbeans.GridBeanNotGotFaultType;
import com.intel.gpe.gridbeans.GridBeanService;
import com.intel.gpe.gridbeans.GridBeansNotListedFaultType;
import com.intel.gpe.gridbeans.ListGridBeansDocument;
import com.intel.gpe.gridbeans.ListGridBeansResponseDocument;
import de.fzj.unicore.uas.UASProperties;
import de.fzj.unicore.uas.util.LogUtil;
import de.fzj.unicore.wsrflite.Kernel;
import de.fzj.unicore.wsrflite.KernelInjectable;
import de.fzj.unicore.wsrflite.xmlbeans.BaseFault;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.jar.JarFile;
import java.util.zip.ZipEntry;
import org.apache.log4j.Logger;
import org.jdom.adapters.XercesDOMAdapter;
import org.oasisOpen.docs.wsrf.bf2.BaseFaultType;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class GridBeanServiceImpl
implements GridBeanService,
KernelInjectable {
    private static final Logger logger = LogUtil.getLogger((String)"unicore.services", GridBeanServiceImpl.class);
    private Kernel kernel;

    public void setKernel(Kernel kernel) {
        this.kernel = kernel;
    }

    public GridBeanDescriptionType getGridBeanDescription(File file) throws Exception {
        Element element = this.getDescriptionElement(file);
        GridBeanDescriptionType gridBeanDescription = GridBeanDescriptionType.Factory.newInstance();
        gridBeanDescription.setSize((int)file.length());
        gridBeanDescription.setName(ElementUtil.getChildValueString(element, "http://gpe.intel.com/gridbeans", "Name", ""));
        gridBeanDescription.setAuthor(ElementUtil.getChildValueString(element, "http://gpe.intel.com/gridbeans", "Author", ""));
        gridBeanDescription.setVersion(ElementUtil.getChildValueFloat(element, "http://gpe.intel.com/gridbeans", "Version", Float.valueOf(1.0f)).floatValue());
        gridBeanDescription.setApplication(ElementUtil.getChildValueString(element, "http://gpe.intel.com/gridbeans", "Application", ""));
        gridBeanDescription.setDescription(ElementUtil.getChildValueString(element, "http://gpe.intel.com/gridbeans", "Description", ""));
        gridBeanDescription.setPluginVersion(ElementUtil.getChildValue(element, "http://gpe.intel.com/gridbeans", "PluginVersion", 1));
        return gridBeanDescription;
    }

    @Override
    public GetGridBeanResponseDocument GetGridBean(GetGridBeanDocument request) throws BaseFault {
        String gridBeanPath = this.getGridBeanPath();
        if (gridBeanPath == null) {
            String msg = "GridBean directory is not set";
            logger.warn((Object)msg);
            GridBeanNotGotFaultType fault = GridBeanNotGotFaultType.Factory.newInstance();
            fault.setTimestamp(Calendar.getInstance());
            fault.addNewDescription().setStringValue(msg);
            throw new BaseFault(msg, (BaseFaultType)fault);
        }
        File gridBeanDir = new File(gridBeanPath);
        if (!gridBeanDir.exists() || !gridBeanDir.isDirectory()) {
            String msg = "GridBean directory does not exist (" + gridBeanPath + ")";
            logger.error((Object)msg);
            GridBeanNotGotFaultType fault = GridBeanNotGotFaultType.Factory.newInstance();
            fault.setTimestamp(Calendar.getInstance());
            fault.addNewDescription().setStringValue(msg);
            throw new BaseFault(msg, (BaseFaultType)fault);
        }
        String name = request.getGetGridBean().getName();
        File file = new File(gridBeanDir, name + "GridBean.jar");
        if (!file.exists()) {
            String msg = "GridBean does not exist (" + name + ")";
            logger.debug((Object)msg);
            GridBeanNotGotFaultType fault = GridBeanNotGotFaultType.Factory.newInstance();
            fault.setTimestamp(Calendar.getInstance());
            fault.addNewDescription().setStringValue(msg);
            throw new BaseFault(msg, (BaseFaultType)fault);
        }
        logger.debug((Object)("Found resource " + name + " at " + file));
        GetGridBeanResponseDocument response = GetGridBeanResponseDocument.Factory.newInstance();
        byte[] result = null;
        try {
            result = GridBeanServiceImpl.readBytesFromFile(file);
            response.addNewGetGridBeanResponse().setContents(result);
        }
        catch (IOException e) {
            LogUtil.logException((String)("Could not load GridBean " + name), (Throwable)e, (Logger)logger);
        }
        return response;
    }

    @Override
    public GetGridBeanInfoResponseDocument GetGridBeanInfo(GetGridBeanInfoDocument request) throws BaseFault {
        String gridBeanPath = this.getGridBeanPath();
        if (gridBeanPath == null) {
            String msg = "GridBean directory is not set";
            logger.error((Object)msg);
            GridBeanInfoNotGotFaultType fault = GridBeanInfoNotGotFaultType.Factory.newInstance();
            fault.setTimestamp(Calendar.getInstance());
            fault.addNewDescription().setStringValue(msg);
            throw new BaseFault(msg, (BaseFaultType)fault);
        }
        File gridBeanDir = new File(gridBeanPath);
        if (!gridBeanDir.exists() || !gridBeanDir.isDirectory()) {
            String msg = "GridBean directory does not exist (" + gridBeanPath + ")";
            logger.error((Object)msg);
            GridBeanInfoNotGotFaultType fault = GridBeanInfoNotGotFaultType.Factory.newInstance();
            fault.setTimestamp(Calendar.getInstance());
            fault.addNewDescription().setStringValue(msg);
            throw new BaseFault(msg, (BaseFaultType)fault);
        }
        String name = request.getGetGridBeanInfo().getName();
        File file = new File(gridBeanDir, name + "GridBean.jar");
        if (!file.exists()) {
            String msg = "GridBean does not exist (" + name + ")";
            logger.error((Object)msg);
            GridBeanInfoNotGotFaultType fault = GridBeanInfoNotGotFaultType.Factory.newInstance();
            fault.setTimestamp(Calendar.getInstance());
            fault.addNewDescription().setStringValue(msg);
            throw new BaseFault(msg, (BaseFaultType)fault);
        }
        logger.debug((Object)("Found resource " + name + " at " + file));
        GetGridBeanInfoResponseDocument response = GetGridBeanInfoResponseDocument.Factory.newInstance();
        response.addNewGetGridBeanInfoResponse();
        GridBeanDescriptionType gridBeanInfo = null;
        try {
            gridBeanInfo = this.getGridBeanDescription(file);
            response.getGetGridBeanInfoResponse().setGridBeanInfo(gridBeanInfo);
        }
        catch (Exception e) {
            String msg = "Cannot get GridBean (" + name + ")";
            logger.error((Object)msg);
            GridBeanInfoNotGotFaultType fault = GridBeanInfoNotGotFaultType.Factory.newInstance();
            fault.setTimestamp(Calendar.getInstance());
            fault.addNewDescription().setStringValue(msg);
            throw new BaseFault(msg, (Throwable)e, (BaseFaultType)fault);
        }
        return response;
    }

    @Override
    public ListGridBeansResponseDocument ListGridBeans(ListGridBeansDocument request) throws BaseFault {
        String gridBeanPath = this.getGridBeanPath();
        if (gridBeanPath == null) {
            String msg = "GridBean directory is not set";
            logger.error((Object)msg);
            GridBeansNotListedFaultType fault = GridBeansNotListedFaultType.Factory.newInstance();
            fault.setTimestamp(Calendar.getInstance());
            fault.addNewDescription().setStringValue(msg);
            throw new BaseFault(msg, (BaseFaultType)fault);
        }
        File gridBeanDir = new File(gridBeanPath);
        if (!gridBeanDir.exists() || !gridBeanDir.isDirectory()) {
            String msg = "GridBean directory does not exist (" + gridBeanPath + ")";
            logger.error((Object)msg);
            GridBeansNotListedFaultType fault = GridBeansNotListedFaultType.Factory.newInstance();
            fault.setTimestamp(Calendar.getInstance());
            fault.addNewDescription().setStringValue(msg);
            throw new BaseFault(msg, (BaseFaultType)fault);
        }
        File[] files = gridBeanDir.listFiles();
        ArrayList<GridBeanDescriptionType> gridBeans = new ArrayList<GridBeanDescriptionType>(files.length);
        for (File file : files) {
            if (!file.getName().endsWith("GridBean.jar")) continue;
            try {
                gridBeans.add(this.getGridBeanDescription(file));
            }
            catch (Exception e) {
                LogUtil.logException((String)e.getMessage(), (Throwable)e, (Logger)logger);
            }
        }
        ListGridBeansResponseDocument response = ListGridBeansResponseDocument.Factory.newInstance();
        response.addNewListGridBeansResponse().setAvailableGridBeansArray(gridBeans.toArray(new GridBeanDescriptionType[0]));
        return response;
    }

    private Element getDescriptionElement(File file) throws Exception {
        JarFile jarFile = new JarFile(file);
        ZipEntry entry = jarFile.getEntry("META-INF/gridbean.xml");
        if (entry == null) {
            throw new Exception("Cannot find GridBean description for " + file.getAbsolutePath());
        }
        InputStream is = jarFile.getInputStream(entry);
        Document doc = new XercesDOMAdapter().getDocument(is, false);
        Element root = doc.getDocumentElement();
        return root;
    }

    private static byte[] readBytesFromFile(File file) throws IOException {
        int offset;
        FileInputStream is = new FileInputStream(file);
        long length = file.length();
        if (length > Integer.MAX_VALUE) {
            throw new IOException("File size " + length + " is too large.");
        }
        byte[] bytes = new byte[(int)length];
        int numRead = 0;
        for (offset = 0; offset < bytes.length && (numRead = ((InputStream)is).read(bytes, offset, bytes.length - offset)) >= 0; offset += numRead) {
        }
        if (offset < bytes.length) {
            throw new IOException("Could not completely read file " + file.getName());
        }
        ((InputStream)is).close();
        return bytes;
    }

    protected String getGridBeanPath() {
        UASProperties uasProperties = (UASProperties)this.kernel.getAttribute(UASProperties.class);
        String res = uasProperties.getValue("gridbean.directory");
        return res;
    }
}

