/*
 * Decompiled with CFR 0.152.
 */
package com.intel.gpe.gridbeans;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class ElementUtil {
    public static Element simpleElt(Document doc, String ns, String tag, String value) {
        Element elt = doc.createElementNS(ns, tag);
        elt.appendChild(doc.createTextNode(value));
        return elt;
    }

    public static Element simpleCDATA(Document doc, String ns, String tag, String value) {
        Element elt = doc.createElementNS(ns, tag);
        elt.appendChild(doc.createCDATASection(value));
        return elt;
    }

    public static Element getFirstChildByNameNS(Element elt, String ns, String tag) {
        NodeList children = elt.getChildNodes();
        for (int i = 0; i < children.getLength(); ++i) {
            Element childi;
            if (!(children.item(i) instanceof Element) || !ns.equals((childi = (Element)children.item(i)).getNamespaceURI()) || !tag.equals(childi.getLocalName())) continue;
            return childi;
        }
        return null;
    }

    public static List<Element> getChildElements(Element elt, String ns, String name) {
        ArrayList<Element> result = new ArrayList<Element>();
        NodeList children = elt.getChildNodes();
        for (int i = 0; i < children.getLength(); ++i) {
            Element childi;
            if (!(children.item(i) instanceof Element) || !ns.equals((childi = (Element)children.item(i)).getNamespaceURI()) || !name.equals(childi.getLocalName())) continue;
            result.add(childi);
        }
        return result;
    }

    public static void addOrReplace(Element parent, Element elem) {
        Element old = ElementUtil.getFirstChildByNameNS(parent, elem.getNamespaceURI(), elem.getLocalName());
        if (old != null) {
            parent.replaceChild(elem, old);
        } else {
            parent.appendChild(elem);
        }
    }

    public static String getChildValueString(Element elt, String ns, String tag, String _default) {
        Element child = ElementUtil.getFirstChildByNameNS(elt, ns, tag);
        if (child != null) {
            if (child.getFirstChild() != null) {
                return child.getFirstChild().getNodeValue();
            }
            return "";
        }
        return _default;
    }

    public static Double getChildValueDouble(Element elt, String ns, String tag, Double _default) {
        Element child = ElementUtil.getFirstChildByNameNS(elt, ns, tag);
        if (child != null && child.getFirstChild() != null) {
            return Double.valueOf(child.getFirstChild().getNodeValue());
        }
        return _default;
    }

    public static Float getChildValueFloat(Element elt, String ns, String tag, Float _default) {
        Element child = ElementUtil.getFirstChildByNameNS(elt, ns, tag);
        if (child != null && child.getFirstChild() != null) {
            return Float.valueOf(child.getFirstChild().getNodeValue());
        }
        return _default;
    }

    public static double getChildValue(Element elt, String ns, String tag, double _default) {
        Element child = ElementUtil.getFirstChildByNameNS(elt, ns, tag);
        if (child != null && child.getFirstChild() != null) {
            return Double.parseDouble(child.getFirstChild().getNodeValue());
        }
        return _default;
    }

    public static int getChildValue(Element elt, String ns, String tag, int _default) {
        Element child = ElementUtil.getFirstChildByNameNS(elt, ns, tag);
        if (child != null && child.getFirstChild() != null) {
            try {
                return Integer.parseInt(child.getFirstChild().getNodeValue());
            }
            catch (NumberFormatException nfe) {
                // empty catch block
            }
        }
        return _default;
    }

    public static String getTextValue(Element elt) {
        if (elt.getFirstChild() == null) {
            return "";
        }
        return elt.getFirstChild().getNodeValue();
    }

    public static String getAttributeValue(Element elt, String attrName, String _default) {
        String attr = elt.getAttribute(attrName);
        if (attr == null || attr == "") {
            return _default;
        }
        return attr;
    }

    public static Document readDocument(InputStream in) throws SAXException, IOException, ParserConfigurationException {
        DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
        dbf.setNamespaceAware(true);
        return dbf.newDocumentBuilder().parse(in);
    }
}

