/*
 * Decompiled with CFR 0.152.
 */
package pl.edu.icm.unicore.accounting.processor.persistence;

import de.fzj.unicore.persist.Persist;
import de.fzj.unicore.persist.PersistenceException;
import de.fzj.unicore.persist.PersistenceFactory;
import de.fzj.unicore.persist.PersistenceProperties;
import de.fzj.unicore.xnjs.Configuration;
import java.util.Set;
import org.apache.log4j.Logger;
import pl.edu.icm.unicore.accounting.processor.persistence.PendingRecord;

public class PendingRecordsDAO {
    private static final Logger logger = Logger.getLogger(PendingRecordsDAO.class);
    public static final String TABLE = "PENDING_RECORDS";
    private Persist<PendingRecord> records;

    public PendingRecordsDAO(Configuration configuration) throws PersistenceException {
        PersistenceProperties config = new PersistenceProperties();
        config.setProperties(configuration.getProperties());
        String stateDir = configuration.getProperty("XNJS.statedir");
        if (stateDir != null) {
            logger.debug((Object)("Using " + stateDir + " as accounting data state directory"));
            config.setProperty("directory", stateDir);
        } else {
            logger.warn((Object)"Using default (temp) location to store accounting data. Set XNJS.statedir to fix this");
        }
        config.setProperty("cache.enable", "true");
        this.records = PersistenceFactory.get((PersistenceProperties)config).getPersist(PendingRecord.class);
    }

    public void addRecord(String ur, String id) {
        logger.trace((Object)("Inserting record: " + ur));
        PendingRecord record = new PendingRecord();
        record.setRecord(ur);
        record.setUniqueID(TABLE + id);
        this.save(record);
    }

    public void removeRecord(String recordId) {
        logger.trace((Object)("Removing record: " + recordId));
        try {
            this.records.remove(recordId);
        }
        catch (PersistenceException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
    }

    public PendingRecord getRecord() throws PersistenceException {
        Set ids = this.records.getIDs();
        if (ids.isEmpty()) {
            return null;
        }
        String id = (String)ids.iterator().next();
        return (PendingRecord)this.records.read(id);
    }

    public int size() throws PersistenceException {
        return this.records.getIDs().size();
    }

    private void save(PendingRecord record) {
        logger.trace((Object)"Saving pending record");
        if (this.records == null) {
            throw new IllegalStateException("Pending records isn't initialized!");
        }
        try {
            this.records.write((Object)record);
        }
        catch (PersistenceException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
    }
}

