/*
 * Decompiled with CFR 0.152.
 */
package pl.edu.icm.unicore.accounting.processor;

import de.fzj.unicore.persist.PersistenceException;
import de.fzj.unicore.xnjs.Configuration;
import de.fzj.unicore.xnjs.management.Lifecycle;
import java.util.Enumeration;
import java.util.Properties;
import org.apache.log4j.Logger;
import pl.edu.icm.unicore.accounting.commons.jms.JMSFactory;
import pl.edu.icm.unicore.accounting.commons.jms.JMSSender;
import pl.edu.icm.unicore.accounting.processor.JobJMSSender;
import pl.edu.icm.unicore.accounting.processor.persistence.PendingRecord;
import pl.edu.icm.unicore.accounting.processor.persistence.PendingRecordsDAO;

@Lifecycle(isSingleton=true)
public class JobJMSSenderImpl
implements JobJMSSender {
    private static final Logger logger = Logger.getLogger(JobJMSSenderImpl.class);
    public static final int WARN_THRESHOLD = 1000;
    public static final int INFO_THRESHOLD = 20;
    public static final int THREAD_SLEEP_PERIOD = 30000;
    private JMSSender jms = null;
    private Thread senderThread;
    private Object waitLock = new Object();
    private PendingRecordsDAO pendingRecordsDAO;

    public JobJMSSenderImpl(Configuration cfg) throws PersistenceException {
        Properties jmsProps = this.filterProperties(cfg.getProperties());
        this.jms = (JMSSender)JMSFactory.getProducer((Properties)jmsProps);
        this.pendingRecordsDAO = new PendingRecordsDAO(cfg);
        this.senderThread = new Thread((Runnable)new SenderThread(), "JMS Sender Queue");
        this.senderThread.setDaemon(true);
        this.senderThread.start();
    }

    private Properties filterProperties(Properties src) {
        Properties properties = src;
        Enumeration<?> propertyNames = properties.propertyNames();
        Properties newProperties = new Properties();
        while (propertyNames.hasMoreElements()) {
            String propName = (String)propertyNames.nextElement();
            if (!propName.startsWith("RUS.PROCESSOR.")) continue;
            newProperties.put(propName.substring("RUS.PROCESSOR.".length()), src.getProperty(propName));
        }
        return newProperties;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean send(String msg, String id) {
        String string = msg;
        synchronized (string) {
            this.pendingRecordsDAO.addRecord(msg, id);
            Object object = this.waitLock;
            synchronized (object) {
                this.waitLock.notify();
            }
        }
        return true;
    }

    private class SenderThread
    implements Runnable {
        private SenderThread() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            logger.info((Object)"JMS send queue started...");
            while (true) {
                int processed = 0;
                while (true) {
                    PendingRecord record;
                    try {
                        record = JobJMSSenderImpl.this.pendingRecordsDAO.getRecord();
                    }
                    catch (PersistenceException e) {
                        logger.error((Object)"Problem geting pending usage records from DB", (Throwable)e);
                        break;
                    }
                    if (record == null) break;
                    boolean result = JobJMSSenderImpl.this.jms.send(record.getRecord());
                    if (!result) {
                        logger.debug((Object)"Cannot send record - going to sleep");
                        break;
                    }
                    JobJMSSenderImpl.this.pendingRecordsDAO.removeRecord(record.getUniqueID());
                    ++processed;
                }
                logger.debug((Object)("In this round " + processed + " accounting records were sent to the broker"));
                try {
                    int size = JobJMSSenderImpl.this.pendingRecordsDAO.size();
                    if (size > 1000) {
                        logger.warn((Object)("There is " + size + " pending messsages to send. " + "Please check JMS broker connection."));
                    } else if (size > 20) {
                        logger.info((Object)("There is " + size + " pending messsages to send. " + "Please check JMS broker connection."));
                    }
                }
                catch (PersistenceException e1) {
                    logger.error((Object)"Problem geting pending usage records number from DB", (Throwable)e1);
                }
                try {
                    Object e1 = JobJMSSenderImpl.this.waitLock;
                    synchronized (e1) {
                        JobJMSSenderImpl.this.waitLock.wait(30000L);
                        continue;
                    }
                }
                catch (InterruptedException interruptedException) {
                    continue;
                }
                break;
            }
        }
    }
}

