/*
 * Decompiled with CFR 0.152.
 */
package pl.edu.icm.unicore.accounting.processor;

import de.fzj.unicore.xnjs.Configuration;
import de.fzj.unicore.xnjs.ems.ActionResult;
import de.fzj.unicore.xnjs.ems.ProcessingException;
import de.fzj.unicore.xnjs.util.LogUtil;
import eu.unicore.security.Client;
import java.net.InetAddress;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.UUID;
import org.apache.log4j.Logger;
import org.gridforum.x2003.urWg.JobIdentityDocument;
import org.gridforum.x2003.urWg.MachineNameDocument;
import org.gridforum.x2003.urWg.RecordIdentityDocument;
import org.gridforum.x2003.urWg.ResourceType;
import org.gridforum.x2003.urWg.StatusDocument;
import org.gridforum.x2003.urWg.SubmitHostDocument;
import org.gridforum.x2003.urWg.TimeInstantDocument;
import org.gridforum.x2003.urWg.UsageRecordDocument;
import org.gridforum.x2003.urWg.UsageRecordType;
import org.gridforum.x2003.urWg.UserIdentityDocument;
import org.klomp.snark.bencode.BEncoder;
import pl.edu.icm.unicore.accounting.processor.JobJMSSender;
import pl.edu.icm.unicore.accounting.processor.ProcessorAdapter;
import pl.edu.icm.unicore.accounting.types.RecordOrigin;
import pl.edu.icm.unicore.accounting.types.URXmlOptions;
import pl.edu.icm.unicore.accounting.types.UsageRecordStatus;

public class AccountingJobProcessor
extends ProcessorAdapter {
    private static final Logger logger = LogUtil.getLogger((String)AccountingJobProcessor.class.getCanonicalName(), (String)"");
    public static final String PROPS_PREFIX = "RUS.PROCESSOR.";
    public static final String ACCOUNTING_SENT_PFX = "accounting.sent.";
    private JobJMSSender jms;

    public AccountingJobProcessor(Configuration configuration, JobJMSSender jms) {
        super(configuration);
        this.jms = jms;
    }

    public AccountingJobProcessor(Configuration configuration) {
        super(configuration);
        this.jms = (JobJMSSender)configuration.getComponentInstanceOfType(JobJMSSender.class);
        if (this.jms == null) {
            throw new RuntimeException("Can not initialize accounting processor - JMS subsystem is not available");
        }
    }

    @Override
    protected void handleQueued() throws ProcessingException {
        this.handleProcessing();
    }

    @Override
    protected void handleRunning() throws ProcessingException {
        if (this.action.getStatus() != 5) {
            return;
        }
        this.handleProcessing();
    }

    @Override
    protected void handlePostProcessing() throws ProcessingException {
        UsageRecordStatus status = this.getStatus();
        if (status != null && status.isTerminal()) {
            this.handleProcessing();
        }
    }

    @Override
    protected void done() throws ProcessingException {
        if (this.action.getStatus() != 7) {
            return;
        }
        try {
            this.handleProcessing();
        }
        catch (Exception ex) {
            logger.error((Object)"Error when processing action state.", (Throwable)ex);
        }
    }

    private void handleProcessing() throws ProcessingException {
        UsageRecordStatus statusEnum = this.getStatus();
        String status = statusEnum == null ? "unknown" : statusEnum.toString();
        Boolean haveSent = (Boolean)this.action.getProcessingContext().get((Object)(ACCOUNTING_SENT_PFX + status));
        if (haveSent == null) {
            UsageRecordType usageRecord = this.createUsageRecord(statusEnum);
            this.sendUsageRecord(usageRecord);
            this.action.getProcessingContext().put((Object)(ACCOUNTING_SENT_PFX + status), (Object)Boolean.TRUE);
            this.action.setDirty();
        }
    }

    protected UsageRecordType createUsageRecord(UsageRecordStatus statusToBeApplied) {
        UsageRecordDocument document = UsageRecordDocument.Factory.newInstance();
        UsageRecordType usageRecord = document.addNewUsageRecord();
        RecordIdentityDocument.RecordIdentity recordIdentity = usageRecord.addNewRecordIdentity();
        recordIdentity.setCreateTime(Calendar.getInstance());
        recordIdentity.setRecordId(UUID.randomUUID().toString());
        ResourceType originRes = usageRecord.addNewResource();
        originRes.setDescription("record_origin");
        originRes.setStringValue(RecordOrigin.unicorex.toString());
        JobIdentityDocument.JobIdentity jobIdentity = usageRecord.addNewJobIdentity();
        jobIdentity.setGlobalJobId(this.action.getUUID());
        String bsid = this.action.getBSID();
        if (bsid != null) {
            jobIdentity.setLocalJobId(bsid);
        }
        UserIdentityDocument.UserIdentity userIdentity = usageRecord.addNewUserIdentity();
        userIdentity.setLocalUserId(this.action.getClient().getSelectedXloginName());
        userIdentity.setGlobalUserName(this.action.getClient().getDistinguishedName());
        StatusDocument.Status status = usageRecord.addNewStatus();
        if (statusToBeApplied != null) {
            status.setStringValue(statusToBeApplied.name());
        } else {
            status.setStringValue("unknown");
        }
        if (UsageRecordStatus.queued.equals((Object)statusToBeApplied)) {
            TimeInstantDocument.TimeInstant qtime = usageRecord.addNewTimeInstant();
            qtime.setType("uxToBssSubmitTime");
            qtime.setCalendarValue(Calendar.getInstance());
        }
        if (UsageRecordStatus.started.equals((Object)statusToBeApplied)) {
            TimeInstantDocument.TimeInstant stime = usageRecord.addNewTimeInstant();
            stime.setType("uxStartTime");
            stime.setCalendarValue(Calendar.getInstance());
        }
        if (statusToBeApplied != null && statusToBeApplied.isTerminal()) {
            TimeInstantDocument.TimeInstant etime = usageRecord.addNewTimeInstant();
            etime.setType("uxEndTime");
            etime.setCalendarValue(Calendar.getInstance());
        }
        ResourceType infrastructureResource = usageRecord.addNewResource();
        infrastructureResource.setDescription("infrastructure");
        infrastructureResource.setStringValue("unicore");
        String machineName = this.configuration.getProperty("RUS.bssMachine");
        if (machineName == null) {
            machineName = this.configuration.getProperty("CLASSICTSI.machine");
        }
        if (machineName != null) {
            MachineNameDocument.MachineName machineNameXml = usageRecord.addNewMachineName();
            machineNameXml.setStringValue(machineName);
        }
        String siteName = this.configuration.getProperty("RUS.site.name");
        ResourceType siteNameResource = usageRecord.addNewResource();
        siteNameResource.setDescription("sitename");
        if (siteName != null) {
            siteNameResource.setStringValue(siteName);
        } else {
            siteNameResource.setStringValue(machineName);
        }
        SubmitHostDocument.SubmitHost submitHost = usageRecord.addNewSubmitHost();
        submitHost.setStringValue(this.establishHostname(this.configuration));
        AccountingJobProcessor.handleVOAndAttributes(this.action.getClient(), usageRecord);
        if (logger.isTraceEnabled()) {
            logger.trace((Object)("New usage record: " + document.xmlText(URXmlOptions.getOptions())));
        } else if (logger.isDebugEnabled()) {
            StringBuilder sb = new StringBuilder();
            sb.append("New usage record:");
            if (jobIdentity.getGlobalJobId() != null) {
                sb.append(" [actionUUID=");
                sb.append(jobIdentity.getGlobalJobId());
                sb.append("]");
            }
            if (jobIdentity.getLocalJobId() != null) {
                sb.append(" [BSID=");
                sb.append(jobIdentity.getLocalJobId());
                sb.append("]");
            }
            logger.debug((Object)sb.toString());
        }
        return usageRecord;
    }

    private String establishHostname(Configuration config) {
        String hostName = config.getProperty("RUS.ce.node.name");
        if (hostName != null) {
            logger.debug((Object)("CE node name=" + hostName));
            return hostName;
        }
        hostName = "localhost";
        try {
            hostName = InetAddress.getLocalHost().getCanonicalHostName();
        }
        catch (Exception e) {
            logger.error((Object)("Can't establish local host name: " + e.getMessage()), (Throwable)e);
        }
        logger.debug((Object)("CE node name=" + hostName));
        return hostName;
    }

    private UsageRecordStatus getStatus() {
        switch (this.action.getStatus()) {
            case 7: {
                ActionResult result = this.action.getResult();
                if (result == null) break;
                if (3 == result.getStatusCode()) {
                    return UsageRecordStatus.completed;
                }
                if (2 == result.getStatusCode()) {
                    return UsageRecordStatus.failed;
                }
                if (1 == result.getStatusCode()) {
                    return UsageRecordStatus.aborted;
                }
                logger.warn((Object)("Reporting finished action with UNKNOWN result as failed, action: " + this.action.getUUID() + ", bss id: " + this.action.getBSID()));
                return UsageRecordStatus.failed;
            }
            case 5: {
                return UsageRecordStatus.started;
            }
            case 22: {
                return UsageRecordStatus.queued;
            }
        }
        return null;
    }

    public static void handleVOAndAttributes(Client client, UsageRecordType usageRecord) {
        String[] allVos;
        if (client == null) {
            return;
        }
        String voS = client.getVo();
        if (voS != null) {
            ResourceType vo = usageRecord.addNewResource();
            vo.setDescription("vo");
            vo.setStringValue(voS);
        }
        HashMap<String, List<String>> attributes = new HashMap<String, List<String>>();
        if (client.getRole() != null) {
            String role = client.getRole().getName();
            attributes.put("role", Collections.singletonList(role));
        }
        if ((allVos = client.getVos()) != null && allVos.length > 0) {
            attributes.put("VOs", Arrays.asList(allVos));
        }
        if (attributes.size() > 0) {
            ResourceType uvosAttributes = usageRecord.addNewResource();
            uvosAttributes.setDescription("attributes");
            String serialized = BEncoder.bencode(attributes);
            uvosAttributes.setStringValue(serialized);
        }
    }

    protected void sendUsageRecord(UsageRecordType usageRecord) {
        String xmlText = usageRecord.xmlText(URXmlOptions.getOptions());
        boolean result = this.jms.send(xmlText, usageRecord.getRecordIdentity().getRecordId());
        if (!result) {
            logger.error((Object)"Unable to send record via JMS.");
        }
    }
}

