/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.security.token;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Arrays;
import org.apache.commons.codec.binary.Base64;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.io.DataInputBuffer;
import org.apache.hadoop.io.DataOutputBuffer;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.io.WritableComparator;
import org.apache.hadoop.io.WritableUtils;
import org.apache.hadoop.security.token.SecretManager;
import org.apache.hadoop.security.token.TokenIdentifier;

@InterfaceAudience.LimitedPrivate(value={"HDFS", "MapReduce"})
@InterfaceStability.Evolving
public class Token<T extends TokenIdentifier>
implements Writable {
    private byte[] identifier;
    private byte[] password;
    private Text kind;
    private Text service;

    public Token(T id, SecretManager<T> mgr) {
        this.password = mgr.createPassword(id);
        this.identifier = ((TokenIdentifier)id).getBytes();
        this.kind = ((TokenIdentifier)id).getKind();
        this.service = new Text();
    }

    public Token(byte[] identifier, byte[] password, Text kind, Text service) {
        this.identifier = identifier;
        this.password = password;
        this.kind = kind;
        this.service = service;
    }

    public Token() {
        this.identifier = new byte[0];
        this.password = new byte[0];
        this.kind = new Text();
        this.service = new Text();
    }

    public byte[] getIdentifier() {
        return this.identifier;
    }

    public byte[] getPassword() {
        return this.password;
    }

    public Text getKind() {
        return this.kind;
    }

    public Text getService() {
        return this.service;
    }

    public void setService(Text newService) {
        this.service = newService;
    }

    @Override
    public void readFields(DataInput in) throws IOException {
        int len = WritableUtils.readVInt(in);
        if (this.identifier == null || this.identifier.length != len) {
            this.identifier = new byte[len];
        }
        in.readFully(this.identifier);
        len = WritableUtils.readVInt(in);
        if (this.password == null || this.password.length != len) {
            this.password = new byte[len];
        }
        in.readFully(this.password);
        this.kind.readFields(in);
        this.service.readFields(in);
    }

    @Override
    public void write(DataOutput out) throws IOException {
        WritableUtils.writeVInt(out, this.identifier.length);
        out.write(this.identifier);
        WritableUtils.writeVInt(out, this.password.length);
        out.write(this.password);
        this.kind.write(out);
        this.service.write(out);
    }

    private static String encodeWritable(Writable obj) throws IOException {
        DataOutputBuffer buf = new DataOutputBuffer();
        obj.write(buf);
        Base64 encoder = new Base64(0, null, true);
        byte[] raw = new byte[buf.getLength()];
        System.arraycopy(buf.getData(), 0, raw, 0, buf.getLength());
        return encoder.encodeToString(raw);
    }

    private static void decodeWritable(Writable obj, String newValue) throws IOException {
        Base64 decoder = new Base64(0, null, true);
        DataInputBuffer buf = new DataInputBuffer();
        byte[] decoded = decoder.decode(newValue);
        buf.reset(decoded, decoded.length);
        obj.readFields(buf);
    }

    public String encodeToUrlString() throws IOException {
        return Token.encodeWritable(this);
    }

    public void decodeFromUrlString(String newValue) throws IOException {
        Token.decodeWritable(this, newValue);
    }

    public boolean equals(Object right) {
        if (this == right) {
            return true;
        }
        if (right == null || this.getClass() != right.getClass()) {
            return false;
        }
        Token r = (Token)right;
        return Arrays.equals(this.identifier, r.identifier) && Arrays.equals(this.password, r.password) && this.kind.equals(r.kind) && this.service.equals(r.service);
    }

    public int hashCode() {
        return WritableComparator.hashBytes(this.identifier, this.identifier.length);
    }

    private static void addBinaryBuffer(StringBuilder buffer, byte[] bytes) {
        for (int idx = 0; idx < bytes.length; ++idx) {
            String num;
            if (idx != 0) {
                buffer.append(' ');
            }
            if ((num = Integer.toHexString(0xFF & bytes[idx])).length() < 2) {
                buffer.append('0');
            }
            buffer.append(num);
        }
    }

    public String toString() {
        StringBuilder buffer = new StringBuilder();
        buffer.append("Ident: ");
        Token.addBinaryBuffer(buffer, this.identifier);
        buffer.append(", Pass: ");
        Token.addBinaryBuffer(buffer, this.password);
        buffer.append(", Kind: ");
        buffer.append(this.kind.toString());
        buffer.append(", Service: ");
        buffer.append(this.service.toString());
        return buffer.toString();
    }
}

