/*
 * Decompiled with CFR 0.152.
 */
package org.dcache.srm.util;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.net.UnknownHostException;
import java.sql.SQLException;
import org.apache.log4j.Logger;
import org.dcache.srm.util.Tools;

public class Pgpass {
    private static final Logger _logger = Logger.getLogger(Pgpass.class);
    private String _pwdfile;
    private String _hostname;
    private String _port;
    private String _database;
    private static final String legalFormats = "\n supported jdbc url formats:\n jdbc:postgresql:database\n jdbc:postgresql://host/database\n jdbc:postgresql://host:port/database\n";

    public Pgpass(String pwdfile) {
        this._pwdfile = pwdfile;
    }

    private String process(String line, String hostname, String port, String database, String username) {
        if (line.charAt(0) != '#') {
            String[] sa = line.split(":");
            boolean hostMatched = sa[0].equals("*");
            if (!hostMatched) {
                try {
                    hostMatched = Tools.sameHost(sa[0], hostname);
                }
                catch (UnknownHostException uhe) {
                    _logger.warn((Object)uhe.toString());
                }
            }
            if (hostMatched && (sa[1].equals("*") || sa[1].equals(port)) && (sa[2].equals("*") || sa[2].equals(database)) && (sa[3].equals("*") || sa[3].equals(username))) {
                return sa[4];
            }
        }
        return null;
    }

    private void parseUrl(String url) throws SQLException {
        String[] r = url.split("/");
        this._hostname = "localhost";
        this._port = "5432";
        if (r.length == 1) {
            String[] r1 = r[0].split(":");
            this._database = r1[r1.length - 1];
        } else if (r.length == 4) {
            this._database = r[r.length - 1];
            String[] r1 = r[2].split(":");
            this._hostname = r1[0];
            if (r1.length == 2) {
                this._port = r1[1];
            } else if (r1.length > 2) {
                String error = "illegal jdbc url format: " + url + legalFormats;
                _logger.error((Object)error);
                throw new SQLException(error);
            }
        } else {
            String error = "illegal jdbc url format: " + url + legalFormats;
            _logger.error((Object)error);
            throw new SQLException(error);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getPgpass(String hostname, String port, String database, String username) throws SQLException {
        try {
            String reply;
            Process p1 = Runtime.getRuntime().exec("stat -c '%a' " + this._pwdfile);
            BufferedReader stdInput = new BufferedReader(new InputStreamReader(p1.getInputStream()));
            BufferedReader stdError = new BufferedReader(new InputStreamReader(p1.getErrorStream()));
            PrintWriter stdOutput = new PrintWriter(new BufferedWriter(new OutputStreamWriter(p1.getOutputStream())));
            try {
                reply = stdInput.readLine();
                try {
                    p1.waitFor();
                }
                catch (InterruptedException x) {
                    throw new SQLException("Cannot stat '" + this._pwdfile + "'");
                }
            }
            finally {
                stdInput.close();
                stdError.close();
                stdOutput.close();
            }
            if (reply == null) {
                throw new SQLException("Cannot stat '" + this._pwdfile + "'");
            }
            if (!reply.equals("'600'")) {
                throw new SQLException("Protection for '" + this._pwdfile + "' must be '600'");
            }
            BufferedReader in = new BufferedReader(new FileReader(this._pwdfile));
            String r = null;
            try {
                String line;
                while ((line = in.readLine()) != null && r == null) {
                    r = this.process(line, hostname, port, database, username);
                }
            }
            finally {
                in.close();
            }
            if (r == null) {
                String error = String.format("could not get password from '%s' for  hostname: '%s' ,port: %s ,database: '%s' and username: '%s' ", this._pwdfile, hostname, port, database, username);
                throw new SQLException(error);
            }
            return r;
        }
        catch (IOException ioe) {
            throw new SQLException("processing '" + this._pwdfile + "' failed: I/O error", ioe);
        }
    }

    public String getPgpass(String url, String username) throws SQLException {
        this.parseUrl(url);
        return this.getPgpass(this._hostname, this._port, this._database, username);
    }

    public String getHostname() {
        return this._hostname;
    }

    public String getPort() {
        return this._port;
    }

    public String getDatabase() {
        return this._database;
    }
}

