/*
 * Decompiled with CFR 0.152.
 */
package org.dcache.srm.util;

import java.util.HashMap;
import java.util.Map;

public class OptionMap<Type> {
    private Map<String, Type> _optionMap = new HashMap<String, Type>();

    public OptionMap(Factory<Type> f, String[] argList) {
        for (int i = 0; i < argList.length; ++i) {
            try {
                String name = this.parseName(argList[i]);
                String value = this.parseValue(argList[i]);
                Type t = f.make(name, value);
                this.set(name, t);
                continue;
            }
            catch (NonComplientArgument ex) {
                // empty catch block
            }
        }
    }

    public OptionMap() {
    }

    public Type get(String argValue) {
        return this._optionMap.get(argValue);
    }

    public void set(String argName, Type argValue) {
        this._optionMap.put(argName, argValue);
    }

    private String parseName(String arg) throws NonComplientArgument {
        int pos;
        if (arg.indexOf("--") == 0 && (pos = arg.indexOf("=")) > 0 && pos < arg.length()) {
            return arg.substring(2, pos);
        }
        throw new NonComplientArgument();
    }

    private String parseValue(String arg) throws NonComplientArgument {
        int pos;
        if (arg.indexOf("--") == 0 && (pos = arg.indexOf("=")) > 0 && pos < arg.length()) {
            return arg.substring(pos + 1, arg.length());
        }
        throw new NonComplientArgument();
    }

    public static void main(String[] argList) {
        String[] intAttrs = new String[]{"attr1", "attr2", "attr3", "otherarg"};
        String[] args = new String[]{"--attr1=1", "--attr2=2", "--attr3=3", "--otherarg=aaa"};
        OptionMap<Integer> intMap = new OptionMap<Integer>(new IntFactory(intAttrs), args);
        System.out.println(intMap.get("attr1") + intMap.get("attr3") + intMap.get("attr2"));
        OptionMap<String> sMap = new OptionMap<String>(new StringFactory(), args);
        System.out.println(sMap.get("attr1") + sMap.get("attr3") + sMap.get("attr2") + sMap.get("otherarg"));
    }

    public static class IntFactory
    extends ConstrainedFactoryImpl<Integer> {
        public IntFactory(String[] mustBeIntAttributes) {
            super(mustBeIntAttributes);
        }

        @Override
        public Integer make(String value) throws NonComplientArgument {
            return Integer.valueOf(value);
        }
    }

    public static class StringFactory
    implements Factory<String> {
        @Override
        public String make(String name, String value) {
            return value;
        }
    }

    static abstract class ConstrainedFactoryImpl<Type>
    implements Factory<Type>,
    ConstrainedFactory<Type> {
        private String[] mustBeIntAttributes;

        ConstrainedFactoryImpl(String[] mustBeIntAttributes) {
            this.mustBeIntAttributes = mustBeIntAttributes;
        }

        @Override
        public Type make(String name, String value) throws NonComplientArgument {
            for (int i = 0; i < this.mustBeIntAttributes.length; ++i) {
                if (!this.mustBeIntAttributes[i].equals(name)) continue;
                return (Type)this.make(value);
            }
            throw new NonComplientArgument();
        }
    }

    public static interface ConstrainedFactory<T> {
        public T make(String var1) throws NonComplientArgument;
    }

    public static interface Factory<T> {
        public T make(String var1, String var2) throws NonComplientArgument;
    }

    static class NonComplientArgument
    extends Exception {
        NonComplientArgument() {
        }
    }
}

